/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.mcrdws;

import com.mathworks.webservices.client.core.ClientConfiguration;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.client.core.MathWorksWebServiceClient;
import com.mathworks.webservices.client.core.http.EntityEnclosingRequest;
import com.mathworks.webservices.client.core.http.HttpMethodName;
import com.mathworks.webservices.client.core.http.HttpRequest;
import com.mathworks.webservices.client.core.http.MathWorksHttpClient;
import com.mathworks.webservices.client.core.http.RequestContent;
import com.mathworks.webservices.client.core.http.ResponseHandler;
import com.mathworks.webservices.client.core.xml.JaxbResponseHandler;
import com.mathworks.webservices.mcrdws.MCRDWSclient;
import com.mathworks.webservices.mcrdws.model.Components;
import com.mathworks.webservices.mcrdws.model.ReleaseData;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class MCRDWSclientImpl
extends MathWorksWebServiceClient
implements MCRDWSclient {
    private JAXBContext jc = null;
    private Marshaller marshaller = null;

    public MCRDWSclientImpl() {
        this(new ClientConfiguration());
    }

    public MCRDWSclientImpl(ClientConfiguration clientConfiguration) {
        super(clientConfiguration, (ResponseHandler)new JaxbResponseHandler("com.mathworks.webservices.mcrdws.model"));
    }

    public MCRDWSclientImpl(MathWorksHttpClient httpClient) {
        super(httpClient, (ResponseHandler)new JaxbResponseHandler("com.mathworks.webservices.mcrdws.model"));
    }

    private void initializeMarshaller() throws JAXBException {
        this.jc = JAXBContext.newInstance((Class[])new Class[]{Components.class});
        this.marshaller = this.jc.createMarshaller();
    }

    @Override
    public ReleaseData getReleaseData(String releaseName, String arch, String locale, String clientString) throws MathWorksServiceException, MathWorksClientException {
        HttpRequest req = new HttpRequest(HttpMethodName.GET, this.endpoint, "/releasedata/" + releaseName);
        req.withParameter("arch", arch);
        req.setLocale(locale);
        req.setClientString(clientString);
        return (ReleaseData)this.executeRequest(req);
    }

    @Override
    public Components getComponents(Components components, String locale, String clientString) throws MathWorksServiceException, MathWorksClientException {
        EntityEnclosingRequest req = new EntityEnclosingRequest(HttpMethodName.POST, this.endpoint, "/components");
        try {
            if (this.marshaller == null) {
                this.initializeMarshaller();
            }
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            this.marshaller.marshal((Object)components, (OutputStream)b);
            RequestContent requestContent = new RequestContent(b.toByteArray(), "application/xml");
            req.setRequestContent(requestContent);
            req.setLocale(locale);
            req.setClientString(clientString);
        }
        catch (JAXBException e) {
            throw new MathWorksClientException(e.getMessage());
        }
        return (Components)this.executeRequest((HttpRequest)req);
    }
}

