/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocSetItemList;
import com.mathworks.install.command.doc.DocSetItemType;
import com.mathworks.install.command.doc.InstalledDocSetItem;
import com.mathworks.install.command.doc.SharedDocSubCommand;
import com.mathworks.instutil.IO;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.EnumSet;
import java.util.LinkedList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

class SearchIndexCommand
implements SharedDocSubCommand {
    static final FilenameFilter SEARCH_INDEX_FILTER = new SearchIndexFilter();
    static final String MERGED_INDEX_DIR_V2 = "helpsearch-v2";
    static final String PRODUCT_INDEX_DIR = "helpsearch";
    private final DirectoryBuilder dirBuilder;
    private final IO io;

    SearchIndexCommand(IO iO) {
        this(iO, new FileSystemDirectoryBuilder());
    }

    SearchIndexCommand(IO iO, DirectoryBuilder directoryBuilder) {
        this.io = iO;
        this.dirBuilder = directoryBuilder;
    }

    @Override
    public void handleProductsFound(File file, DocSetItemList docSetItemList) throws IOException, InterruptedException {
        this.buildSearchIndex(file, docSetItemList, "");
        for (String string : docSetItemList.getLocaleSuffixes()) {
            this.buildSearchIndex(file, docSetItemList, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildSearchIndex(File file, DocSetItemList docSetItemList, String string) throws IOException {
        File file2 = new File(file, SearchIndexCommand.getMergedIndexDirName(string));
        this.io.deleteDirectory(file2);
        Directory[] directoryArray = this.getSearchIndexesToMerge(file, docSetItemList.getInstalledDocSetItems(EnumSet.allOf(DocSetItemType.class)), string);
        if (directoryArray == null || directoryArray.length == 0) {
            return;
        }
        Directory directory = this.dirBuilder.getDirectory(file2, true);
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(Version.LUCENE_46, (Analyzer)new SimpleAnalyzer(Version.LUCENE_46));
        indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        try (IndexWriter indexWriter = new IndexWriter(directory, indexWriterConfig);){
            indexWriter.addIndexes(directoryArray);
            indexWriter.forceMerge(1);
        }
    }

    @Override
    public void handleNoProducts(File file) throws IOException, InterruptedException {
        File[] fileArray;
        for (File file2 : fileArray = this.io.listFiles(file, SEARCH_INDEX_FILTER)) {
            if (!this.io.isDirectory(file2)) continue;
            this.io.deleteDirectory(file2);
        }
    }

    private Directory[] getSearchIndexesToMerge(File file, Iterable<InstalledDocSetItem> iterable, String string) throws IOException {
        LinkedList<Directory> linkedList = new LinkedList<Directory>();
        for (InstalledDocSetItem installedDocSetItem : iterable) {
            Directory directory;
            File file2 = new File(file, installedDocSetItem.getHelpLoc());
            File file3 = this.findProductIndex(file2, string);
            if (file3 == null || !DirectoryReader.indexExists((Directory)(directory = this.dirBuilder.getDirectory(file3, false)))) continue;
            linkedList.add(directory);
        }
        Directory[] directoryArray = linkedList.toArray(new Directory[linkedList.size()]);
        return directoryArray;
    }

    private static String getMergedIndexDirName(String string) {
        return string == null || string.trim().isEmpty() ? MERGED_INDEX_DIR_V2 : "helpsearch-v2_" + string;
    }

    private static String getSingleProductIndexDirName(String string) {
        return string == null || string.trim().isEmpty() ? PRODUCT_INDEX_DIR : "helpsearch_" + string;
    }

    private File findProductIndex(File file, String string) {
        File file2;
        File file3 = new File(file, SearchIndexCommand.getSingleProductIndexDirName(string));
        if (this.io.isDirectory(file3)) {
            return file3;
        }
        if (string != null && !string.trim().isEmpty() && this.io.isDirectory(file2 = new File(file, SearchIndexCommand.getSingleProductIndexDirName("")))) {
            return file2;
        }
        return null;
    }

    private static class FileSystemDirectoryBuilder
    implements DirectoryBuilder {
        private FileSystemDirectoryBuilder() {
        }

        @Override
        public Directory getDirectory(File file, boolean bl) throws IOException {
            return FSDirectory.open((File)file);
        }
    }

    static interface DirectoryBuilder {
        public Directory getDirectory(File var1, boolean var2) throws IOException;
    }

    private static class SearchIndexFilter
    implements FilenameFilter {
        private SearchIndexFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.startsWith(SearchIndexCommand.PRODUCT_INDEX_DIR);
        }
    }
}

