/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocDestination;
import com.mathworks.install.command.doc.DocSetItemType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

class InstalledDocSetItem {
    private static final String SHORTNAME_PROP = "shortname";
    private static final String DISPLAYNAME_PROP = "displayname";
    private static final String STATUS_PROP = "status";
    private static final String BASEPRODUCT_SHORTNAME_PROP = "baseshortname";
    private static final String TOOLBOX_DIR_PROP = "toolboxdir";
    private final String shortName;
    private final String displayName;
    private final String helpLoc;
    private final Set<DocDestination> destinations;
    private String baseProductShortName;
    private final List<String> altShortNames = new ArrayList<String>();
    private final DocSetItemType type;

    private InstalledDocSetItem(String string, String string2, String string3, String string4, String string5, Collection<String> collection) {
        this.helpLoc = string;
        this.displayName = string2;
        this.shortName = string3;
        this.destinations = InstalledDocSetItem.resolveDestinations(string4);
        this.baseProductShortName = string5;
        this.type = this.baseProductShortName == null || this.baseProductShortName.isEmpty() ? DocSetItemType.PRODUCT : DocSetItemType.ADDON;
        this.altShortNames.addAll(collection);
    }

    static InstalledDocSetItem buildDocSetItem(String string, String string2, String string3, String string4, String string5, String ... stringArray) {
        return new InstalledDocSetItem(string, string2, string3, string4, string5, Arrays.asList(stringArray));
    }

    static InstalledDocSetItem buildDocSetItem(String string, Properties properties) {
        String string2;
        String string3 = properties.getProperty(DISPLAYNAME_PROP);
        String string4 = properties.containsKey(SHORTNAME_PROP) ? properties.getProperty(SHORTNAME_PROP) : string.replaceFirst(".*/", "");
        String string5 = properties.containsKey(STATUS_PROP) ? properties.getProperty(STATUS_PROP) : null;
        String string6 = string2 = properties.containsKey(BASEPRODUCT_SHORTNAME_PROP) ? properties.getProperty(BASEPRODUCT_SHORTNAME_PROP) : null;
        if (properties.containsKey(TOOLBOX_DIR_PROP)) {
            String[] stringArray = new String[]{properties.getProperty(TOOLBOX_DIR_PROP)};
            return InstalledDocSetItem.buildDocSetItem(string, string3, string4, string5, string2, stringArray);
        }
        return InstalledDocSetItem.buildDocSetItem(string, string3, string4, string5, string2, new String[0]);
    }

    private static Set<DocDestination> resolveDestinations(String string) {
        if (string == null || string.trim().isEmpty()) {
            return EnumSet.allOf(DocDestination.class);
        }
        if (string.equalsIgnoreCase("web_only")) {
            return EnumSet.of(DocDestination.WEB);
        }
        if (string.equalsIgnoreCase("install_only")) {
            return EnumSet.of(DocDestination.INSTALL);
        }
        return EnumSet.noneOf(DocDestination.class);
    }

    String getShortName() {
        return this.shortName;
    }

    String getDisplayName() {
        return this.displayName;
    }

    String getHelpLoc() {
        return this.helpLoc;
    }

    String getBaseProductShortName() {
        return this.baseProductShortName;
    }

    Collection<String> getAltShortNames() {
        return Collections.unmodifiableList(this.altShortNames);
    }

    boolean includeProduct(DocDestination docDestination) {
        if (docDestination == DocDestination.INSTALL && this.getType() == DocSetItemType.ADDON) {
            return false;
        }
        return this.destinations.contains((Object)docDestination);
    }

    DocSetItemType getType() {
        return this.type;
    }
}

