/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.vrd.view.config;

import com.mathworks.instwiz.resources.ComponentName;
import com.mathworks.vrd.command.RefreshCommand;
import com.mathworks.vrd.command.RefreshCommandFactory;
import com.mathworks.vrd.command.RefreshStatus;
import com.mathworks.vrd.license.License;
import com.mathworks.vrd.license.LicenseStatus;
import com.mathworks.vrd.model.VRDModel;
import com.mathworks.vrd.resources.VRDComponentName;
import com.mathworks.vrd.view.LicenseList;
import com.mathworks.vrd.view.VRDView;
import com.mathworks.vrd.view.config.LicenseUIConfig;
import com.mathworks.vrd.view.config.SerialAction;
import java.awt.event.ActionListener;
import javax.swing.Action;

final class RefreshUIConfig
implements LicenseUIConfig {
    private final VRDModel fModel;
    private final VRDView fView;
    private final RefreshCommandFactory fFactory;
    private boolean fShowStatus = true;

    RefreshUIConfig(VRDModel vRDModel, VRDView vRDView, RefreshCommandFactory refreshCommandFactory) {
        this.fModel = vRDModel;
        this.fView = vRDView;
        this.fFactory = refreshCommandFactory;
    }

    @Override
    public String getTitle() {
        return this.fView.intlString("welcome.refresh.title");
    }

    @Override
    public String getDescription() {
        return this.fView.intlString("welcome.refresh.text");
    }

    @Override
    public String getListTitle() {
        return this.fView.intlString("welcome.refresh.list");
    }

    @Override
    public String getDisplayedLicenseStatus(License license) {
        if (!this.fModel.canRefresh(license) && license.getLicenseStatus().equals((Object)LicenseStatus.INITIAL)) {
            return this.fView.intlString("status.cannotupdate");
        }
        return license.getLicenseStatus().getDisplayedValue(this.fView);
    }

    @Override
    public boolean isLicenseStatusVisible() {
        return this.fShowStatus;
    }

    @Override
    public void setLicenseStatusVisible(boolean bl) {
        this.fShowStatus = bl;
    }

    @Override
    public boolean isMultiSelectSupported() {
        return false;
    }

    @Override
    public boolean isSelectByDefaultEnabled() {
        return true;
    }

    @Override
    public boolean isDefaultCloseOperationEnabled() {
        return true;
    }

    @Override
    public Action createUIAction(LicenseList licenseList, ActionListener actionListener) {
        String string = this.fView.intlString("welcome.refresh.confirm");
        return new RefreshSerialAction(string, this.fModel, licenseList, this.fFactory, actionListener);
    }

    @Override
    public ComponentName getActionComponentName() {
        return VRDComponentName.REFRESH_UI_ACTION;
    }

    private static class RefreshSerialAction
    extends SerialAction {
        private final RefreshCommandFactory fCmdFactory;

        private RefreshSerialAction(String string, VRDModel vRDModel, LicenseList licenseList, RefreshCommandFactory refreshCommandFactory, ActionListener actionListener) {
            super(string, vRDModel, licenseList, actionListener);
            this.fCmdFactory = refreshCommandFactory;
        }

        @Override
        boolean isActionEnabledOnLicense(VRDModel vRDModel, License license) {
            return vRDModel.canRefresh(license);
        }

        @Override
        void performActionOnLicense(VRDModel vRDModel, License license, LicenseList licenseList) {
            if (vRDModel.canRefresh(license)) {
                RefreshCommand refreshCommand = this.fCmdFactory.createRefreshCommand(true);
                RefreshStatus refreshStatus = refreshCommand.refresh(license);
                licenseList.updateLicense(license);
            }
        }
    }
}

