/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.vrd.model;

import com.mathworks.instutil.IO;
import com.mathworks.instutil.Machine;
import com.mathworks.instutil.licensefiles.LicenseFileFinder;
import com.mathworks.instutil.services.ServiceThreadFactory;
import com.mathworks.mlwebservices.DefaultValidationService;
import com.mathworks.mlwebservices.ValidationService;
import com.mathworks.vrd.license.LicenseFileFilter;
import com.mathworks.vrd.model.VRDModel;
import com.mathworks.vrd.model.VRDModelFactory;
import com.mathworks.vrd.model.VRDModelImpl;
import com.mathworks.vrd.view.VRDView;
import com.mathworks.webproxy.ProxyConfiguration;
import java.net.MalformedURLException;
import java.net.URL;

public class VRDModelFactoryDefault
implements VRDModelFactory {
    static final String SERVICE_LOCATION_PROPERTY = "com.mathworks.vrd.serviceLocation";
    private final VRDView fView;
    private final Machine fMachine;
    private final ValidationService fService;
    private final LicenseFileFinder fFinder;
    private final LicenseFileFilter fFilter;
    private final ServiceThreadFactory serviceThreadFactory;
    private final IO io;

    public VRDModelFactoryDefault(VRDView vRDView, Machine machine, String string, LicenseFileFinder licenseFileFinder, LicenseFileFilter licenseFileFilter, ServiceThreadFactory serviceThreadFactory, IO iO, ProxyConfiguration proxyConfiguration) {
        this.fView = vRDView;
        this.io = iO;
        String string2 = string;
        if (string2 == null) {
            vRDView.logFine("Service location not specified, trying to get from system property com.mathworks.vrd.serviceLocation");
            string2 = System.getProperty(SERVICE_LOCATION_PROPERTY);
            if (string2 != null) {
                vRDView.logFine("Service location found in system property: " + string2);
            } else {
                vRDView.logFine("Service location not found in system property");
            }
        }
        if (string2 != null) {
            try {
                vRDView.logFine("Verifying service location " + string2 + " is a valid URL");
                new URL(string2);
                vRDView.logFine("Service location is a valid URL");
            }
            catch (MalformedURLException malformedURLException) {
                vRDView.logFine("Service location is not a valid URL, using default service location");
                string2 = null;
            }
        }
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "error");
        this.fService = new DefaultValidationService(this.fView.getRelease(), proxyConfiguration);
        this.fService.setEndpointURL(string2);
        this.fMachine = machine;
        this.fFinder = licenseFileFinder;
        this.fFilter = licenseFileFilter;
        this.serviceThreadFactory = serviceThreadFactory;
    }

    public VRDModelFactoryDefault(VRDView vRDView, ValidationService validationService, Machine machine, LicenseFileFinder licenseFileFinder, LicenseFileFilter licenseFileFilter, ServiceThreadFactory serviceThreadFactory, IO iO) {
        this.fView = vRDView;
        this.fService = validationService;
        this.fMachine = machine;
        this.fFinder = licenseFileFinder;
        this.fFilter = licenseFileFilter;
        this.serviceThreadFactory = serviceThreadFactory;
        this.io = iO;
    }

    @Override
    public VRDModel createVRDModel(String string) {
        return new VRDModelImpl(this.fView, this.fService, this.fMachine, this.fFinder, this.fFilter, string, this.serviceThreadFactory, this.io);
    }
}

