/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.vrd.license;

import com.mathworks.instutil.licensefiles.ActivationType;
import com.mathworks.instutil.licensefiles.LicenseOption;
import com.mathworks.vrd.license.License;
import com.mathworks.vrd.license.LicenseStatus;
import java.util.Collection;

public class LicenseImpl
implements License {
    private final String fLicenseNumber;
    private final int fValidationInterval;
    private final String fEncryptionKey;
    private final int fEntitlementId;
    private final ActivationType fActivationType;
    private final LicenseOption fLicenseOption;
    private LicenseStatus fStatus;
    private final String fUserLockingString;
    private final Collection<String> fLockingStringList;

    public LicenseImpl(String string, int n, String string2, int n2, ActivationType activationType, LicenseOption licenseOption, String string3, Collection<String> collection) {
        this.fLicenseNumber = string;
        this.fValidationInterval = n;
        this.fEncryptionKey = string2;
        this.fEntitlementId = n2;
        this.fActivationType = activationType;
        this.fLicenseOption = licenseOption;
        this.fStatus = LicenseStatus.INITIAL;
        this.fUserLockingString = string3;
        this.fLockingStringList = collection;
    }

    @Override
    public String getLicenseNumber() {
        return this.fLicenseNumber;
    }

    @Override
    public int getValidationInterval() {
        return this.fValidationInterval;
    }

    public String getEncryptionKey() {
        return this.fEncryptionKey;
    }

    @Override
    public boolean isSNULicense() {
        return this.fActivationType.isSNU();
    }

    @Override
    public boolean isNetworkLicense() {
        return this.fActivationType.isNetwork();
    }

    @Override
    public int getEntitlementId() {
        return this.fEntitlementId;
    }

    @Override
    public ActivationType getActivationType() {
        return this.fActivationType;
    }

    @Override
    public LicenseOption getLicenseOption() {
        return this.fLicenseOption;
    }

    @Override
    public LicenseStatus getLicenseStatus() {
        return this.fStatus;
    }

    @Override
    public void setLicenseStatus(LicenseStatus licenseStatus) {
        this.fStatus = licenseStatus;
    }

    @Override
    public String getLicenseString() {
        String string;
        block2: {
            string = this.fLicenseNumber;
            try {
                Integer.parseInt(this.fLicenseNumber);
            }
            catch (NumberFormatException numberFormatException) {
                if (this.fEntitlementId <= 0) break block2;
                string = String.valueOf(this.fEntitlementId);
            }
        }
        return string;
    }

    @Override
    public String getUserLockingString() {
        return this.fUserLockingString;
    }

    @Override
    public Collection<String> getLockingStrings() {
        return this.fLockingStringList;
    }
}

