/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.vrd.config;

import com.mathworks.vrd.config.VRDConfig;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Properties;

public abstract class VRDConfigFactory {
    private static final String pluginPropertyName = "com.mathworks.vrd.config.VRDConfigPlugin";
    private static final String configPropertyFileName = "com.mathworks.vrd.config.properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final VRDConfig createConfig() throws Exception {
        VRDConfig vRDConfig = this.createDefaultConfig();
        Properties properties = new Properties(System.getProperties());
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(configPropertyFileName);
            properties.load(fileInputStream);
            vRDConfig.getView().logFine("Properties loaded from file com.mathworks.vrd.config.properties");
        }
        catch (IOException iOException) {
            vRDConfig.getView().logFine("Exception trying to load properties from file com.mathworks.vrd.config.properties: " + iOException.getMessage());
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        String string = properties.getProperty(pluginPropertyName);
        if (string != null) {
            vRDConfig.getView().logInfo("Picked up property com.mathworks.vrd.config.VRDConfigPlugin: " + string);
            try {
                Class<?> clazz = Class.forName(string.trim());
                try {
                    Constructor<?> constructor = clazz.getConstructor(VRDConfig.class, Properties.class);
                    VRDConfig vRDConfig2 = (VRDConfig)constructor.newInstance(vRDConfig, properties);
                    return vRDConfig2;
                }
                catch (Throwable throwable) {
                    vRDConfig.getView().logInfo("Instantiation of " + string + " failed: " + throwable.getMessage());
                    VRDConfig vRDConfig3 = (VRDConfig)clazz.newInstance();
                    return vRDConfig3;
                }
            }
            catch (Throwable throwable) {
                vRDConfig.getView().logInfo("Instantiation of " + string + " failed: " + throwable.getMessage());
            }
        }
        return vRDConfig;
    }

    protected abstract VRDConfig createDefaultConfig() throws Exception;
}

