/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.vrd.command;

import com.mathworks.instutil.FolderUtilsImpl;
import com.mathworks.instutil.MachineInfo;
import com.mathworks.instutil.licensefiles.LicenseFileLocation;
import com.mathworks.instutil.licensefiles.LicenseLocationFactory;
import com.mathworks.instutil.licensefiles.LicenseLocationFactoryImpl;
import com.mathworks.vrd.command.DeactivateCommand;
import com.mathworks.vrd.command.DeactivateCommandImpl;
import com.mathworks.vrd.command.DeactivateStatus;
import com.mathworks.vrd.command.FileIOHandler;
import com.mathworks.vrd.command.FileIOHandlerImpl;
import com.mathworks.vrd.command.RefreshCommand;
import com.mathworks.vrd.command.RefreshStatus;
import com.mathworks.vrd.command.ValidateCommand;
import com.mathworks.vrd.command.ValidateCommandInternal;
import com.mathworks.vrd.command.ValidateStatus;
import com.mathworks.vrd.license.License;
import com.mathworks.vrd.license.LicenseStatus;
import com.mathworks.vrd.model.VRDModel;
import com.mathworks.vrd.view.VRDView;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.Map;

final class RefreshCommandImpl
implements RefreshCommand {
    private final VRDView fView;
    private final VRDModel fModel;
    private final boolean fRequired;
    private final boolean fPromptConfirm;
    private final ValidateCommand vCommand;
    private final DeactivateCommand dCommand;
    private final LicenseLocationFactory licenseLocationFactory;
    private final FileIOHandler fileIOHandler;
    private final Map<ValidateStatus, RefreshStatus> validateStatusMap;
    private final Map<DeactivateStatus, RefreshStatus> deactivateStatusMap;

    RefreshCommandImpl(VRDModel vRDModel, VRDView vRDView, boolean bl, boolean bl2) {
        this(vRDModel, vRDView, bl, bl2, new ValidateCommandInternal(vRDModel, vRDView, true), new DeactivateCommandImpl(vRDModel, vRDView, true, true), (LicenseLocationFactory)new LicenseLocationFactoryImpl(), new FileIOHandlerImpl());
    }

    RefreshCommandImpl(VRDModel vRDModel, VRDView vRDView, boolean bl, boolean bl2, ValidateCommand validateCommand, DeactivateCommand deactivateCommand, LicenseLocationFactory licenseLocationFactory, FileIOHandler fileIOHandler) {
        this.fModel = vRDModel;
        this.fView = vRDView;
        this.fRequired = bl;
        this.fPromptConfirm = bl2;
        this.vCommand = validateCommand;
        this.dCommand = deactivateCommand;
        this.licenseLocationFactory = licenseLocationFactory;
        this.fileIOHandler = fileIOHandler;
        this.validateStatusMap = RefreshCommandImpl.initializeValidateStatusMap();
        this.deactivateStatusMap = RefreshCommandImpl.initializeDeactivateStatusMap();
    }

    private static Map<ValidateStatus, RefreshStatus> initializeValidateStatusMap() {
        EnumMap<ValidateStatus, RefreshStatus> enumMap = new EnumMap<ValidateStatus, RefreshStatus>(ValidateStatus.class);
        enumMap.put(ValidateStatus.CANNOT_CONNECT, RefreshStatus.CANNOT_VALIDATE);
        enumMap.put(ValidateStatus.VALIDATE_ERROR, RefreshStatus.CANNOT_VALIDATE);
        enumMap.put(ValidateStatus.CANCELLED, RefreshStatus.CANCELLED);
        return enumMap;
    }

    private static Map<DeactivateStatus, RefreshStatus> initializeDeactivateStatusMap() {
        EnumMap<DeactivateStatus, RefreshStatus> enumMap = new EnumMap<DeactivateStatus, RefreshStatus>(DeactivateStatus.class);
        enumMap.put(DeactivateStatus.CANCELLED, RefreshStatus.DEACTIVATE_CANCELLED);
        enumMap.put(DeactivateStatus.DEACTIVATED, RefreshStatus.DEACTIVATED);
        enumMap.put(DeactivateStatus.DEACTIVATED_LOCALLY_ONLY, RefreshStatus.DEACTIVATED);
        enumMap.put(DeactivateStatus.CANNOT_WRITE_FILE, RefreshStatus.CANNOT_DEACTIVATE);
        enumMap.put(DeactivateStatus.DEACTIVATE_ERROR, RefreshStatus.CANNOT_DEACTIVATE);
        return enumMap;
    }

    @Override
    public RefreshStatus refresh(License license) {
        Object object;
        Object object2;
        DeactivateStatus deactivateStatus;
        Object object3;
        boolean bl;
        VRDView.VRDOption vRDOption;
        String string = license.getLicenseString();
        this.logInfo("log.update.start", string);
        if (this.fPromptConfirm && (vRDOption = this.promptForConfirmation(license, string)).equals((Object)VRDView.VRDOption.CANCEL)) {
            return RefreshStatus.CANCELLED;
        }
        try {
            bl = this.fModel.connectNow();
        }
        catch (InterruptedException interruptedException) {
            return RefreshStatus.CANCELLED;
        }
        if (!bl) {
            this.error("refresh.error.cannotconnect.title", "refresh.error.cannotconnect.msg", new Object[0]);
            return RefreshStatus.CANNOT_CONNECT;
        }
        if (!this.fRequired) {
            object3 = this.vCommand.validate(license);
            if (object3.equals((Object)ValidateStatus.DEACTIVATE_REQUIRED)) {
                deactivateStatus = this.dCommand.deactivate(license);
                if (this.deactivateStatusMap.containsKey((Object)deactivateStatus)) {
                    return this.deactivateStatusMap.get((Object)deactivateStatus);
                }
            } else if (this.validateStatusMap.containsKey(object3)) {
                return this.validateStatusMap.get(object3);
            }
        }
        if ((object3 = this.fModel.getCurrentLicenseFile(license)) == null) {
            this.error("refresh.error.cannotfindlicenses.title", "refresh.error.cannotfindlicenses.msg", string);
            return RefreshStatus.CANNOT_WRITE_FILE;
        }
        deactivateStatus = this.licenseLocationFactory.getOtherUserLicenseLocation(this.fView.getMatlabRoot(), this.fView.getRelease(), string);
        String string2 = deactivateStatus.getLicenseLocation();
        File file = new File(string2);
        if (RefreshCommandImpl.needToMoveLicenseFile(license, (File)object3, file)) {
            boolean bl2;
            object2 = object3;
            String string3 = MachineInfo.getArch();
            object = this.fView.getMatlabRoot() + File.separator + "bin" + File.separator + string3;
            LicenseFileLocation licenseFileLocation = this.licenseLocationFactory.getUserLicenseLocation((String)object, this.fView.getRelease(), string);
            String string4 = licenseFileLocation.getLicenseLocation();
            File file2 = new File(string4);
            try {
                this.fileIOHandler.mkdirs(file2);
            }
            catch (Exception exception) {
                this.logWarning("refresh.error.createdir.msg", file2.getAbsolutePath());
            }
            String string5 = string4 + File.separator + licenseFileLocation.getLicenseName();
            object3 = new File(string5);
            boolean bl3 = bl2 = this.fileIOHandler.copySingleFile((File)object2, (File)object3) > -1L;
            if (!bl2) {
                this.error("refresh.error.cannotwrite.title", "refresh.error.cannotwrite.msg", object3);
                return RefreshStatus.CANNOT_WRITE_FILE;
            }
            this.logInfo("refresh.newLocation.msg", ((File)object3).getAbsolutePath());
            if (!this.fModel.deleteLicenseFile((File)object2)) {
                try {
                    this.fileIOHandler.overwriteFile((File)object2, this.fView.intlString("refresh.license.text"));
                }
                catch (IOException iOException) {
                    this.fView.exception(iOException, true);
                    try {
                        this.fileIOHandler.delete((File)object3);
                        this.logWarning("refresh.deletefile.msg", ((File)object3).getAbsolutePath());
                    }
                    catch (SecurityException securityException) {
                        this.logWarning("refresh.error.cannotdeletefile2.msg", ((File)object3).getAbsolutePath());
                    }
                    return RefreshStatus.CANNOT_WRITE_FILE;
                }
            }
        }
        try {
            object2 = this.fModel.refresh(license);
        }
        catch (InterruptedException interruptedException) {
            return RefreshStatus.CANCELLED;
        }
        if (object2 == null || "".equals(object2)) {
            return RefreshStatus.REFRESH_ERROR;
        }
        boolean bl4 = this.fModel.writeStringToLicenseFileAndElevateIfNecessary((String)object2, (File)object3);
        if (bl4) {
            this.complete(license, "refresh.complete.updated.title", "refresh.complete.updated.msg", "refresh.complete.updated.option", false, string);
            return RefreshStatus.UPDATED;
        }
        object = new File(System.getProperty("java.io.tmpdir"), ((File)object3).getName());
        this.fModel.writeStringToLicenseFile((String)object2, (File)object);
        this.complete(license, "refresh.complete.updatedtotemp.title", "refresh.complete.updatedtotemp.msg", "refresh.complete.updatedtotemp.option", true, ((File)object).getAbsolutePath());
        return RefreshStatus.UPDATED_TO_TEMP;
    }

    private static boolean needToMoveLicenseFile(License license, File file, File file2) {
        File file3 = new FolderUtilsImpl().getParentFile(file);
        return license.isSNULicense() && file3.equals(file2);
    }

    private void complete(License license, String string, String string2, String string3, boolean bl, Object ... objectArray) {
        String string4 = this.fView.intlString(string);
        String string5 = this.getMessage(string2, objectArray);
        String string6 = this.fView.intlString(string3);
        this.fView.complete(license, string4, string5, string6, bl, false);
        license.setLicenseStatus(LicenseStatus.UPDATED);
    }

    private VRDView.VRDOption promptForConfirmation(License license, String string) {
        String string2 = this.fView.intlString(this.fRequired ? "refresh.confirm.required.title" : "refresh.confirm.requested.title");
        String string3 = this.fView.intlString(this.fRequired ? "refresh.confirm.required.msg" : "refresh.confirm.requested.msg");
        String string4 = MessageFormat.format(string3, string);
        String string5 = this.fView.intlString(this.fRequired ? "refresh.confirm.required.confirm" : "refresh.confirm.requested.confirm");
        String string6 = this.fView.intlString(this.fRequired ? "refresh.confirm.required.cancel" : "refresh.confirm.requested.cancel");
        return this.fView.confirm(license, string2, string4, string5, string6, this.fRequired);
    }

    private void error(String string, String string2, Object ... objectArray) {
        String string3 = this.fView.intlString(string);
        String string4 = this.getMessage(string2, objectArray);
        this.fView.error(string3, string4);
    }

    private void logWarning(String string, Object ... objectArray) {
        String string2 = this.getMessage(string, objectArray);
        this.fView.logWarning(string2);
    }

    private void logInfo(String string, Object ... objectArray) {
        String string2 = this.getMessage(string, objectArray);
        this.fView.logInfo(string2);
    }

    private String getMessage(String string, Object ... objectArray) {
        String string2 = this.fView.intlString(string);
        String string3 = objectArray.length == 0 ? string2 : MessageFormat.format(string2, objectArray);
        return string3;
    }
}

