/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.vrd.command;

import com.mathworks.instutil.FolderUtils;
import com.mathworks.instutil.FolderUtilsImpl;
import com.mathworks.vrd.command.DeactivateCommand;
import com.mathworks.vrd.command.DeactivateStatus;
import com.mathworks.vrd.license.License;
import com.mathworks.vrd.license.LicenseStatus;
import com.mathworks.vrd.model.VRDModel;
import com.mathworks.vrd.view.VRDView;
import java.io.File;
import java.text.MessageFormat;
import java.util.Iterator;

class DeactivateCommandImpl
implements DeactivateCommand {
    private final VRDView fView;
    private final VRDModel fModel;
    private final boolean fRequired;
    private final boolean fPromptConfirm;
    private final FolderUtils folderUtils = new FolderUtilsImpl();

    DeactivateCommandImpl(VRDModel vRDModel, VRDView vRDView, boolean bl, boolean bl2) {
        this.fModel = vRDModel;
        this.fView = vRDView;
        this.fRequired = bl;
        this.fPromptConfirm = bl2;
    }

    @Override
    public DeactivateStatus deactivate(License license) {
        Object object;
        Object object2;
        Object object3;
        String string = license.getLicenseString();
        this.fView.logInfo("Starting license deactivate on license " + string);
        String string2 = this.fView.intlString(this.fRequired ? "deactivate.confirm.required.title" : "deactivate.confirm.requested.title");
        String string3 = this.fView.intlString(this.fRequired ? "deactivate.confirm.required.msg" : "deactivate.confirm.requested.msg");
        string3 = MessageFormat.format(string3, string);
        String string4 = this.fView.intlString(this.fRequired ? "deactivate.confirm.required.confirm" : "deactivate.confirm.requested.confirm");
        String string5 = this.fView.intlString(this.fRequired ? "deactivate.confirm.required.cancel" : "deactivate.confirm.requested.cancel");
        if (this.fPromptConfirm && ((Enum)(object3 = this.fView.confirm(license, string2, string3, string4, string5, this.fRequired))).equals((Object)VRDView.VRDOption.CANCEL)) {
            return DeactivateStatus.CANCELLED;
        }
        try {
            object3 = this.fModel.getAllLicenseFiles(license);
        }
        catch (InterruptedException interruptedException) {
            return DeactivateStatus.CANCELLED;
        }
        boolean bl = false;
        Object object4 = object3.iterator();
        while (object4.hasNext() && !(bl = this.fModel.checkCanWrite((File)(object2 = object4.next())))) {
        }
        if (object3.size() == 0) {
            this.showCannotFindLicFilesMessage(string);
            return DeactivateStatus.CANNOT_WRITE_FILE;
        }
        if (!bl) {
            this.showCannotWriteMessage();
            return DeactivateStatus.CANNOT_WRITE_FILE;
        }
        try {
            object4 = this.fModel.getDeactivationString(license);
        }
        catch (Exception exception) {
            this.fView.exception(exception, false);
            return DeactivateStatus.DEACTIVATE_ERROR;
        }
        object2 = this.fView.intlString("deactivate.license.text");
        object2 = MessageFormat.format((String)object2, string, object4);
        boolean bl2 = false;
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            object = (File)iterator.next();
            boolean bl3 = this.fModel.writeStringToLicenseFile((String)object2, (File)object);
            if (!bl3) continue;
            bl2 = true;
            File file = this.folderUtils.getParentFile((File)object);
            File file2 = new File(file, ((File)object).getName() + this.fView.intlString("deactivated.fileext"));
            boolean bl4 = this.fModel.copyFile((File)object, file2);
            if (!bl4) continue;
            this.fModel.deleteLicenseFile((File)object);
        }
        if (!bl2) {
            this.showCannotWriteMessage();
            return DeactivateStatus.CANNOT_WRITE_FILE;
        }
        boolean bl5 = false;
        try {
            if (this.fModel.connectNow()) {
                bl5 = this.fModel.deactivate(license);
            }
        }
        catch (InterruptedException interruptedException) {
            bl5 = false;
        }
        if (!bl5) {
            string2 = this.fView.intlString("deactivate.complete.local.title");
            string3 = this.fView.intlString("deactivate.complete.local.msg");
            string3 = MessageFormat.format(string3, string, object4);
            object = this.fView.intlString("deactivate.complete.local.option");
            this.fView.complete(license, string2, string3, (String)object, true, true);
            license.setLicenseStatus(LicenseStatus.DEACTIVATED_LOCALLY);
            return DeactivateStatus.DEACTIVATED_LOCALLY_ONLY;
        }
        string2 = this.fView.intlString("deactivate.complete.title");
        string3 = this.fView.intlString("deactivate.complete.msg");
        string3 = MessageFormat.format(string3, string);
        object = this.fView.intlString("deactivate.complete.option");
        this.fView.complete(license, string2, string3, (String)object, false, false);
        license.setLicenseStatus(LicenseStatus.DEACTIVATED);
        return DeactivateStatus.DEACTIVATED;
    }

    private void showCannotWriteMessage() {
        String string = this.fView.intlString("deactivate.error.cannotwrite.title");
        String string2 = this.fView.intlString("deactivate.error.cannotwrite.msg");
        this.fView.error(string, string2);
    }

    private void showCannotFindLicFilesMessage(String string) {
        String string2 = this.fView.intlString("deactivate.error.cannotfindlicenses.title");
        String string3 = this.fView.intlString("deactivate.error.cannotfindlicenses.msg");
        string3 = MessageFormat.format(string3, string);
        this.fView.error(string2, string3);
    }
}

