/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient.view.other;

import com.mathworks.activationclient.resources.CommercialActivationComponentName;
import com.mathworks.activationclient.view.AdapterDocumentListener;
import com.mathworks.activationclient.view.CommercialActivationPanel;
import com.mathworks.activationclient.view.UserNameDocument;
import com.mathworks.activationclient.view.other.ActivateOtherPanel;
import com.mathworks.activationclient.view.other.ActivateOtherPanelController;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.MachineInfo;
import com.mathworks.instutil.wizard.ComponentName;
import com.mathworks.instwiz.ButtonFactory;
import com.mathworks.instwiz.ButtonProperties;
import com.mathworks.instwiz.InstWizardIntf;
import com.mathworks.instwiz.OptionPaneHandler;
import com.mathworks.instwiz.SwingComponentFactory;
import com.mathworks.instwiz.WIButtonProperties;
import com.mathworks.instwiz.WIEditorPane;
import com.mathworks.instwiz.WIPanel;
import com.mathworks.instwiz.WIPanelBuilder;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToolTip;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

final class ActivateOtherPanelImpl
extends CommercialActivationPanel
implements ActivateOtherPanel {
    private final JButton nextButton;
    private final JTextComponent myUsernameField;
    private final JTextComponent fNameField;
    private final JTextComponent lNameField;
    private final JTextComponent emailField;
    private final JTextComponent otherUsernameField;
    private final JRadioButton meRadioButton;
    private final JRadioButton otherRadioButton;
    private final JButton backButton;
    private final ActivateOtherPanelController controller;
    private final JComponent myUsernameLabel;
    private final JComponent otherUsernameLabel;
    private final UserNameDocument myUserNameDocument;
    private final String arch = MachineInfo.getArch();
    private final String userString;
    private String defaultUserName;

    ActivateOtherPanelImpl(InstWizardIntf instWizardIntf, ActivateOtherPanelController activateOtherPanelController, final OptionPaneHandler optionPaneHandler) {
        super(instWizardIntf, CommercialActivationComponentName.OTHER_PANEL);
        this.controller = activateOtherPanelController;
        final InstUtilResourceBundle instUtilResourceBundle = this.getResources();
        this.userString = instUtilResourceBundle.getString("label.user." + this.arch);
        ButtonFactory buttonFactory = instWizardIntf.getButtonFactory();
        this.backButton = buttonFactory.createButton((ButtonProperties)WIButtonProperties.BACK, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActivateOtherPanelImpl.this.controller.backButton();
            }
        }, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.OTHER_BACK_BUTTON);
        this.nextButton = buttonFactory.createButton((ButtonProperties)WIButtonProperties.NEXT, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ActivateOtherPanelImpl.this.meRadioButton.isSelected()) {
                    String string = ActivateOtherPanelImpl.this.myUsernameField.getText().trim();
                    if (ActivateOtherPanelImpl.this.isValidUserName(string)) {
                        ActivateOtherPanelImpl.this.controller.activatingForSelf();
                        ActivateOtherPanelImpl.this.controller.nextButton();
                    } else {
                        ActivateOtherPanelImpl.this.showWarning(instUtilResourceBundle, optionPaneHandler, true);
                    }
                } else if (ActivateOtherPanelImpl.this.otherRadioButton.isSelected()) {
                    String string = ActivateOtherPanelImpl.this.otherUsernameField.getText().trim();
                    if (ActivateOtherPanelImpl.this.isValidUserName(string)) {
                        ActivateOtherPanelImpl.this.controller.activatingForOther();
                        ActivateOtherPanelImpl.this.controller.nextButton();
                    } else {
                        ActivateOtherPanelImpl.this.showWarning(instUtilResourceBundle, optionPaneHandler, false);
                    }
                }
            }
        }, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.OTHER_NEXT_BUTTON);
        JButton jButton = buttonFactory.createCancelButton((com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.OTHER_CANCEL_BUTTON);
        JButton jButton2 = buttonFactory.createButton((ButtonProperties)WIButtonProperties.HELP, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActivateOtherPanelImpl.this.controller.helpButton();
            }
        }, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.OTHER_HELP_BUTTON);
        String string = instUtilResourceBundle.getString("other.bold");
        SwingComponentFactory swingComponentFactory = instWizardIntf.getSwingComponentFactory();
        JTextComponent jTextComponent = swingComponentFactory.createLabel(string);
        Font font = this.getBoldFont();
        jTextComponent.setFont(font);
        String string2 = instUtilResourceBundle.getString("user.top");
        MessageFormat messageFormat = new MessageFormat(string2);
        String string3 = this.userString.toLowerCase(Locale.getDefault()).replaceAll("windows", "Windows");
        Object[] objectArray = new Object[]{string3};
        String string4 = messageFormat.format(objectArray);
        WIEditorPane wIEditorPane = new WIEditorPane(instWizardIntf, string4);
        String string5 = instUtilResourceBundle.getString("other.user.bottom");
        JTextComponent jTextComponent2 = swingComponentFactory.createLabelNonWrapping(string5);
        String string6 = instUtilResourceBundle.getString("other.me");
        this.meRadioButton = swingComponentFactory.createRadioButton(string6, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.OTHER_SELF_RB);
        this.meRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ActivateOtherPanelImpl.this.controller.activatingForSelf();
                }
            }
        });
        String string7 = this.userString + instUtilResourceBundle.getString("colon");
        this.myUsernameLabel = swingComponentFactory.createLabelNonWrapping(string7);
        this.myUsernameField = swingComponentFactory.createTextField((ComponentName)CommercialActivationComponentName.OTHER_MY_USERNAME_FIELD, this.userString);
        String string8 = instUtilResourceBundle.getString("user.name.tooltip");
        JToolTip jToolTip = swingComponentFactory.createToolTipText(string8, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.OTHER_MY_USERNAME_TOOLTIP);
        this.myUsernameField.setToolTipText(jToolTip.getToolTipText());
        this.otherUsernameField = swingComponentFactory.createTextField((ComponentName)CommercialActivationComponentName.OTHER_OTHER_USERNAME_FIELD, string7);
        String string9 = instUtilResourceBundle.getString("other.user.tooltip");
        JToolTip jToolTip2 = swingComponentFactory.createToolTipText(string9, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.OTHER_OTHER_USERNAME_TOOLTIP);
        this.otherUsernameField.setToolTipText(jToolTip2.getToolTipText());
        String string10 = instUtilResourceBundle.getString("other.other");
        this.otherRadioButton = swingComponentFactory.createRadioButton(string10, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.OTHER_OTHER_RB);
        this.otherRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ActivateOtherPanelImpl.this.controller.activatingForOther();
                }
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.meRadioButton);
        buttonGroup.add(this.otherRadioButton);
        String string11 = instUtilResourceBundle.getString("label.first");
        JTextComponent jTextComponent3 = swingComponentFactory.createLabelNonWrapping(string11);
        String string12 = instUtilResourceBundle.getString("label.last");
        JTextComponent jTextComponent4 = swingComponentFactory.createLabelNonWrapping(string12);
        String string13 = instUtilResourceBundle.getString("other.label.email");
        JTextComponent jTextComponent5 = swingComponentFactory.createLabelNonWrapping(string13);
        this.otherUsernameLabel = swingComponentFactory.createLabelNonWrapping(string7);
        this.emailField = swingComponentFactory.createTextField((ComponentName)CommercialActivationComponentName.OTHER_EMAIL_FIELD, string13);
        this.fNameField = swingComponentFactory.createTextField((ComponentName)CommercialActivationComponentName.OTHER_FIRST_NAME_FIELD, string11);
        this.lNameField = swingComponentFactory.createTextField((ComponentName)CommercialActivationComponentName.OTHER_LAST_NAME_FIELD, string12);
        JButton[] jButtonArray = new JButton[]{this.backButton, this.nextButton};
        JButton[] jButtonArray2 = new JButton[]{jButton, jButton2};
        JPanel jPanel = this.layoutButtons(jButtonArray, jButtonArray2);
        this.add(jPanel, "South");
        WIPanelBuilder wIPanelBuilder = this.createPanelBuilder();
        wIPanelBuilder.addRow(new JComponent[]{jTextComponent});
        wIPanelBuilder.addRow(new JComponent[]{wIEditorPane});
        wIPanelBuilder.addRow(new JComponent[]{this.meRadioButton});
        wIPanelBuilder.addSubRow(new JComponent[]{this.myUsernameLabel, this.myUsernameField});
        wIPanelBuilder.addRow(new JComponent[]{this.otherRadioButton});
        wIPanelBuilder.addSubRow(new JComponent[]{jTextComponent2});
        wIPanelBuilder.addSubRow(new JComponent[]{jTextComponent5, this.emailField});
        wIPanelBuilder.addSubRow(new JComponent[]{jTextComponent3, this.fNameField});
        wIPanelBuilder.addSubRow(new JComponent[]{jTextComponent4, this.lNameField});
        wIPanelBuilder.addSubRow(new JComponent[]{this.otherUsernameLabel, this.otherUsernameField});
        this.add(wIPanelBuilder.buildPanelWithPrivacyPolicyLink(), "Center");
        String string14 = instUtilResourceBundle.getString("other.title");
        this.setDefaults(this.nextButton, this.meRadioButton, string14);
        this.myUserNameDocument = new UserNameDocument(instUtilResourceBundle, optionPaneHandler);
        this.myUserNameDocument.addDocumentListener(new AdapterDocumentListener(this.myUsernameField){

            @Override
            protected void setAdapterField(String string) {
                ActivateOtherPanelImpl.this.controller.setUserNameForSelf(string);
            }
        });
        this.myUsernameField.setDocument(this.myUserNameDocument);
        Document document = this.fNameField.getDocument();
        document.addDocumentListener(new AdapterDocumentListener(this.fNameField){

            @Override
            protected void setAdapterField(String string) {
                ActivateOtherPanelImpl.this.controller.setFirstNameForOther(string);
            }
        });
        Document document2 = this.lNameField.getDocument();
        document2.addDocumentListener(new AdapterDocumentListener(this.lNameField){

            @Override
            protected void setAdapterField(String string) {
                ActivateOtherPanelImpl.this.controller.setLastNameForOther(string);
            }
        });
        Document document3 = this.emailField.getDocument();
        document3.addDocumentListener(new AdapterDocumentListener(this.emailField){

            @Override
            protected void setAdapterField(String string) {
                ActivateOtherPanelImpl.this.controller.setEmailForOther(string);
            }
        });
        Document document4 = this.otherUsernameField.getDocument();
        document4.addDocumentListener(new AdapterDocumentListener(this.otherUsernameField){

            @Override
            protected void setAdapterField(String string) {
                ActivateOtherPanelImpl.this.controller.setUserNameForOther(string);
            }
        });
        this.meRadioButton.setOpaque(false);
        this.otherRadioButton.setOpaque(false);
    }

    private boolean isValidUserName(String string) {
        boolean bl = true;
        if (!this.arch.contains("win") && string.contains(" ")) {
            bl = false;
        }
        return bl;
    }

    private void showWarning(InstUtilResourceBundle instUtilResourceBundle, OptionPaneHandler optionPaneHandler, boolean bl) {
        String string;
        String string2 = instUtilResourceBundle.getString("other.warn.spaces.title");
        MessageFormat messageFormat = new MessageFormat(string2);
        String string3 = messageFormat.format(new Object[]{this.userString});
        if (bl) {
            String string4 = instUtilResourceBundle.getString("other.warn.spaces.message.self");
            messageFormat.applyPattern(string4);
            string = messageFormat.format(new Object[]{this.userString.toLowerCase(), this.defaultUserName});
        } else {
            String string5 = instUtilResourceBundle.getString("other.warn.spaces.message.other");
            messageFormat.applyPattern(string5);
            string = messageFormat.format(new Object[]{this.userString.toLowerCase(), this.defaultUserName});
        }
        optionPaneHandler.show(string, string3, 2, -1);
    }

    @Override
    public void setUserNameRequired(boolean bl) {
        this.myUsernameLabel.setVisible(bl);
        this.myUsernameField.setVisible(bl);
        this.otherUsernameLabel.setVisible(bl);
        this.otherUsernameField.setVisible(bl);
    }

    @Override
    public void preDisplay() {
        this.controller.setUserNameForSelf(this.myUsernameField.getText());
        this.controller.setEmailForOther(this.emailField.getText());
        this.controller.setFirstNameForOther(this.fNameField.getText());
        this.controller.setLastNameForOther(this.lNameField.getText());
        this.controller.setUserNameForOther(this.otherUsernameField.getText());
        super.preDisplay();
    }

    @Override
    public WIPanel getPanel() {
        return this;
    }

    @Override
    public void setUserNameFieldText(String string) {
        try {
            this.defaultUserName = string;
            this.myUserNameDocument.setTextWithoutCheck(string);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    @Override
    public void setNextButtonEnabled(boolean bl) {
        this.nextButton.setEnabled(bl);
    }

    @Override
    public void setActivatingOther() {
        this.meRadioButton.setSelected(false);
        this.myUsernameField.setEnabled(false);
        this.otherRadioButton.setSelected(true);
        this.fNameField.setEnabled(true);
        this.lNameField.setEnabled(true);
        this.emailField.setEnabled(true);
        this.otherUsernameField.setEnabled(true);
    }

    @Override
    public void setActivatingSelf() {
        this.meRadioButton.setSelected(true);
        this.myUsernameField.setEnabled(true);
        this.otherRadioButton.setSelected(false);
        this.fNameField.setEnabled(false);
        this.lNameField.setEnabled(false);
        this.emailField.setEnabled(false);
        this.otherUsernameField.setEnabled(false);
    }

    JButton getBackButton() {
        return this.backButton;
    }

    JTextComponent getEmailField() {
        return this.emailField;
    }

    JTextComponent getFNameField() {
        return this.fNameField;
    }

    JTextComponent getLNameField() {
        return this.lNameField;
    }

    JRadioButton getMeRadioButton() {
        return this.meRadioButton;
    }

    JTextComponent getMyUnameField() {
        return this.myUsernameField;
    }

    JRadioButton getOtherRadioButton() {
        return this.otherRadioButton;
    }

    JTextComponent getOtherUnameField() {
        return this.otherUsernameField;
    }

    @Override
    public void setOtherFirstName(String string) {
        this.fNameField.setText(string);
    }

    @Override
    public void setOtherLastName(String string) {
        this.lNameField.setText(string);
    }

    @Override
    public void setOtherEmailAddress(String string) {
        this.emailField.setText(string);
    }

    @Override
    public void setOtherUserName(String string) {
        this.otherUsernameField.setText(string);
    }
}

