/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient.model;

import com.mathworks.activationclient.model.ActivationModel;
import com.mathworks.activationclient.model.ActivationModelObserver;
import com.mathworks.activationclient.model.WebServiceCaller;
import com.mathworks.activationclient.model.WebServiceResponse;
import com.mathworks.activationclient.model.message.ActivatingOnline;
import com.mathworks.activationclient.model.message.ActivationMessage;
import com.mathworks.activationclient.model.message.CreatingAccountForSelf;
import com.mathworks.activationclient.model.message.DcAnonymous;
import com.mathworks.activationclient.model.message.DcSelected;
import com.mathworks.activationclient.model.message.FeaturesActivated;
import com.mathworks.activationclient.model.message.InuSelected;
import com.mathworks.activationclient.model.message.IsLicenseAdmin;
import com.mathworks.activationclient.model.message.LeuData;
import com.mathworks.activationclient.model.message.SetSelectingEntitlement;
import com.mathworks.activationclient.model.message.SnuSelected;
import com.mathworks.activationclient.model.message.StartState;
import com.mathworks.activationclient.model.message.StartStateId;
import com.mathworks.activationclient.model.message.StartStateKey;
import com.mathworks.activationclient.model.message.StartStateStandard;
import com.mathworks.activationclient.model.message.StartStateToken;
import com.mathworks.activationclient.model.message.StartStateTokenId;
import com.mathworks.activationclient.model.message.StartStateTokenKey;
import com.mathworks.activationclient.model.message.UpdatedEntitlements;
import com.mathworks.activationclient.model.message.ValidActivationKey;
import com.mathworks.activationclient.model.message.ValidActivationKeyForA2akOffEntitlement;
import com.mathworks.activationclient.model.message.ValidCreateAccountData;
import com.mathworks.activationclient.model.message.ValidEmailAndPassword;
import com.mathworks.activationclient.model.message.ValidEntitlement;
import com.mathworks.activationclient.model.message.ValidMyUserName;
import com.mathworks.activationclient.model.states.ActivateState;
import com.mathworks.activationclient.model.states.ActivateStateFactory;
import com.mathworks.instutil.FileIO;
import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.FilePermissionsUtil;
import com.mathworks.instutil.FolderUtilsImpl;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.JNIException;
import com.mathworks.instutil.Machine;
import com.mathworks.instutil.MachineInfo;
import com.mathworks.instutil.licensefiles.LicenseFileParser;
import com.mathworks.instutil.licensefiles.LicenseFileParserImpl;
import com.mathworks.instutil.licensefiles.LicenseFileWriter;
import com.mathworks.instutil.licensefiles.LicenseLocationFactory;
import com.mathworks.instutil.licensefiles.LicenseUtility;
import com.mathworks.instutil.licensefiles.MarkerUtility;
import com.mathworks.instutil.licensefiles.MarkerUtilityFactory;
import com.mathworks.instutil.services.ProxyTester;
import com.mathworks.instutil.services.ServiceThreadState;
import com.mathworks.instwiz.InstWizardIntf;
import com.mathworks.internal.mwaws.client.v6.MWAEntitledPerson;
import com.mathworks.internal.mwaws.client.v6.MWAGetPeopleResponse;
import com.mathworks.internal.mwaws.client.v6.MWAMachineAttribute;
import com.mathworks.mlwebservices.Account;
import com.mathworks.mlwebservices.AccountFactory;
import com.mathworks.mlwebservices.InstallerEntitlement;
import com.mathworks.mlwebservices.InstallerEntitlementFactoryImpl;
import com.mathworks.mlwebservices.LockingTypeConstants;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class ActivationModelImpl
implements ActivationModel,
LicenseFileWriter {
    private static final int REQUIRED_PASSWORD_LENGTH = 1;
    private static final boolean DEFAULT_ACTIVATE_ONLINE = true;
    private static final boolean DEFAULT_LOGGING_IN = true;
    private static final boolean DEFAULT_SELECTING_ENTITLEMENT = true;
    private static final Map<LockingTypeConstants, ActivationMessage> ACTIVATION_TYPE_MAP;
    private final LicenseLocationFactory licLocFactory;
    private final Set<ActivationModelObserver> observers = new LinkedHashSet<ActivationModelObserver>();
    private final AccountFactory accountFactory;
    private Account account;
    private final Account accountForOther;
    private boolean activatingOnline;
    private final WebServiceCaller webServiceCaller;
    private String rootDir;
    private final InstWizardIntf view;
    private boolean loggingIn;
    private boolean selectingEntitlement;
    private boolean activatingWithLicenseFile;
    private String offlineLicenseFile;
    private String onlineLicenseFile;
    private final ActivateStateFactory activateStateFactory;
    private ActivateState onlineActivateState;
    private ActivateState offlineActivateState;
    private String activationKey;
    private String entitlementId;
    private boolean dcAnonymous;
    private Machine info;
    private FilePermissionsUtil filePermUtil;
    private String licenseString;
    private boolean activationKeyPassedIn;
    private String fPreviousActivationKey;
    private IO io;
    private String initialActivationKey;
    private boolean inuCapable = false;
    private boolean inuSelected = false;
    private LicenseUtility licenseUtility;
    private MarkerUtility markerUtility;
    private Properties properties;
    private boolean isStudent = false;

    public ActivationModelImpl(InstWizardIntf instWizardIntf, WebServiceCaller webServiceCaller, ActivateStateFactory activateStateFactory, AccountFactory accountFactory, LicenseLocationFactory licenseLocationFactory, Properties properties) {
        this.view = instWizardIntf;
        this.licLocFactory = licenseLocationFactory;
        this.loggingIn = true;
        this.selectingEntitlement = true;
        this.accountFactory = accountFactory;
        this.account = this.accountFactory.createAccount();
        this.accountForOther = accountFactory.createAccount();
        this.accountForOther.setUserName("");
        this.activatingOnline = true;
        this.webServiceCaller = webServiceCaller;
        this.webServiceCaller.setModel(this);
        this.activateStateFactory = activateStateFactory;
        this.activateStateFactory.setActivationModel(this);
        this.activateStateFactory.setWebServiceCaller(webServiceCaller);
        this.onlineActivateState = this.activateStateFactory.createActivateSelfState();
        this.offlineActivateState = this.activateStateFactory.createActivateNoOpState();
        this.properties = properties;
    }

    @Override
    public boolean isActivatingOnline() {
        return this.activatingOnline;
    }

    @Override
    public void setActivatingOnline(boolean bl) {
        this.activatingOnline = bl;
        this.sendMessage(new ActivatingOnline(bl));
        this.notifyActivateState();
    }

    @Override
    public void attach(ActivationModelObserver activationModelObserver) {
        this.observers.add(activationModelObserver);
    }

    @Override
    public void sendMessage(ActivationMessage activationMessage) {
        for (ActivationModelObserver activationModelObserver : this.observers) {
            activationModelObserver.sendMessage(activationMessage);
        }
    }

    @Override
    public boolean activate() {
        if (this.getActivateState().activate()) {
            this.licenseUtility = this.getLicenseUtility();
            this.markerUtility = this.getMarkerUtility();
            return true;
        }
        return false;
    }

    private MarkerUtility getMarkerUtility() {
        return this.getActivateState().getMarkerUtility(this);
    }

    private LicenseUtility getLicenseUtility() {
        String string;
        ActivateState activateState = this.getActivateState();
        if (this.inuSelected) {
            this.licenseString = "";
            string = "0";
        } else {
            InstallerEntitlement installerEntitlement = this.account.getSelectedEntitlement();
            this.licenseString = activateState.getLicenseString();
            string = installerEntitlement == null ? "0" : installerEntitlement.getId();
        }
        return activateState.getLicenseUtility(this, this.licenseString, string, this.accountForOther);
    }

    @Override
    public boolean installLicense() {
        try {
            LicenseFileParserImpl licenseFileParserImpl = new LicenseFileParserImpl();
            if (this.licenseUtility.installLicense((LicenseFileParser)licenseFileParserImpl)) {
                List list = this.licenseUtility.getFeatureNames((LicenseFileParser)licenseFileParserImpl);
                this.sendMessage(new FeaturesActivated(list));
                String string = this.accountForOther != null && !this.accountForOther.getUserName().isEmpty() ? this.accountForOther.getUserName() : this.account.getUserName();
                this.markerUtility = MarkerUtilityFactory.createFileBasedMarkerUtility((String)string, (String)this.getRootDir(), (String)this.getHostName(), (Properties)this.properties);
            }
            this.markerUtility.installMarkerFile();
        }
        catch (Exception exception) {
            this.view.exception((Throwable)exception, false);
        }
        return true;
    }

    @Override
    public Account getAccount() {
        return this.account;
    }

    @Override
    public Account getActivatingAccount() {
        return this.onlineActivateState.getAccount();
    }

    @Override
    public String getMachineID() {
        this.loadNativeLib();
        return this.info.getLockingString();
    }

    public MWAMachineAttribute[] getMachineAttributes() {
        this.loadNativeLib();
        return this.info.getMachineAttributes();
    }

    @Override
    public Machine getMachineInfo() {
        this.loadNativeLib();
        return this.info;
    }

    public void setMachineInfo(Machine machine) {
        this.info = machine;
    }

    public IO getIO() {
        this.loadNativeLib();
        return this.io;
    }

    private void loadNativeLib() {
        String string = this.getLibDirPath();
        try {
            if (this.info == null) {
                this.info = new MachineInfo(string);
            }
            if (this.filePermUtil == null) {
                this.filePermUtil = new FilePermissionsUtil(string);
            }
            if (this.io == null) {
                this.io = new FileIO(string, (FilePermissions)this.filePermUtil);
            }
        }
        catch (JNIException jNIException) {
            this.view.exception((Throwable)jNIException, true);
        }
    }

    public FilePermissions getFilePermissionsUtility() {
        this.loadNativeLib();
        return this.filePermUtil;
    }

    public boolean isNetworkBased() {
        LicenseFileParserImpl licenseFileParserImpl = new LicenseFileParserImpl();
        return ActivationModelImpl.isNetworkBased(this.licenseString, (LicenseFileParser)licenseFileParserImpl);
    }

    static boolean isNetworkBased(String string, LicenseFileParser licenseFileParser) {
        return licenseFileParser.hasCountedIncrementLine(string) || licenseFileParser.containsServerLine(string);
    }

    public boolean isNetworkClient(LicenseFileParser licenseFileParser) {
        return ActivationModelImpl.isNetworkClient(this.licenseString, licenseFileParser);
    }

    static boolean isNetworkClient(String string, LicenseFileParser licenseFileParser) {
        return licenseFileParser.containsServerLine(string);
    }

    public boolean isNetworkServer() {
        return false;
    }

    public void sendMessage(String string, String string2) {
        this.view.showPanel(string2, string, 0, -1);
    }

    public String getLibDirPath() {
        String string = this.rootDir;
        if (!string.endsWith(File.separator)) {
            string = string.concat(File.separator);
        }
        String string2 = MachineInfo.getArch();
        return string + "bin" + File.separator + string2;
    }

    @Override
    public String getRootDir() {
        return this.rootDir;
    }

    @Override
    public void setRootDir(String string) {
        this.rootDir = string;
    }

    @Override
    public boolean connectToServices(boolean bl) {
        boolean bl2 = true;
        ServiceThreadState serviceThreadState = this.webServiceCaller.connectNow(bl);
        if (serviceThreadState == ServiceThreadState.FAIL || serviceThreadState == ServiceThreadState.CANCELLED) {
            bl2 = false;
        }
        return bl2;
    }

    @Override
    public boolean login(String string, String string2) {
        return this.webServiceCaller.login(string, string2) == ServiceThreadState.SUCCESS;
    }

    @Override
    public void setLoginServiceLocation(String string) {
        this.webServiceCaller.setLoginServiceLocation(string);
    }

    @Override
    public void setActivationServiceLocation(String string) {
        this.webServiceCaller.setActivationServiceLocation(string);
    }

    @Override
    public ServiceThreadState fetchEntitlements() {
        ServiceThreadState serviceThreadState = this.webServiceCaller.getEntitlements();
        this.sendMessage(new UpdatedEntitlements());
        return serviceThreadState;
    }

    @Override
    public boolean hasEntitlements() {
        List list = this.account.getEntitlements();
        return !list.isEmpty();
    }

    @Override
    public void setEmailAddress(String string) {
        this.account.setEmailAddress(string);
    }

    @Override
    public void setPassword(String string) {
        this.account.setPassword(string);
    }

    @Override
    public void setFirstName(String string) {
        this.account.setFirstName(string);
    }

    @Override
    public void setLastName(String string) {
        this.account.setLastName(string);
    }

    private void validateEmailPassword() {
        String string;
        boolean bl = false;
        String string2 = this.account.getPassword();
        if (null != string2 && string2.length() >= 1 && (string = this.account.getEmailAddress()).length() > 0) {
            bl = true;
        }
        this.sendMessage(new ValidEmailAndPassword(bl));
    }

    @Override
    public void validateEmailPassword(String string, String string2) {
        boolean bl = false;
        if (null != string2 && string2.length() >= 1 && string != null && string.length() > 0) {
            bl = true;
        }
        this.sendMessage(new ValidEmailAndPassword(bl));
    }

    @Override
    public void validateCreateAccountData(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        boolean bl = false;
        if (string != null && string.length() > 0 && string5 != null && string5.length() > 0 && string6 != null && string6.length() > 0 && string7 != null && string7.length() > 0 && string2.length() > 0 && string3.length() > 0 && string4.length() > 0) {
            bl = true;
        }
        this.sendMessage(new ValidCreateAccountData(bl));
    }

    @Override
    public boolean isLoggingIn() {
        return this.loggingIn;
    }

    @Override
    public void setLoggingIn() {
        this.loggingIn = true;
        this.selectingEntitlement = true;
        this.activatingWithLicenseFile = false;
        this.validateEmailPassword();
    }

    @Override
    public void setCreatingAccount() {
        this.loggingIn = false;
        this.selectingEntitlement = false;
        this.activatingWithLicenseFile = false;
        this.sendMessage(new CreatingAccountForSelf(true));
    }

    @Override
    public boolean activatingNetworkLicenseFileWithoutServerLine() {
        LicenseFileParserImpl licenseFileParserImpl = new LicenseFileParserImpl();
        return !licenseFileParserImpl.containsServerLine(this.licenseString) && licenseFileParserImpl.hasCountedIncrementLine(this.licenseString);
    }

    @Override
    public boolean getSelectingEntitlement() {
        return this.selectingEntitlement;
    }

    @Override
    public void setSelectingEntitlement(boolean bl) {
        this.selectingEntitlement = bl;
        this.sendMessage(new SetSelectingEntitlement(bl));
        if (this.selectingEntitlement) {
            this.validateEntitlementById(this.entitlementId);
        } else {
            this.account.setSelectedEntitlement("");
        }
    }

    @Override
    public InstallerEntitlement getEntitlement() {
        return this.account.getSelectedEntitlement();
    }

    @Override
    public void setEntitlement(String string) {
        ActivationMessage activationMessage;
        LockingTypeConstants lockingTypeConstants;
        InstallerEntitlement installerEntitlement;
        this.account.setSelectedEntitlement(string);
        this.sendMessage(new IsLicenseAdmin(this.account.isAdmin(string)));
        this.entitlementId = string;
        if (null != this.entitlementId && (installerEntitlement = this.account.getSelectedEntitlement()) != null && (lockingTypeConstants = installerEntitlement.getSelectedLockingType()) != null && null != (activationMessage = ACTIVATION_TYPE_MAP.get(lockingTypeConstants))) {
            this.sendMessage(activationMessage);
        }
    }

    @Override
    public void setActivationKey(String string) {
        this.account.setActivationKey(string);
        this.activationKey = string;
    }

    @Override
    public void validateEntitlementById(String string) {
        boolean bl = false;
        if (string != null && !"".equalsIgnoreCase(string)) {
            bl = true;
            this.entitlementId = string;
        }
        this.sendMessage(new ValidEntitlement(bl));
    }

    @Override
    public boolean validateActivationKeyForA2akOffEntitlement(String string) {
        this.sendMessage(new ValidActivationKeyForA2akOffEntitlement(true));
        return true;
    }

    @Override
    public boolean validateActivationKeyForNewEntitlement(String string) {
        this.sendMessage(new ValidActivationKey(true));
        return true;
    }

    @Override
    public boolean validateMyUserName() {
        boolean bl = false;
        String string = this.account.getUserName();
        if (string != null && !"".equalsIgnoreCase(string)) {
            bl = true;
        }
        this.sendMessage(new ValidMyUserName(bl));
        return bl;
    }

    @Override
    public WebServiceResponse<InstallerEntitlement> getEntitlementByActivationKey(String string) {
        WebServiceResponse<InstallerEntitlement> webServiceResponse = this.webServiceCaller.getEntitlementByActivationKey(string);
        if (webServiceResponse.getState() == ServiceThreadState.SUCCESS) {
            this.notifyActivateState();
            InstallerEntitlement installerEntitlement = this.account.getSelectedEntitlement();
            this.entitlementId = installerEntitlement.getId();
        }
        return webServiceResponse;
    }

    @Override
    public void getPeople() {
        MWAGetPeopleResponse mWAGetPeopleResponse = this.webServiceCaller.getPeople();
        if (this.fPreviousActivationKey == null || !this.fPreviousActivationKey.equalsIgnoreCase(this.account.getActivationKey())) {
            this.fPreviousActivationKey = this.account.getActivationKey();
            int n = mWAGetPeopleResponse.getTotalCount();
            if (n == 1) {
                MWAEntitledPerson mWAEntitledPerson = mWAGetPeopleResponse.getPeople().getPeople()[0];
                if (this.account.getEmailAddress().equalsIgnoreCase(mWAEntitledPerson.getEmailAddress())) {
                    this.clearLeuData();
                } else {
                    LeuData leuData = new LeuData(mWAEntitledPerson.getFirstName(), mWAEntitledPerson.getLastName(), mWAEntitledPerson.getEmailAddress());
                    this.sendMessage(leuData);
                    this.activatingForOther();
                }
            } else if (n == 0 || n > 1) {
                this.clearLeuData();
            }
        }
    }

    private void clearLeuData() {
        this.sendMessage(new LeuData("", "", ""));
        this.activatingForSelf();
    }

    @Override
    public boolean createProfileForOther() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5 = this.account.getSecurityToken();
        return this.webServiceCaller.createProfileForOther(string5, string4 = this.accountForOther.getEmailAddress(), string3 = this.accountForOther.getFirstName(), string2 = this.accountForOther.getLastName(), string = this.account.getActivationKey()) == ServiceThreadState.SUCCESS;
    }

    @Override
    public boolean createProfileForSelf(String string, String string2, String string3, String string4, String string5) {
        return this.webServiceCaller.createProfileForSelf(string, string2, string3, string4, string5) == ServiceThreadState.SUCCESS;
    }

    @Override
    public void activatingForOther() {
        if (this.inuSelected) {
            this.onlineActivateState = this.activateStateFactory.createActivateInuForOtherState();
            this.notifyActivateState();
        } else {
            this.onlineActivateState = this.activateStateFactory.createActivateOtherState();
            this.notifyActivateState();
        }
    }

    @Override
    public void activatingForSelf() {
        if (this.inuSelected) {
            this.onlineActivateState = this.activateStateFactory.createActivateInuState();
            this.notifyActivateState();
        } else {
            this.onlineActivateState = this.activateStateFactory.createActivateSelfState();
            this.notifyActivateState();
        }
    }

    @Override
    public void activatingFromLicenseFile() {
        if (this.activatingOnline) {
            this.onlineActivateState = this.activateStateFactory.createActivateFromLicenseFileState();
        } else {
            this.offlineActivateState = this.activateStateFactory.createActivateFromLicenseFileState();
        }
        this.activatingWithLicenseFile = true;
        this.loggingIn = false;
        this.selectingEntitlement = false;
        this.notifyActivateState();
    }

    @Override
    public void notActivating() {
        this.offlineActivateState = this.activateStateFactory.createActivateNoOpState();
        this.notifyActivateState();
    }

    private ActivateState getActivateState() {
        if (this.activatingOnline) {
            return this.onlineActivateState;
        }
        return this.offlineActivateState;
    }

    @Override
    public void notifyActivateState() {
        ActivateState activateState = this.getActivateState();
        activateState.notifyState();
        activateState.validate();
    }

    @Override
    public void setUserNameForSelf(String string) {
        this.account.setUserName(string);
        this.onlineActivateState.validate();
    }

    @Override
    public void setFirstNameForOther(String string) {
        this.accountForOther.setFirstName(string);
        this.onlineActivateState.validate();
    }

    @Override
    public void setLastNameForOther(String string) {
        this.accountForOther.setLastName(string);
        this.onlineActivateState.validate();
    }

    @Override
    public void setEmailForOther(String string) {
        this.accountForOther.setEmailAddress(string);
        this.onlineActivateState.validate();
    }

    @Override
    public void setUserNameForOther(String string) {
        this.accountForOther.setUserName(string);
        this.onlineActivateState.validate();
    }

    @Override
    public void setActivationTypeDc() {
        this.account.getSelectedEntitlement().setSelectedLockingType(LockingTypeConstants.COMPUTER_BASED);
        this.sendMessage(new DcSelected());
        this.sendMessage(new InuSelected(false));
    }

    @Override
    public void setActivationTypeSnu() {
        this.account.getSelectedEntitlement().setSelectedLockingType(LockingTypeConstants.USER_BASED);
        this.sendMessage(new SnuSelected());
        this.sendMessage(new InuSelected(false));
    }

    @Override
    public void setInuSelected() {
        this.inuSelected = true;
        this.sendMessage(new InuSelected(true));
    }

    @Override
    public Account getOtherAccount() {
        return this.accountForOther;
    }

    @Override
    public void setDcAnonymous(boolean bl) {
        this.dcAnonymous = bl;
        this.sendMessage(new DcAnonymous(bl));
        if (bl) {
            this.onlineActivateState = this.activateStateFactory.createActivateAnonState();
            this.notifyActivateState();
        } else {
            this.activatingForSelf();
        }
    }

    @Override
    public boolean isDcAnonymous() {
        return this.dcAnonymous;
    }

    @Override
    public void setLicenseFile(String string) {
        String string2 = new FolderUtilsImpl().scrub(string);
        if (this.activatingOnline) {
            this.setOnlineLicenseFileAndState(string2);
        } else {
            this.setOfflineLicenseFileAndState(string2);
        }
    }

    private void setOfflineLicenseFileAndState(String string) {
        this.offlineLicenseFile = string;
        this.offlineActivateState.validate();
    }

    private void setOnlineLicenseFileAndState(String string) {
        this.onlineLicenseFile = string;
        this.onlineActivateState.validate();
    }

    @Override
    public String getLicenseFile() {
        if (this.activatingOnline) {
            return this.onlineLicenseFile;
        }
        return this.offlineLicenseFile;
    }

    @Override
    public InstUtilResourceBundle getResources() {
        return this.view.getResources();
    }

    @Override
    public void exception(Throwable throwable, boolean bl) {
        this.view.exception(throwable, bl);
    }

    @Override
    public void setWebServiceTrack(String string) {
        this.webServiceCaller.setWebServiceTrack(string);
    }

    @Override
    public void setWebServiceProtocol(String string) {
        this.webServiceCaller.setWebServiceProtocol(string);
    }

    @Override
    public void validateActivateState() {
        this.getActivateState().validate();
    }

    @Override
    public String getServiceLocation() {
        return this.webServiceCaller.getLoginServiceLocation();
    }

    @Override
    public String getUserName() {
        return this.info.getUName();
    }

    @Override
    public void setSecurityToken(String string) {
        this.getAccount().setSecurityToken(string);
    }

    @Override
    public void setInitialState() {
        StartState startState;
        this.setInitialEntitlement();
        String string = this.account.getSecurityToken();
        if (this.activationKey == null && string == null && this.entitlementId == null) {
            startState = new StartStateStandard();
            this.activationKeyPassedIn = false;
        } else if (this.activationKey == null && this.entitlementId == null) {
            startState = new StartStateToken();
            this.activationKeyPassedIn = false;
        } else if (string == null && this.activationKey != null) {
            startState = new StartStateKey();
            this.activationKeyPassedIn = true;
        } else if (string != null && this.activationKey != null) {
            startState = new StartStateTokenKey();
            this.activationKeyPassedIn = true;
        } else if (string != null) {
            startState = new StartStateTokenId();
            this.activationKeyPassedIn = false;
        } else {
            startState = new StartStateId();
            this.activationKeyPassedIn = false;
        }
        this.sendMessage(startState);
    }

    private void setInitialEntitlement() {
        Account account = this.getAccount();
        if (this.entitlementId != null || this.activationKey != null) {
            InstallerEntitlement installerEntitlement = InstallerEntitlementFactoryImpl.createInstallerEntitlement();
            if (this.entitlementId != null) {
                installerEntitlement.setId(this.entitlementId);
            }
            if (this.activationKey != null) {
                account.setActivationKey(this.activationKey);
                installerEntitlement.setActivationKey(this.activationKey);
            }
            account.setSelectedEntitlement(installerEntitlement);
        }
    }

    @Override
    public ProxyTester getProxyTester() {
        return new ProxyTester(){
            private boolean success;

            public boolean isSuccess() {
                return this.success;
            }

            public void run() {
                ActivationModelImpl.this.webServiceCaller.disconnect();
                this.success = ActivationModelImpl.this.connectToServices(true);
            }
        };
    }

    public LicenseLocationFactory getLicenseLocationFactory() {
        return this.licLocFactory;
    }

    public String getUName() {
        return this.getMachineInfo().getUName();
    }

    public String getHostName() {
        return this.getMachineInfo().getHostName();
    }

    public String getEthernetAddress() {
        return this.getMachineInfo() == null ? "" : this.getMachineInfo().getEthernetAddress();
    }

    public String getIpAddress() {
        return this.getMachineInfo() == null ? "" : this.getMachineInfo().getIpAddress();
    }

    @Override
    public void clearAccountForDCAnonSelection() {
        this.account = this.accountFactory.createAccount();
        if (this.activationKeyPassedIn) {
            this.account.setActivationKey(this.activationKey);
        }
        this.activatingForSelf();
    }

    @Override
    public boolean activationKeyPassedIntoClient() {
        return this.activationKeyPassedIn;
    }

    @Override
    public String getInitialActivationKey() {
        return this.initialActivationKey;
    }

    @Override
    public void setInitialActivationKey(String string) {
        this.initialActivationKey = string;
        this.setActivationKey(string);
    }

    @Override
    public boolean isCreatingAccount() {
        return !this.loggingIn && !this.selectingEntitlement && !this.activatingWithLicenseFile;
    }

    @Override
    public boolean isActivatingWithLicenseFile() {
        return this.activatingWithLicenseFile;
    }

    @Override
    public boolean isInuCapable() {
        return this.inuCapable;
    }

    private void setInuCapable(boolean bl) {
        this.inuCapable = bl;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void setIsStudent(boolean bl) {
        this.isStudent = bl;
    }

    @Override
    public boolean getIsStudent() {
        return this.isStudent;
    }

    static {
        SnuSelected snuSelected = new SnuSelected();
        DcSelected dcSelected = new DcSelected();
        ACTIVATION_TYPE_MAP = new HashMap<LockingTypeConstants, ActivationMessage>();
        ACTIVATION_TYPE_MAP.put(LockingTypeConstants.USER_BASED, snuSelected);
        ACTIVATION_TYPE_MAP.put(LockingTypeConstants.COMPUTER_BASED, dcSelected);
    }
}

