/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient.controller;

import com.mathworks.activationclient.command.ControllerCommand;
import com.mathworks.activationclient.command.ControllerCommandFactory;
import com.mathworks.activationclient.controller.ApplicationController;
import com.mathworks.activationclient.controller.BasePanelController;
import com.mathworks.activationclient.model.ActivationModel;
import com.mathworks.activationclient.model.message.ValidMyUserName;
import com.mathworks.activationclient.view.username.UserNamePanel;
import com.mathworks.activationclient.view.username.UserNamePanelController;

public class UserNamePanelControllerImpl
extends BasePanelController
implements UserNamePanelController {
    private UserNamePanel panel;

    public UserNamePanelControllerImpl(ApplicationController applicationController, ActivationModel activationModel, ControllerCommandFactory controllerCommandFactory) {
        super(applicationController, activationModel, controllerCommandFactory);
    }

    @Override
    public final void setPanel(UserNamePanel userNamePanel) {
        assert (this.panel == null);
        this.panel = userNamePanel;
        String string = this.model.getUserName();
        this.panel.setUserNameTextField(string);
        ControllerCommand controllerCommand = this.model.getIsStudent() ? this.commandFactory.createShowStudentGuiltPanelCommand() : this.commandFactory.createShowConfirmationPanelCommand();
        this.setNextButtonCommand(controllerCommand);
        super.setPanel(userNamePanel);
    }

    @Override
    public void updateMyUserName(String string) {
        this.model.setUserNameForSelf(string);
        this.model.validateMyUserName();
    }

    void dispatch(ValidMyUserName validMyUserName) {
        if (validMyUserName.getValue()) {
            ControllerCommand controllerCommand = this.model.getIsStudent() ? this.commandFactory.createShowStudentGuiltPanelCommand() : this.commandFactory.createShowConfirmationPanelCommand();
            this.setNextButtonCommand(controllerCommand);
        } else {
            this.setNextButtonCommand(null);
        }
    }

    @Override
    String getHelpPath() {
        return "help.user";
    }
}

