/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient.controller;

import com.mathworks.activationclient.command.ControllerCommand;
import com.mathworks.activationclient.command.ControllerCommandFactory;
import com.mathworks.activationclient.controller.ApplicationController;
import com.mathworks.activationclient.controller.BasePanelController;
import com.mathworks.activationclient.model.ActivationModel;
import com.mathworks.activationclient.model.message.SetSelectingEntitlement;
import com.mathworks.activationclient.model.message.UpdatedEntitlements;
import com.mathworks.activationclient.model.message.ValidActivationKey;
import com.mathworks.activationclient.model.message.ValidEntitlement;
import com.mathworks.activationclient.view.selection.EntitlementSelectionPanel;
import com.mathworks.activationclient.view.selection.EntitlementSelectionPanelController;
import com.mathworks.mlwebservices.Account;
import com.mathworks.mlwebservices.InstallerEntitlement;

public class EntitlementSelectionPanelControllerImpl
extends BasePanelController
implements EntitlementSelectionPanelController {
    private EntitlementSelectionPanel panel;
    private String selectedEntitlementId;
    private String activationKey;
    private ApplicationController applicationController;

    public EntitlementSelectionPanelControllerImpl(ApplicationController applicationController, ActivationModel activationModel, ControllerCommandFactory controllerCommandFactory) {
        super(applicationController, activationModel, controllerCommandFactory);
        this.applicationController = applicationController;
    }

    @Override
    public final void setPanel(EntitlementSelectionPanel entitlementSelectionPanel) {
        assert (null == this.panel);
        this.panel = entitlementSelectionPanel;
        Account account = this.model.getAccount();
        this.panel.setAccount(account);
        boolean bl = this.model.getSelectingEntitlement();
        this.panel.setSelectingEntitlement(bl);
        super.setPanel(entitlementSelectionPanel);
        this.setNextButtonCommand(null);
    }

    @Override
    public void setSelectingEntitlement(boolean bl) {
        this.model.setSelectingEntitlement(bl);
    }

    @Override
    public String getLocalizedHelpPath(String string) {
        return this.applicationController.getLocalizedHelpPath(string);
    }

    @Override
    public void selectEntitlement(String string) {
        this.selectedEntitlementId = string;
        this.model.validateEntitlementById(string);
    }

    @Override
    public void setActivationKey(String string) {
        this.activationKey = string;
        this.model.validateActivationKeyForNewEntitlement(string);
    }

    void dispatch(SetSelectingEntitlement setSelectingEntitlement) {
        boolean bl = setSelectingEntitlement.getValue();
        this.panel.setSelectingEntitlement(bl);
    }

    void dispatch(ValidEntitlement validEntitlement) {
        if (validEntitlement.getValue()) {
            ControllerCommand controllerCommand;
            Account account = this.model.getAccount();
            if (this.selectedEntitlementId != null && account.a2ak(this.selectedEntitlementId)) {
                controllerCommand = this.commandFactory.createValidateEntitlementByEntitlementIdCommand(this.selectedEntitlementId);
            } else {
                this.model.setEntitlement(this.selectedEntitlementId);
                InstallerEntitlement installerEntitlement = this.model.getEntitlement();
                controllerCommand = this.commandFactory.createIsNetworkCommand(this.commandFactory.createShowActivationKeyPanelCommand(), installerEntitlement);
            }
            this.setNextButtonCommand(controllerCommand);
        } else {
            this.setNextButtonCommand(null);
        }
    }

    void dispatch(ValidActivationKey validActivationKey) {
        if (validActivationKey.getValue()) {
            ControllerCommand controllerCommand = this.commandFactory.createValidateEntitlementByActivationKeyCommand(this.activationKey);
            this.setNextButtonCommand(controllerCommand);
        } else {
            this.setNextButtonCommand(null);
        }
    }

    void dispatch(UpdatedEntitlements updatedEntitlements) {
        Account account = this.model.getAccount();
        this.panel.setAccount(account);
        this.panel.setSelectingEntitlement(true);
    }

    @Override
    String getHelpPath() {
        return "help.select";
    }
}

