/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.brsanthu.dataexporter.output.xml;

import com.mathworks.apache.commons.lang3.StringEscapeUtils;
import com.mathworks.brsanthu.dataexporter.AbstractDataWriter;
import com.mathworks.brsanthu.dataexporter.ExportOptions;
import com.mathworks.brsanthu.dataexporter.model.CellDetails;
import com.mathworks.brsanthu.dataexporter.model.RowDetails;
import com.mathworks.brsanthu.dataexporter.model.Table;
import com.mathworks.brsanthu.dataexporter.output.xml.XmlExportOptions;
import java.io.OutputStream;
import java.io.Writer;

public class XmlWriter
extends AbstractDataWriter {
    public XmlWriter(XmlExportOptions options) {
        super((ExportOptions)options, System.out);
    }

    public XmlWriter(XmlExportOptions options, OutputStream out) {
        super((ExportOptions)options, out);
    }

    public XmlWriter(OutputStream out) {
        super((ExportOptions)new XmlExportOptions(), out);
    }

    public XmlWriter(XmlExportOptions options, Writer out) {
        super((ExportOptions)options, out);
    }

    public XmlWriter(Writer out) {
        super((ExportOptions)new XmlExportOptions(), out);
    }

    public XmlExportOptions getXmlExportOptions() {
        return (XmlExportOptions)this.getOptions();
    }

    @Override
    public void beforeTable(Table table) {
        this.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.prettyPrint(0);
        this.print("<table>");
    }

    @Override
    public void beforeRow(RowDetails rowDetails) {
        this.prettyPrint(1);
        this.print("<row>");
    }

    @Override
    public void writeRowCell(CellDetails cellDetails) {
        this.prettyPrint(2);
        String title = cellDetails.getColumn().getTitle();
        String title2 = cellDetails.getColumn().getTitle2();
        String title3 = cellDetails.getColumn().getTitle3();
        String name = title + (!"".equals(title2) ? " " + title2 : "") + (!"".equals(title3) ? " " + title3 : "");
        String cellValue = StringEscapeUtils.escapeXml(cellDetails.getColumn().format(cellDetails));
        String nil = cellDetails.getColumn().isNillable() && "".equals(cellValue) ? " xsi:nil=\"true\"" : "";
        this.print("<column name=\"" + name + "\"" + nil + ">" + cellValue + "</column>");
    }

    @Override
    public void afterRow(RowDetails rowDetails) {
        this.prettyPrint(1);
        this.print("</row>");
    }

    @Override
    public void afterTable(Table table) {
        this.prettyPrint(0);
        this.print("</table>");
    }

    private void prettyPrint(int level) {
        if (this.getXmlExportOptions().isPrettyPrint()) {
            this.print("\n");
            for (int i = 0; i < level; ++i) {
                this.print('\t');
            }
        }
    }
}

