/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.brsanthu.dataexporter;

import com.mathworks.brsanthu.dataexporter.model.AlignType;
import com.mathworks.brsanthu.dataexporter.util.Util;
import java.util.ArrayList;
import java.util.List;

public class TextAligner {
    public int getRowHeight(int width, String data, AlignType alignType) {
        List<String> alignedStrings = this.align(width, data.length(), alignType, data);
        int rowHeight = 0;
        for (String line : alignedStrings) {
            if (line.trim().length() <= 0) continue;
            ++rowHeight;
        }
        return Math.max(1, rowHeight);
    }

    public List<String> align(int width, int height, AlignType align, String data) {
        return this.align(width, height, align, data, " ");
    }

    public List<String> align(int width, int height, AlignType align, String data, String filler) {
        ArrayList<String> compacted;
        block49: {
            block48: {
                Util.checkForNotNull((Object)align, "align");
                if (height <= 0 || width <= 0) {
                    throw new IllegalArgumentException("Height or width cannot be less than or equal to zero.");
                }
                if (data == null) {
                    data = "";
                }
                int totalChars = width * height;
                if (data.length() > totalChars) {
                    throw new IllegalArgumentException("Data given (" + data.length() + " chars) is bigger than cell size of " + totalChars + " chars (width " + width + " x height " + height + ")");
                }
                compacted = new ArrayList<String>();
                if (data.length() > width) break block48;
                switch (align) {
                    case TOP_CENTER: 
                    case TOP_LEFT: 
                    case TOP_RIGHT: {
                        compacted.add(data);
                        for (int i = 0; i < height - 1; ++i) {
                            compacted.add("");
                        }
                        break block49;
                    }
                    case MIDDLE_CENTER: 
                    case MIDDLE_LEFT: 
                    case MIDDLE_RIGHT: {
                        int i;
                        int midwayIndex = (int)Math.ceil((float)height / 2.0f) - 1;
                        if (midwayIndex >= height) {
                            --midwayIndex;
                        }
                        for (i = 0; i < midwayIndex; ++i) {
                            compacted.add("");
                        }
                        compacted.add(data);
                        for (i = midwayIndex + 1; i < height; ++i) {
                            compacted.add("");
                        }
                        break block49;
                    }
                    case BOTTOM_CENTER: 
                    case BOTTOM_LEFT: 
                    case BOTTOM_RIGHT: {
                        int i;
                        for (i = 0; i < height - 1; ++i) {
                            compacted.add("");
                        }
                        compacted.add(data);
                    }
                }
                break block49;
            }
            String[] words = data.split("\\s");
            ArrayList<String> wordsFinal = new ArrayList<String>();
            for (String word : words) {
                if (word.trim().length() >= width) {
                    wordsFinal.addAll(this.splitWord(word, width));
                    continue;
                }
                wordsFinal.add(word.trim());
            }
            StringBuilder sb = new StringBuilder();
            int numerOfFillers = 0;
            switch (align) {
                case TOP_CENTER: 
                case TOP_LEFT: 
                case TOP_RIGHT: {
                    int i;
                    for (i = 0; i < wordsFinal.size(); ++i) {
                        if ((sb.length() == 0 ? 0 : sb.length() + 1) + ((String)wordsFinal.get(i)).length() <= width) {
                            if (sb.length() > 0) {
                                sb.append(" ");
                            }
                            sb.append((String)wordsFinal.get(i));
                            continue;
                        }
                        compacted.add(sb.toString());
                        sb = new StringBuilder();
                        sb.append((String)wordsFinal.get(i));
                    }
                    if (sb.length() > 0) {
                        compacted.add(sb.toString());
                    }
                    numerOfFillers = height - compacted.size();
                    for (i = 0; i < numerOfFillers; ++i) {
                        compacted.add("");
                    }
                    break;
                }
                case MIDDLE_CENTER: 
                case MIDDLE_LEFT: 
                case MIDDLE_RIGHT: {
                    int i;
                    int midwayIndex = (int)Math.ceil((float)wordsFinal.size() / 2.0f);
                    if (midwayIndex >= wordsFinal.size()) {
                        --midwayIndex;
                    }
                    for (i = midwayIndex; i >= 0; --i) {
                        if (sb.length() + ((String)wordsFinal.get(i)).length() <= width - 1) {
                            if (sb.length() > 0) {
                                sb.insert(0, " ");
                            }
                            sb.insert(0, (String)wordsFinal.get(i));
                            continue;
                        }
                        compacted.add(0, sb.toString());
                        sb = new StringBuilder();
                        sb.insert(0, (String)wordsFinal.get(i));
                    }
                    if (sb.length() > 0) {
                        compacted.add(0, sb.toString());
                    }
                    sb = new StringBuilder();
                    for (i = midwayIndex + 1; i < wordsFinal.size(); ++i) {
                        if (sb.length() + ((String)wordsFinal.get(i)).length() <= width) {
                            if (sb.length() > 0) {
                                sb.append(" ");
                            }
                            sb.append((String)wordsFinal.get(i));
                            continue;
                        }
                        compacted.add(sb.toString());
                        sb = new StringBuilder();
                        sb.append((String)wordsFinal.get(i));
                    }
                    if (sb.length() > 0) {
                        compacted.add(sb.toString());
                    }
                    numerOfFillers = Math.max(0, height - compacted.size()) / 2;
                    for (i = 0; i < numerOfFillers; ++i) {
                        compacted.add(0, "");
                    }
                    numerOfFillers = height - compacted.size();
                    for (i = 0; i < numerOfFillers; ++i) {
                        compacted.add("");
                    }
                    break;
                }
                case BOTTOM_CENTER: 
                case BOTTOM_LEFT: 
                case BOTTOM_RIGHT: {
                    int i;
                    for (i = wordsFinal.size() - 1; i >= 0; --i) {
                        if (sb.length() + ((String)wordsFinal.get(i)).length() <= width - 1) {
                            if (sb.length() > 0) {
                                sb.insert(0, " ");
                            }
                            sb.insert(0, (String)wordsFinal.get(i));
                            continue;
                        }
                        compacted.add(0, sb.toString());
                        sb = new StringBuilder();
                        sb.insert(0, (String)wordsFinal.get(i));
                    }
                    if (sb.length() > 0) {
                        compacted.add(0, sb.toString());
                    }
                    numerOfFillers = height - compacted.size();
                    for (i = 0; i < numerOfFillers; ++i) {
                        compacted.add(0, "");
                    }
                    break;
                }
            }
        }
        ArrayList<String> aligned = new ArrayList<String>();
        for (int i = 0; i < compacted.size(); ++i) {
            int prefixCount = 0;
            int suffixCount = 0;
            String tempData = (String)compacted.get(i);
            if (tempData == null) {
                tempData = "";
            }
            switch (align) {
                case TOP_LEFT: 
                case MIDDLE_LEFT: 
                case BOTTOM_LEFT: {
                    suffixCount = width - tempData.length();
                    break;
                }
                case TOP_CENTER: 
                case MIDDLE_CENTER: 
                case BOTTOM_CENTER: {
                    prefixCount = (width - tempData.length()) / 2;
                    suffixCount = width - prefixCount - tempData.length();
                    break;
                }
                case TOP_RIGHT: 
                case MIDDLE_RIGHT: 
                case BOTTOM_RIGHT: {
                    prefixCount = width - tempData.length();
                }
            }
            aligned.add(Util.createSpacer(prefixCount) + tempData + Util.createSpacer(suffixCount));
        }
        return aligned;
    }

    private String substring(String data, int startIndex, int endIndex) {
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > data.length()) {
            endIndex = data.length();
        }
        return data.substring(startIndex, endIndex);
    }

    private List<String> splitWord(String word, int width) {
        ArrayList<String> words = new ArrayList<String>();
        for (int startIndex = 0; startIndex < word.length(); startIndex += width) {
            words.add(this.substring(word, startIndex, startIndex + width).trim());
        }
        return words;
    }
}

