/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.brsanthu.dataexporter;

import com.mathworks.brsanthu.dataexporter.DataWriter;
import com.mathworks.brsanthu.dataexporter.ExportOptions;
import com.mathworks.brsanthu.dataexporter.model.BeanRow;
import com.mathworks.brsanthu.dataexporter.model.Column;
import com.mathworks.brsanthu.dataexporter.model.DataExporterCallback;
import com.mathworks.brsanthu.dataexporter.model.Row;
import com.mathworks.brsanthu.dataexporter.model.StringColumn;
import com.mathworks.brsanthu.dataexporter.model.Table;
import com.mathworks.brsanthu.dataexporter.util.Util;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;

public abstract class DataExporter {
    private Table table = new Table();
    private DataWriter dataWriter = null;
    private boolean startedExporting = false;

    protected DataExporter(DataWriter dataWriter) {
        Util.checkForNotNull(dataWriter, "datawriter");
        this.dataWriter = dataWriter;
    }

    public DataExporterCallback getCallback() {
        return this.table.getCallback();
    }

    public void setCallback(DataExporterCallback callback) {
        this.table.setCallback(callback);
    }

    public void setOutputStream(PrintWriter out) {
        this.dataWriter.setOutputStream(out);
    }

    public DataWriter getDataWriter() {
        return this.dataWriter;
    }

    public ExportOptions getOptions() {
        return this.dataWriter.getOptions();
    }

    public DataExporter addColumn(String ... columns) {
        Util.checkForNotNull(columns, "columns");
        for (String column : columns) {
            this.table.addColumn(new StringColumn(column));
        }
        return this;
    }

    public DataExporter addColumns(Column ... columns) {
        Util.checkForNotNull(columns, "columns");
        this.checkNotExporting();
        for (Column column : columns) {
            this.table.addColumn(column);
        }
        return this;
    }

    public DataExporter addRow(Object ... rowValues) {
        Util.checkForNotNull(rowValues, "rowValues");
        Row row = new Row();
        row.add(rowValues);
        this.addRows(row);
        return this;
    }

    public DataExporter addRows(Row ... rows) {
        Util.checkForNotNull(rows, "rows");
        this.startExporting();
        this.dataWriter.writeRows(this.table, Arrays.asList(rows));
        return this;
    }

    public DataExporter addBeanRows(Object ... beans) {
        Util.checkForNotNull(beans, "beans");
        for (Object object : beans) {
            this.addRows(new BeanRow(object));
        }
        return this;
    }

    public DataExporter addBeanRows(List beans) {
        Util.checkForNotNull(beans, "beans");
        for (Object object : beans) {
            this.addRows(new BeanRow(object));
        }
        return this;
    }

    public synchronized void startExporting() {
        if (this.startedExporting) {
            return;
        }
        this.startedExporting = true;
        this.dataWriter.beforeTable(this.table);
        this.dataWriter.writeHeader(this.table);
    }

    public void finishExporting() {
        if (!this.startedExporting) {
            throw new IllegalStateException("Data export has not been started to finish!");
        }
        this.dataWriter.afterTable(this.table);
        this.dataWriter.flush();
        this.dataWriter.finishExporting();
        this.startedExporting = false;
    }

    private void checkNotExporting() {
        if (this.startedExporting) {
            throw new IllegalStateException("DataExporter has already started exporting the data and hence new columns cannot be added.");
        }
    }
}

