/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.mathworks.instutil.InstUtilPropertyKey;
import com.mathworks.instutil.Platform;
import com.mathworks.internal.dws.client.DownloadService;
import com.mathworks.internal.mwaws.client.v6.ActivationService;
import com.mathworks.mlwebservices.loginws.LoginService;
import com.mathworks.net.transport.MWTransportClientProperties;
import com.mathworks.net.transport.MWTransportClientPropertiesFactory;
import com.mathworks.webproxy.ProxyAuthenticator;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.webproxy.SystemProxySettings;
import com.mathworks.webproxy.WebproxyFactory;
import com.mathworks.wizard.ActivationServiceProxy;
import com.mathworks.wizard.DownloadServiceProxy;
import com.mathworks.wizard.LoginServiceProxy;
import com.mathworks.wizard.PropertyKey;
import com.mathworks.wizard.SourcePathProvider;
import java.util.Properties;

final class WebServicesModule
extends AbstractModule {
    WebServicesModule() {
    }

    protected void configure() {
        this.bind(LoginService.class).to(LoginServiceProxy.class).in(Scopes.SINGLETON);
        this.bind(ActivationService.class).to(ActivationServiceProxy.class).in(Scopes.SINGLETON);
        this.bind(DownloadService.class).to(DownloadServiceProxy.class).in(Scopes.SINGLETON);
        this.bind(ProxyAuthenticator.class).toInstance((Object)WebproxyFactory.createProxyAuthenticator());
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.axis2.transport.http", "off");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "off");
    }

    @Provides
    @Singleton
    static MWTransportClientProperties provideTCP(Properties properties) {
        MWTransportClientProperties mWTransportClientProperties = MWTransportClientPropertiesFactory.create((String)"http");
        mWTransportClientProperties.setProxyHost(properties.getProperty(PropertyKey.PROXY_HOST.get(), mWTransportClientProperties.getProxyHost()));
        mWTransportClientProperties.setProxyPort(properties.getProperty(PropertyKey.PROXY_PORT.get(), mWTransportClientProperties.getProxyPort()));
        mWTransportClientProperties.setProxyUser(properties.getProperty(PropertyKey.PROXY_USER.get(), mWTransportClientProperties.getProxyUser()));
        mWTransportClientProperties.setProxyPassword(properties.getProperty(PropertyKey.PROXY_PASSWORD.get(), mWTransportClientProperties.getProxyPassword()));
        return mWTransportClientProperties;
    }

    @Provides
    static SystemProxySettings proxySystemProxySettings(Properties properties, SourcePathProvider sourcePathProvider, Platform platform) {
        String string = properties.getProperty(InstUtilPropertyKey.LIBDIR.get());
        String string2 = string == null ? sourcePathProvider.getSourcePath() : string;
        return WebproxyFactory.createSystemProxySettings((String)platform.getNativeLibraryPath(string2));
    }

    @Provides
    @Singleton
    static ProxyConfiguration provideProxyConfiguration(SystemProxySettings systemProxySettings, Properties properties) {
        WebproxyFactory.setUseSystemProxiesEnabled((boolean)Boolean.parseBoolean(properties.getProperty(PropertyKey.USE_SYSTEM_PROXIES.get(), "true")));
        return WebproxyFactory.createDefaultProxyConfiguration((SystemProxySettings)systemProxySettings);
    }
}

