/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard;

import com.mathworks.instutil.Platform;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.ResourceLocale;
import com.mathworks.instutil.ResourceLocaleFactory;
import com.mathworks.wizard.ImageResourceRetriever;
import com.mathworks.wizard.ResourceRetriever;
import com.mathworks.wizard.resources.WizardResourceKey;
import com.mathworks.wizard.resources.WizardResourceKeys;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public final class ResourceRetrieverImpl
implements ResourceRetriever {
    private static final String DEFAULT_BASE_NAME = "com.mathworks.wizard.resources.RES_Wizard";
    private final Collection<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
    private final PlatformImpl platform = new PlatformImpl();

    public ResourceRetrieverImpl(String ... stringArray) {
        ResourceLocale resourceLocale = ResourceLocaleFactory.createResourceLocale((Platform)this.platform);
        for (String string : stringArray) {
            this.bundles.add(resourceLocale.getBundle(string));
            try {
                this.bundles.add(resourceLocale.getBundle(ResourceRetrieverImpl.getUntranslatedBundleName(string)));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                this.bundles.add(resourceLocale.getBundle(ResourceRetrieverImpl.getGeneratedPropertiesFile(string)));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        this.bundles.add(resourceLocale.getBundle(DEFAULT_BASE_NAME));
        this.bundles.add(resourceLocale.getBundle(ResourceRetrieverImpl.getUntranslatedBundleName(DEFAULT_BASE_NAME)));
    }

    private static String getGeneratedPropertiesFile(String string) {
        return string.concat("_generated_props");
    }

    private static String getUntranslatedBundleName(String string) {
        return string.concat("_notranslation");
    }

    @Override
    public String getResource(WizardResourceKey wizardResourceKey, Object ... objectArray) {
        return this.getResource(wizardResourceKey.getKey(), objectArray);
    }

    @Override
    public String getResource(String string, Object ... objectArray) {
        for (ResourceBundle resourceBundle : this.bundles) {
            try {
                String string2 = resourceBundle.getString(string);
                return MessageFormat.format(string2, objectArray);
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return "";
    }

    @Override
    public ImageIcon getImage(ImageResourceRetriever imageResourceRetriever, Object ... objectArray) {
        WizardResourceKeys wizardResourceKeys = imageResourceRetriever.getString((Platform)this.platform);
        String string = this.getResource(wizardResourceKeys, objectArray);
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            return new ImageIcon();
        }
        return new ImageIcon(uRL);
    }

    @Override
    public ImageIcon getIcon(WizardResourceKey wizardResourceKey, Object ... objectArray) {
        String string = this.getResource(wizardResourceKey, objectArray);
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            return new ImageIcon();
        }
        return new ImageIcon(uRL);
    }
}

