/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard;

import com.google.inject.Inject;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.instutil.ExecutorServiceManager;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.wizard.ExitHandler;
import com.mathworks.wizard.ExitStatus;
import com.mathworks.wizard.ExitStrategy;
import com.mathworks.wizard.ui.WizardUI;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;

final class BlockingExitHandler
implements ExitHandler {
    private final CountDownLatch exitLatch;
    private final ExecutorServiceManager executorServiceManager;
    private final WizardUI ui;
    private final ExitStrategy exitStrategy;
    private final UsageDataCollector usageDataCollector;
    private final AppLogger appLogger;
    private boolean exitStarted;
    private ExitStatus exitStatus;

    @Inject
    BlockingExitHandler(ExecutorServiceManager executorServiceManager, WizardUI wizardUI, AppLogger appLogger, ExitStrategy exitStrategy, UsageDataCollector usageDataCollector) {
        this.executorServiceManager = executorServiceManager;
        this.usageDataCollector = usageDataCollector;
        this.ui = wizardUI;
        this.exitStrategy = exitStrategy;
        this.exitLatch = new CountDownLatch(1);
        this.appLogger = appLogger;
    }

    @Override
    public synchronized void exit(ExitStatus exitStatus) {
        if (this.exitStarted) {
            return;
        }
        this.exitStarted = true;
        this.exitStatus = exitStatus;
        this.ui.closeAndDispose();
        this.prepareUsageData();
        this.appLogger.logMsg("Exiting with status " + Integer.toString(this.exitStatus.getExitCode()));
        new Thread(new Runnable(){

            @Override
            public void run() {
                String string;
                if (BlockingExitHandler.this.exitStatus == ExitStatus.SUCCESS) {
                    BlockingExitHandler.this.executorServiceManager.shutdownAndAwaitTermination();
                    string = "End - Successful.";
                } else {
                    BlockingExitHandler.this.executorServiceManager.shutdownAndAwaitTerminationWhenFailed();
                    string = "End - Unsuccessful.";
                }
                BlockingExitHandler.this.usageDataCollector.transmitData();
                BlockingExitHandler.this.appLogger.logMsg(string);
                BlockingExitHandler.this.appLogger.close();
                BlockingExitHandler.this.exitLatch.countDown();
                BlockingExitHandler.this.exitStrategy.exit(BlockingExitHandler.this.exitStatus);
            }
        }).start();
    }

    private void prepareUsageData() {
        this.usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_END_TIME, (Object)new Date());
        this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_EXIT_STATUS, (Object)this.exitStatus.getExitCode());
        this.usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_SESSION_SUCCESSFUL, (Object)(this.exitStatus == ExitStatus.SUCCESS ? 1 : 0));
        this.usageDataCollector.prepareDataForTransmission(UUID.randomUUID().toString());
    }

    @Override
    public ExitStatus waitFor() {
        try {
            this.exitLatch.await();
            return this.exitStatus;
        }
        catch (InterruptedException interruptedException) {
            return ExitStatus.CANCELLED;
        }
    }
}

