/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwebservices;

import com.mathworks.mlwebservices.Account;
import com.mathworks.mlwebservices.InstallerEntitlement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class AccountImpl
implements Account {
    private String securityToken;
    private Map<String, InstallerEntitlement> entitlementMap = new LinkedHashMap<String, InstallerEntitlement>();
    private String emailAddress = "";
    private String password;
    private String selectedEntitlementId = "";
    private String firstName = "";
    private String lastName = "";
    private String userName = "";
    private String activationKey;
    private boolean verified;

    AccountImpl() {
    }

    @Override
    public void initialize(String string, String string2, String string3, String string4) {
        this.emailAddress = string;
        this.firstName = string2;
        this.lastName = string3;
        this.activationKey = string4;
    }

    @Override
    public boolean isLoggedIn() {
        String string = this.securityToken;
        return string != null && string.length() != 0;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public void setFirstName(String string) {
        this.firstName = string;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public void setLastName(String string) {
        this.lastName = string;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String string) {
        this.password = string;
    }

    @Override
    public InstallerEntitlement getSelectedEntitlement() {
        return this.entitlementMap.get(this.selectedEntitlementId);
    }

    @Override
    public void setSelectedEntitlement(String string) {
        this.selectedEntitlementId = string;
    }

    @Override
    public void setSelectedEntitlement(InstallerEntitlement installerEntitlement) {
        this.addEntitlement(installerEntitlement);
        this.selectedEntitlementId = installerEntitlement.getId();
    }

    @Override
    public void addEntitlement(InstallerEntitlement installerEntitlement) {
        String string = installerEntitlement.getId();
        this.entitlementMap.put(string, installerEntitlement);
    }

    @Override
    public String getSecurityToken() {
        return this.securityToken;
    }

    @Override
    public void setSecurityToken(String string) {
        this.securityToken = string;
    }

    @Override
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public void setEmailAddress(String string) {
        this.emailAddress = string;
    }

    @Override
    public List<InstallerEntitlement> getEntitlements() {
        Collection<InstallerEntitlement> collection = this.entitlementMap.values();
        return new ArrayList<InstallerEntitlement>(collection);
    }

    @Override
    public String getActivationKey() {
        String string;
        InstallerEntitlement installerEntitlement = this.entitlementMap.get(this.selectedEntitlementId);
        String string2 = installerEntitlement == null ? this.activationKey : ((string = installerEntitlement.getActivationKey()) == null || "".equalsIgnoreCase(string) ? this.activationKey : string);
        return string2;
    }

    @Override
    public void setActivationKey(String string) {
        InstallerEntitlement installerEntitlement = this.entitlementMap.get(this.selectedEntitlementId);
        if (installerEntitlement == null) {
            this.activationKey = string;
        } else {
            installerEntitlement.setActivationKey(string);
        }
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setUserName(String string) {
        this.userName = string.trim();
    }

    @Override
    public boolean isAdmin(String string) {
        return null != string && this.entitlementMap.containsKey(string) && this.entitlementMap.get(string).isAdmin();
    }

    @Override
    public boolean a2ak(String string) {
        return null != string && this.entitlementMap.containsKey(string) && this.entitlementMap.get(string).isA2AK() || this.isAdmin(string);
    }

    @Override
    public void clearEntitlements() {
        this.entitlementMap = new LinkedHashMap<String, InstallerEntitlement>();
        this.selectedEntitlementId = "";
    }

    @Override
    public String getActivationKeyByEntitlementId(String string) {
        InstallerEntitlement installerEntitlement = this.entitlementMap.get(string);
        if (installerEntitlement == null) {
            return "";
        }
        return installerEntitlement.getActivationKey();
    }

    @Override
    public void setVerified(boolean bl) {
        this.verified = bl;
    }

    @Override
    public boolean isVerified() {
        return this.verified;
    }
}

