/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow.v2;

import com.mathworks.install.InstallOption;
import com.mathworks.install.Installer;
import com.mathworks.install.ValidatedFik;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.v2.AbstractSimpleInstallWorkflow;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.ui.CheckBoxConfiguration;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.io.File;
import java.util.Properties;

final class PostInstallationWorkflow
extends AbstractSimpleInstallWorkflow {
    private final Model<CheckBoxConfiguration> activateCheckBoxConfigurationModel;
    private final String notesText;
    private final InstallWizardProperties activationCommandLineProperties;
    private final Model<CheckBoxConfiguration> deleteCheckBoxConfigurationModel;
    private final File installationFolder;
    private final Model<File> downloadFolderModel;
    private final Model<Boolean> lnuOnly;
    private final int downloadSize;
    private final Properties installerProperties;
    private final UsageDataCollector usageDataCollector;

    PostInstallationWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, Properties properties, File file, Model<File> model, InstallWizardContext installWizardContext, Installer installer, InstallOption[] installOptionArray, ValidatedFik validatedFik, Model<Boolean> model2, Properties properties2, UsageDataCollector usageDataCollector) {
        super(installCommandStepFactory);
        this.installationFolder = file;
        this.downloadFolderModel = model;
        this.lnuOnly = model2;
        this.installerProperties = properties2;
        this.usageDataCollector = usageDataCollector;
        this.downloadSize = Long.valueOf(installer.getDownloadSize(file) / 0x100000L).intValue();
        this.notesText = installWizardContext.buildNotesText(file, installOptionArray, installer);
        this.activateCheckBoxConfigurationModel = installModelFactory.createActivateCheckBoxConfigurationModel(validatedFik, installer, this.lnuOnly);
        this.deleteCheckBoxConfigurationModel = installModelFactory.createDeleteCheckBoxConfigurationModel(this.downloadSize);
        this.activationCommandLineProperties = installModelFactory.createProperties(properties);
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(installCommandStepFactory.createMarkerFileForLNUEntitlementsStep(this.lnuOnly, this.installationFolder, this.installerProperties));
        this.addStep(panelStepBuilder.buildNotesStep(this.notesText));
        this.addStep(panelStepBuilder.buildFinalPanelStep(this.activateCheckBoxConfigurationModel, this.deleteCheckBoxConfigurationModel, this.notesText.length() > 0, this.downloadSize, ((File)this.downloadFolderModel.get()).getAbsolutePath()));
        this.addStep(installCommandStepFactory.createCloseUIStep());
        this.addStep(installCommandStepFactory.createDeleteDWSArchivesStep(this.downloadFolderModel, this.deleteCheckBoxConfigurationModel));
        this.addStep(installCommandStepFactory.createLaunchActivatorStep(this.activateCheckBoxConfigurationModel, this.activationCommandLineProperties.getProperties()));
        this.addStep(installCommandStepFactory.createCollectUdcGpuInfoStep(this.usageDataCollector, this.installationFolder.getAbsolutePath()));
    }
}

