/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow.v2;

import com.mathworks.install.input.DownloadLocationUtility;
import com.mathworks.install.udc.UdcUtil;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.installwizard.InstallWizardPropertyKey;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.v2.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.v2.InstallWorkflowFactory;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.ConnectionMode;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

final class InitialWorkflow
extends AbstractBranchingInstallWorkflow<Object> {
    private final File libDir;
    private final UsageDataCollector usageDataCollector;
    private List<File> archiveDirs;
    private final Model<ConnectionMode> connectionModeModel;
    private static final String ARCHIVES = "archives";

    InitialWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, File file, String string, Properties properties, Properties properties2, UsageDataCollector usageDataCollector) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties2);
        this.libDir = file;
        this.usageDataCollector = usageDataCollector;
        String string2 = new File(string, ARCHIVES).getAbsolutePath();
        String string3 = properties.getProperty(InstallWizardPropertyKey.ARCHIVES.get(), string2);
        File file2 = new File(string3);
        this.archiveDirs = new ArrayList<File>();
        this.archiveDirs.add(file2);
        this.archiveDirs.add(new File(string));
        this.archiveDirs.add(DownloadLocationUtility.getPathForReadingArchives((File)((File)installModelFactory.createDownloadFolderModel().get())));
        this.connectionModeModel = installModelFactory.createConnectionModeModel();
        UdcUtil.collectCpuAndMemoryInfo((UsageDataCollector)usageDataCollector);
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(installCommandStepFactory.createLoadNativeLibrariesStep(this.libDir.getAbsolutePath()));
        this.addStep(installCommandStepFactory.createStartReadingArchivesStep(this.archiveDirs.toArray(new File[this.archiveDirs.size()])));
        this.addStep(panelStepBuilder.buildWelcomeStep(this.connectionModeModel, installCommandStepFactory.createProxyConnectToServicesStep()));
    }

    @Override
    protected Object evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        return this.connectionModeModel.get();
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        if (ConnectionMode.ONLINE.equals(this.connectionModeModel.get())) {
            this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_FIK_USED, (Object)false);
            return installWorkflowFactory.createOnlineWorkflow(properties);
        }
        this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_FIK_USED, (Object)true);
        return installWorkflowFactory.createOfflineWorkflow(properties);
    }
}

