/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow.v2;

import com.mathworks.install.Downloader;
import com.mathworks.install.DownloaderBuilder;
import com.mathworks.install.DownloaderBuilderFactory;
import com.mathworks.install.InstallOption;
import com.mathworks.install.Installer;
import com.mathworks.install.ValidatedFik;
import com.mathworks.install.service.ServiceFactory;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.v2.CreateAccountWorkflow;
import com.mathworks.installwizard.workflow.v2.DWSEnabledHasFikWorkflow;
import com.mathworks.installwizard.workflow.v2.DownloadConfirmationPanelWorkflow;
import com.mathworks.installwizard.workflow.v2.DownloadFolderSelectionWorkflow;
import com.mathworks.installwizard.workflow.v2.DownloadInstallWorkflow;
import com.mathworks.installwizard.workflow.v2.DownloadOnlyWorkflow;
import com.mathworks.installwizard.workflow.v2.DownloadProductSelectionWorkflow;
import com.mathworks.installwizard.workflow.v2.EmailVerificationLoginWorkflow;
import com.mathworks.installwizard.workflow.v2.EmailVerificationWorkflow;
import com.mathworks.installwizard.workflow.v2.EntitlementSelectionWorkflow;
import com.mathworks.installwizard.workflow.v2.FolderSelectionWorkflow;
import com.mathworks.installwizard.workflow.v2.HasActivationKeyWorkflow;
import com.mathworks.installwizard.workflow.v2.HasEntitlementWorkflow;
import com.mathworks.installwizard.workflow.v2.HasExcessEntitlementsWorkflow;
import com.mathworks.installwizard.workflow.v2.HasFikWorkflow;
import com.mathworks.installwizard.workflow.v2.InitialWorkflow;
import com.mathworks.installwizard.workflow.v2.InstallOptionsWorkflow;
import com.mathworks.installwizard.workflow.v2.InstallWorkflowFactory;
import com.mathworks.installwizard.workflow.v2.InstallationWorkflow;
import com.mathworks.installwizard.workflow.v2.LoginPanelWorkflow;
import com.mathworks.installwizard.workflow.v2.LoginWorkflow;
import com.mathworks.installwizard.workflow.v2.NoFikWorkflow;
import com.mathworks.installwizard.workflow.v2.OfflineFikWorkflow;
import com.mathworks.installwizard.workflow.v2.OnlineWorkflow;
import com.mathworks.installwizard.workflow.v2.PostInstallationWorkflow;
import com.mathworks.installwizard.workflow.v2.PreLoggedInOnlineWorkflow;
import com.mathworks.installwizard.workflow.v2.ProductSelectionWorkflow;
import com.mathworks.installwizard.workflow.v2.ProvideActivationKeyWorkflow;
import com.mathworks.installwizard.workflow.v2.ReadArchivesWorkflow;
import com.mathworks.instutil.AvailablePlatform;
import com.mathworks.instutil.licensefiles.LicenseLocationFactory;
import com.mathworks.instutil.system.HostIdProvider;
import com.mathworks.internal.mwaws.client.v6.MWAEntitlement;
import com.mathworks.wizard.PropertyKey;
import com.mathworks.wizard.SourcePathProvider;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.FileSystem;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.PlatformModel;
import java.io.File;
import java.util.Properties;

public abstract class AbstractInstallWorkflowFactory
implements InstallWorkflowFactory {
    private final InstallModelFactory modelFactory;
    private final InstallCommandStepFactory commandStepFactory;
    private final HostIdProvider hostIdProvider;
    private DownloaderBuilderFactory downloaderBuilderFactory;
    private final UsageDataCollector usageDataCollector;
    private final InstallWizardProperties initialActivationProperties;
    private final Properties installerProperties;
    private final ServiceFactory serviceFactory;
    private final LicenseLocationFactory licenseLocationFactory;
    private String rootDir;

    public AbstractInstallWorkflowFactory(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, HostIdProvider hostIdProvider, Properties properties, ServiceFactory serviceFactory, LicenseLocationFactory licenseLocationFactory, SourcePathProvider sourcePathProvider, DownloaderBuilderFactory downloaderBuilderFactory, UsageDataCollector usageDataCollector) {
        this.modelFactory = installModelFactory;
        this.commandStepFactory = installCommandStepFactory;
        this.hostIdProvider = hostIdProvider;
        this.downloaderBuilderFactory = downloaderBuilderFactory;
        this.usageDataCollector = usageDataCollector;
        this.installerProperties = new Properties(properties);
        this.serviceFactory = serviceFactory;
        this.initialActivationProperties = this.modelFactory.createProperties();
        String string = properties.getProperty(PropertyKey.LWS.get());
        this.initialActivationProperties.setLWS(string);
        this.initialActivationProperties.setAWS(properties.getProperty(PropertyKey.AWS.get()));
        this.initialActivationProperties.setPropertiesFile(properties.getProperty(PropertyKey.ACTIVATION_PROPERTIES_FILE.get()));
        this.licenseLocationFactory = licenseLocationFactory;
        this.rootDir = sourcePathProvider.getSourcePath();
    }

    @Override
    public final Workflow createInitialWorkflow(File file) {
        return new InitialWorkflow(this.modelFactory, this.commandStepFactory, this, file, this.rootDir, this.installerProperties, this.initialActivationProperties.getProperties(), this.usageDataCollector);
    }

    @Override
    public final Workflow createNoFikWorkflow() {
        return new NoFikWorkflow(this.hostIdProvider);
    }

    @Override
    public final Workflow createHasFikWorkflow(String string, Properties properties) {
        return new HasFikWorkflow(this.modelFactory, this.commandStepFactory, this, string, properties);
    }

    @Override
    public final Workflow createFolderSelectionWorkflow(Installer installer, Properties properties, ValidatedFik validatedFik, InstallWizardContext installWizardContext, Model<Boolean> model) {
        return new FolderSelectionWorkflow(this.modelFactory, this.commandStepFactory, this, installer, properties, validatedFik, installWizardContext, model);
    }

    @Override
    public final Workflow createInstallationWorkflow(Installer installer, File file, InstallWizardContext installWizardContext, Properties properties, ValidatedFik validatedFik, InstallOption[] installOptionArray, Model<Boolean> model) {
        return new InstallationWorkflow(this.modelFactory, this.commandStepFactory, this, installer, file, installWizardContext, properties, validatedFik, installOptionArray, model);
    }

    @Override
    public final Workflow createInstallOptionsWorkflow(Installer installer, File file, InstallWizardContext installWizardContext, Properties properties, ValidatedFik validatedFik, InstallOption[] installOptionArray, Model<Boolean> model) {
        return new InstallOptionsWorkflow(this.modelFactory, this.commandStepFactory, this, installer, file, installWizardContext, properties, validatedFik, installOptionArray, this.serviceFactory.createLicenseManagerService(), this.licenseLocationFactory, model);
    }

    @Override
    public final Workflow createOnlineWorkflow(Properties properties) {
        if (this.isPreLoggedIn()) {
            return new PreLoggedInOnlineWorkflow(this.modelFactory, this.commandStepFactory, this, properties, AbstractInstallWorkflowFactory.getPreLoggedInToken(this.installerProperties), this.installerProperties.getProperty(PropertyKey.EMAIL.get()));
        }
        return new OnlineWorkflow(this.modelFactory, this.commandStepFactory, this, properties);
    }

    @Override
    public final Workflow createLoginPanelWorkflow(Properties properties) {
        return new LoginPanelWorkflow(this.modelFactory, this.commandStepFactory, this, properties);
    }

    private boolean isPreLoggedIn() {
        return AbstractInstallWorkflowFactory.getPreLoggedInToken(this.installerProperties) != null;
    }

    private static String getPreLoggedInToken(Properties properties) {
        return properties.getProperty(PropertyKey.TOKEN.get());
    }

    @Override
    public final Workflow createLoginWorkflow(String string, String string2, Properties properties) {
        return new LoginWorkflow(this.modelFactory, this.commandStepFactory, this, string, string2, properties, this.usageDataCollector, this.rootDir);
    }

    @Override
    public final Workflow createEntitlementSelectionWorkflow(MWAEntitlement[] mWAEntitlementArray, String string, Properties properties) {
        return new EntitlementSelectionWorkflow(this.modelFactory, this.commandStepFactory, this, mWAEntitlementArray, string, properties);
    }

    @Override
    public final Workflow createOfflineFikWorkflow(String string, Properties properties) {
        return new OfflineFikWorkflow(this.modelFactory, this.commandStepFactory, this, string, properties, this.usageDataCollector);
    }

    @Override
    public final Workflow createHasActivationKeyWorkflow(String string, String string2, Properties properties) {
        return new HasActivationKeyWorkflow(this.modelFactory, this.commandStepFactory, this, string, string2, properties, this.usageDataCollector);
    }

    @Override
    public final Workflow createCreateAccountWorkflow(Properties properties) {
        return new CreateAccountWorkflow(this.modelFactory, this.commandStepFactory, this, properties);
    }

    @Override
    public final Workflow createHasEntitlementWorkflow(MWAEntitlement mWAEntitlement, String string, Properties properties) {
        return new HasEntitlementWorkflow(this.modelFactory, this.commandStepFactory, this, mWAEntitlement, string, properties, this.usageDataCollector);
    }

    @Override
    public final Workflow createProvideActivationKeyWorkflow(String string, Properties properties) {
        return new ProvideActivationKeyWorkflow(this.modelFactory, this.commandStepFactory, this, string, properties);
    }

    @Override
    public Workflow createHasExcessEntitlementsWorkflow(String string, Properties properties, Model<String> model) {
        return new HasExcessEntitlementsWorkflow(this.modelFactory, this.commandStepFactory, this, string, properties, model);
    }

    @Override
    public final Workflow createDWSEnabledHasFikWorkflow(String string, String string2, String string3, Properties properties, Model<MWAEntitlement> model) {
        InstallWizardContext installWizardContext = this.modelFactory.createContext(string3);
        if (string2 == null || "".equalsIgnoreCase(string2) || this.isPreLoggedIn()) {
            return new HasFikWorkflow(this.modelFactory, this.commandStepFactory, this, string, installWizardContext, properties);
        }
        return new DWSEnabledHasFikWorkflow(this.modelFactory, this.commandStepFactory, this, string, string2, installWizardContext, properties, model, this.rootDir);
    }

    @Override
    public final Workflow createProductSelectionWorkflow(Properties properties, Installer installer, ValidatedFik validatedFik, InstallWizardContext installWizardContext, DefaultedModel<String> defaultedModel, FileSystem fileSystem, Model<Boolean> model) {
        return new ProductSelectionWorkflow(this.modelFactory, this.commandStepFactory, this, properties, installer, validatedFik, installWizardContext, defaultedModel, fileSystem, model, this.usageDataCollector);
    }

    @Override
    public Workflow createEmailVerificationLoginWorkflow(Properties properties, Model<String> model, Model<String> model2, Model<String> model3) {
        return new EmailVerificationLoginWorkflow(this.modelFactory, this.commandStepFactory, this, model, model2, model3, properties);
    }

    @Override
    public Workflow createEmailVerificationWorkflow(Properties properties, Model<String> model, Model<String> model2, Model<String> model3) {
        return new EmailVerificationWorkflow(this.modelFactory, this.commandStepFactory, this, model, model2, model3, properties);
    }

    @Override
    public Workflow createPostInstallationWorkflow(Properties properties, File file, Model<File> model, InstallWizardContext installWizardContext, ValidatedFik validatedFik, Installer installer, InstallOption[] installOptionArray, Model<Boolean> model2) {
        return new PostInstallationWorkflow(this.modelFactory, this.commandStepFactory, properties, file, model, installWizardContext, installer, installOptionArray, validatedFik, model2, this.installerProperties, this.usageDataCollector);
    }

    @Override
    public Workflow createDownloadInstallWorkflow(Properties properties, Model<Boolean> model, Model<MWAEntitlement[]> model2, Model<String> model3, Model<String> model4) {
        return new DownloadInstallWorkflow(this.modelFactory, this.commandStepFactory, this, properties, model, model2, model3, this.usageDataCollector, model4);
    }

    @Override
    public Workflow createDownloadOnlyWorkflow(String string, Properties properties, InstallWizardContext installWizardContext, DefaultedModel<File> defaultedModel, Model<DownloaderBuilder> model, PlatformModel<AvailablePlatform> platformModel) {
        return new DownloadOnlyWorkflow(this.modelFactory, this.commandStepFactory, this, properties, string, installWizardContext, defaultedModel, model, platformModel);
    }

    @Override
    public Workflow createDownloadFolderSelectionWorkflow(String string, Properties properties) {
        InstallWizardContext installWizardContext = this.modelFactory.createContext();
        return new DownloadFolderSelectionWorkflow(this.modelFactory, this.commandStepFactory, this, properties, installWizardContext, string);
    }

    @Override
    public Workflow createDownloadProductSelectionWorkflow(Downloader downloader, InstallWizardContext installWizardContext, DefaultedModel<File> defaultedModel, Properties properties, PlatformModel<AvailablePlatform> platformModel) {
        return new DownloadProductSelectionWorkflow(this.modelFactory, this.commandStepFactory, downloader, defaultedModel, installWizardContext, properties, this, platformModel, this.usageDataCollector);
    }

    @Override
    public Workflow createDownloadConfirmationPanelWorkflow(Downloader downloader, InstallWizardContext installWizardContext, DefaultedModel<File> defaultedModel, FileSystem fileSystem, PlatformModel<AvailablePlatform> platformModel) {
        return new DownloadConfirmationPanelWorkflow(this.modelFactory, this.commandStepFactory, downloader, installWizardContext, defaultedModel, fileSystem, platformModel, this.usageDataCollector);
    }

    @Override
    public Workflow createReadArchivesWorkflow(String string, Properties properties, InstallWizardContext installWizardContext, DefaultedModel<File> defaultedModel, PlatformModel<AvailablePlatform> platformModel, Model<String[]> model) {
        return new ReadArchivesWorkflow(this.modelFactory, this.commandStepFactory, string, properties, installWizardContext, defaultedModel, platformModel, this, this.downloaderBuilderFactory, model);
    }
}

