/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow;

import com.mathworks.install.InstallOption;
import com.mathworks.install.InstallOptionType;
import com.mathworks.install.Installer;
import com.mathworks.install.Product;
import com.mathworks.install.SoftwareManager;
import com.mathworks.install.ValidatedFik;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.InstallWorkflowFactory;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.Registry;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.FileSystem;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.io.File;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

final class TypicalWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final Installer install;
    private final ValidatedFik validatedFik;
    private final DefaultedModel<String> folderModel;
    private final DefaultedModel<String> displayedFolderModel;
    private final FileSystem fileSystem;
    private final InstallWizardContext context;
    private final Model<String> licenseFilePathModel;
    private final Model<String> licenseFileContentsModel = new ModelImpl();
    private Platform platform;
    private Registry registry;
    private DefaultedModel<File> downloadFolderModel;

    TypicalWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, Installer installer, Properties properties, ValidatedFik validatedFik, InstallWizardContext installWizardContext, Platform platform, Registry registry) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.platform = platform;
        this.registry = registry;
        this.install = installer;
        this.folderModel = installModelFactory.createInstallFolderModel((Product[])this.install.getAvailableProducts());
        this.displayedFolderModel = installModelFactory.createDisplayedFolderModel(this.folderModel, (Product[])this.install.getAvailableProducts());
        this.fileSystem = installModelFactory.createFileSystem((SoftwareManager)installer, this.folderModel);
        installModelFactory.updateProductModelByBaseCodes((SoftwareManager)installer);
        this.downloadFolderModel = new DefaultedModel<File>(){

            public File getDefault() {
                return null;
            }

            public File get() {
                return FileUtils.getFile((String[])new String[]{(String)TypicalWorkflow.this.folderModel.get(), "archives"});
            }

            public void set(File file) {
            }
        };
        this.context = installWizardContext;
        this.licenseFilePathModel = installModelFactory.createLicenseFileModel();
        this.validatedFik = validatedFik;
    }

    static Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Installer installer, File file, ValidatedFik validatedFik, InstallWizardContext installWizardContext, Properties properties, InstallOption[] installOptionArray) {
        return installWorkflowFactory.createInstallationWorkflow(installer, file, installWizardContext, properties, validatedFik, installOptionArray, (Model<Boolean>)new ModelImpl((Object)false));
    }

    @Override
    protected final void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(installCommandStepFactory.createCheckIfNoProductsStep(new ModelImpl((Object)this.install)));
        if (this.context.getInstallConfiguration().canChangeFolder(this.platform, this.registry, this.install)) {
            this.addStep(panelStepBuilder.buildFolderSelectionStep(this.displayedFolderModel));
        } else {
            this.addStep(installCommandStepFactory.createCheckForFolderConflictStep(this.folderModel));
        }
        this.addStep(installCommandStepFactory.createCheckPathForNonEnglishCharactersStep(this.folderModel));
        this.addStep(installCommandStepFactory.createCheckPathForInvalidCharactersStep(this.displayedFolderModel));
        this.addStep(installCommandStepFactory.createVerifyRootDirectoryStep(this.folderModel));
        this.addStep(installCommandStepFactory.createCreateFolderIfItDoesNotAlreadyExistStep(this.folderModel));
        this.addStep(installCommandStepFactory.createCheckWritePermissionsStep(this.folderModel));
        this.addStep(installCommandStepFactory.createCheckIfOverwriteImpossibleStep(this.folderModel, this.install));
        this.addStep(installCommandStepFactory.createAddDWSArchivesInDestinationStep(this.downloadFolderModel, this.install, this.validatedFik));
        this.addStep(installCommandStepFactory.createWarnIfNotEnoughAvailableSpaceStep(this.fileSystem));
        if (this.context.getInstallConfiguration().canChangeFolder(this.platform, this.registry, this.install)) {
            if (this.isMCR()) {
                this.addStep(installCommandStepFactory.createCheckOverwritesForMCRStep(this.folderModel, this.install));
            } else {
                this.addStep(installCommandStepFactory.createCheckOverwritesStep(this.folderModel, this.install));
            }
        }
        this.addStep(installCommandStepFactory.createCheckControllingProductsStep(this.install, this.folderModel));
        if (this.validatedFik.requiresLicenseFile()) {
            this.addStep(panelStepBuilder.buildLicenseFilePanelStep(this.licenseFilePathModel));
            this.addStep(installCommandStepFactory.createValidateLicenseFileStep(this.licenseFilePathModel, this.licenseFileContentsModel));
        }
    }

    @Override
    protected final String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        installWizardProperties.setRoot((String)this.folderModel.get());
        return this.getText();
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        InstallOption[] installOptionArray;
        for (InstallOption installOption : installOptionArray = this.install.getInstallOptionsForCurrentProductSelection(new Product[0])) {
            if (!InstallOptionType.CLIENT_LICENSE_FILE.equals((Object)installOption.getType()) && !InstallOptionType.SERVER_LICENSE_FILE.equals((Object)installOption.getType()) && !InstallOptionType.SERVER_AND_CLIENT_LICENSE_FILE.equals((Object)installOption.getType())) continue;
            installOption.setContext((String)this.licenseFileContentsModel.get());
        }
        return TypicalWorkflow.createNewBranch(installWorkflowFactory, this.install, new File((String)this.folderModel.get()), this.validatedFik, this.context, properties, installOptionArray);
    }

    private String getText() {
        StringBuilder stringBuilder = new StringBuilder(this.context.buildConfirmationText(new File((String)this.folderModel.get()), this.install));
        stringBuilder.append((String)this.licenseFileContentsModel.get());
        return stringBuilder.toString();
    }

    private boolean isMCR() {
        boolean bl = this.context.getInstallConfiguration().getUsageId(this.platform.getArchString(), (Product[])this.install.getAvailableProducts()).equals("mcr");
        return bl;
    }
}

