/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow;

import com.mathworks.install.AvailableProduct;
import com.mathworks.install.InstallOption;
import com.mathworks.install.InstallOptionType;
import com.mathworks.install.Installer;
import com.mathworks.install.Product;
import com.mathworks.install.SoftwareManager;
import com.mathworks.install.ValidatedFik;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.InstallWorkflowFactory;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.FileSystem;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.model.ProductModel;
import com.mathworks.wizard.model.ProductTableFormat;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.io.File;
import java.util.Properties;

final class ProductSelectionWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final ProductModel<AvailableProduct> productModel;
    private final ProductTableFormat<AvailableProduct> productTableFormat;
    private final FileSystem fileSystem;
    private final Installer install;
    private final ValidatedFik validatedFik;
    private final Model<String> licenseFilePathModel;
    private final Model<String> licenseFileContentsModel = new ModelImpl();
    private InstallWizardContext installWizardContext;
    private final DefaultedModel<String> folderModel;

    ProductSelectionWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, Properties properties, Installer installer, ValidatedFik validatedFik, InstallWizardContext installWizardContext, DefaultedModel<String> defaultedModel, FileSystem fileSystem) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.installWizardContext = installWizardContext;
        this.folderModel = defaultedModel;
        this.fileSystem = fileSystem;
        this.productModel = installModelFactory.createProductModel((SoftwareManager)installer);
        this.productTableFormat = installModelFactory.createProductTableFormat(this.productModel);
        this.install = installer;
        this.validatedFik = validatedFik;
        this.licenseFilePathModel = installModelFactory.createLicenseFileModel();
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(panelStepBuilder.buildProductSelectionStep(this.productModel, this.productTableFormat));
        this.addStep(installCommandStepFactory.createWarnIfNotEnoughAvailableSpaceStep(this.fileSystem));
        this.addStep(installCommandStepFactory.createCheckOverwritesStep(this.folderModel, this.install));
        this.addStep(installCommandStepFactory.createCheckControllingProductsStep(this.install, this.folderModel));
        this.addStep(installCommandStepFactory.createCheckProductDependenciesStep((SoftwareManager)this.install, this.folderModel));
        if (this.validatedFik.requiresLicenseFile()) {
            this.addStep(panelStepBuilder.buildLicenseFilePanelStep(this.licenseFilePathModel));
            this.addStep(installCommandStepFactory.createValidateLicenseFileStep(this.licenseFilePathModel, this.licenseFileContentsModel));
        }
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        StringBuilder stringBuilder = new StringBuilder(this.installWizardContext.buildConfirmationText(new File((String)this.folderModel.get()), this.install));
        stringBuilder.append((String)this.licenseFileContentsModel.get());
        return stringBuilder.toString();
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        InstallOption[] installOptionArray;
        for (InstallOption installOption : installOptionArray = this.install.getInstallOptionsForCurrentProductSelection(new Product[0])) {
            if (!InstallOptionType.CLIENT_LICENSE_FILE.equals((Object)installOption.getType()) && !InstallOptionType.SERVER_LICENSE_FILE.equals((Object)installOption.getType()) && !InstallOptionType.SERVER_AND_CLIENT_LICENSE_FILE.equals((Object)installOption.getType())) continue;
            installOption.setContext((String)this.licenseFileContentsModel.get());
        }
        return installWorkflowFactory.createCustomOptionsWorkflow(this.install, new File((String)this.folderModel.get()), this.installWizardContext, properties, this.validatedFik, installOptionArray);
    }
}

