/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow;

import com.mathworks.install.InstallOption;
import com.mathworks.install.Installer;
import com.mathworks.install.ValidatedFik;
import com.mathworks.install.service.Service;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallOptionModelAdapter;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.InstallWorkflowFactory;
import com.mathworks.instutil.licensefiles.LicenseLocationFactory;
import com.mathworks.wizard.Step;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.InstallOptionModel;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import com.mathworks.wizard.workflow.Condition;
import java.io.File;
import java.util.Properties;

final class CustomOptionsWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final Installer installer;
    private final File installationFolder;
    private final InstallWizardContext installWizardContext;
    private final ValidatedFik validatedFik;
    private final InstallOption[] installOptions;
    private InstallOptionModel desktopOption;
    private InstallOptionModel startMenuOption;
    private boolean installingLicenseService;
    private InstallOptionModel licenseServiceOption;
    private final Service licenseManagerService;
    private InstallOptionModel symbolicLinkOption;
    private LicenseLocationFactory licenseLocationFactory;
    private DefaultedModel<String> symbolicLinkModel;

    CustomOptionsWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, Installer installer, File file, InstallWizardContext installWizardContext, Properties properties, ValidatedFik validatedFik, InstallOption[] installOptionArray, Service service, LicenseLocationFactory licenseLocationFactory) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.installer = installer;
        this.installationFolder = file;
        this.installWizardContext = installWizardContext;
        this.validatedFik = validatedFik;
        this.installOptions = (InstallOption[])installOptionArray.clone();
        this.licenseManagerService = service;
        this.licenseLocationFactory = licenseLocationFactory;
        block6: for (InstallOption installOption : this.installOptions) {
            switch (installOption.getType()) {
                case DESKTOP_SHORTCUT: {
                    this.desktopOption = installModelFactory.createDesktopOptionModel(installOption);
                    continue block6;
                }
                case START_MENU_SHORTCUT: {
                    this.startMenuOption = installModelFactory.createStartMenuOptionModel(installOption);
                    continue block6;
                }
                case LICENSE_SERVICE: {
                    this.installingLicenseService = true;
                    this.licenseServiceOption = installModelFactory.createLicenseServiceModel(installOption);
                    continue block6;
                }
                case SYMBOLIC_LINK: {
                    this.symbolicLinkOption = installModelFactory.createSymbolicLinkOptionModel(installOption);
                    this.symbolicLinkModel = new InstallOptionModelAdapter(this.symbolicLinkOption);
                    continue block6;
                }
            }
        }
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        if (this.installingLicenseService) {
            String string = this.licenseLocationFactory.getNetworkServerLicenseLocation(this.installationFolder.getAbsolutePath()).getLicenseLocation();
            this.addStep(panelStepBuilder.buildLicenseServicePanelStep(this.licenseServiceOption, this.licenseManagerService.getDisplayName(), this.licenseManagerService.getLocation(this.installationFolder), new File(string)));
            this.addStep(installCommandStepFactory.createValidateLicenseServerSelectionStep(this.licenseServiceOption, this.licenseManagerService, this.installationFolder));
        }
        this.addStep(panelStepBuilder.buildInstallationOptionsStep(this.desktopOption, this.startMenuOption));
        this.addStep(panelStepBuilder.buildSymlinkOnlyInstallationOptionsStep(this.symbolicLinkOption));
        this.addSymbolicLinkStep(installCommandStepFactory.createCheckPathForNonEnglishCharactersStep(this.symbolicLinkModel));
        this.addSymbolicLinkStep(installCommandStepFactory.createCheckPathForInvalidCharactersStep(this.symbolicLinkModel));
        this.addSymbolicLinkStep(installCommandStepFactory.createVerifyRootDirectoryStep(this.symbolicLinkModel));
        this.addSymbolicLinkStep(installCommandStepFactory.createCheckPathForExistenceStep(this.symbolicLinkModel));
        this.addSymbolicLinkStep(installCommandStepFactory.createCreateFolderIfItDoesNotAlreadyExistStep(this.symbolicLinkModel));
        this.addSymbolicLinkStep(installCommandStepFactory.createCheckSymbolicLinkCreationPermissionsStep(this.symbolicLinkModel));
    }

    private void addSymbolicLinkStep(Step step) {
        this.addConditionalSteps(new Condition(){

            public boolean isSatisfied() {
                return CustomOptionsWorkflow.this.symbolicLinkModel != null && CustomOptionsWorkflow.this.symbolicLinkOption.isSelected();
            }
        }, new Step[]{step});
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        StringBuilder stringBuilder = new StringBuilder();
        for (InstallOption installOption : this.installOptions) {
            stringBuilder.append(installOption.getContext()).append(installOption.isSelected());
        }
        return stringBuilder.toString();
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        return installWorkflowFactory.createInstallationWorkflow(this.installer, this.installationFolder, this.installWizardContext, properties, this.validatedFik, this.installOptions, (Model<Boolean>)new ModelImpl((Object)false));
    }
}

