/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow;

import com.mathworks.install.Installer;
import com.mathworks.install.ValidatedFik;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.InstallWorkflowFactory;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.util.Properties;

final class BuildInstallerWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final Model<ValidatedFik> validatedFik;
    private final Model<Boolean> customSwitch;
    private final Model<Installer> installerModel = new ModelImpl();
    private final String labelText;
    private final InstallWizardContext context;

    BuildInstallerWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, Properties properties, Model<ValidatedFik> model, String string, InstallWizardContext installWizardContext) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.labelText = string;
        this.context = installWizardContext;
        this.customSwitch = installModelFactory.createCustomSwitch();
        this.validatedFik = model;
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        if (this.context.getInstallConfiguration().canChooseTypicalOrCustom()) {
            this.addStep(panelStepBuilder.buildTypicalCustomStep(this.customSwitch, this.labelText));
        }
        this.addStep(installCommandStepFactory.createFinishReadingArchivesStep());
        this.addStep(installCommandStepFactory.createBuildInstallerStep(this.validatedFik, this.installerModel));
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        return ((ValidatedFik)this.validatedFik.get()).get().concat(Boolean.toString((Boolean)this.customSwitch.get()));
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        if (((Boolean)this.customSwitch.get()).booleanValue()) {
            return installWorkflowFactory.createCustomWorkflow((Installer)this.installerModel.get(), properties, (ValidatedFik)this.validatedFik.get(), this.context);
        }
        return installWorkflowFactory.createTypicalWorkflow((Installer)this.installerModel.get(), properties, (ValidatedFik)this.validatedFik.get(), this.context);
    }
}

