/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow;

import com.mathworks.install.InstallOption;
import com.mathworks.install.Installer;
import com.mathworks.install.ValidatedFik;
import com.mathworks.install.service.ServiceFactory;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.BuildInstallerWorkflow;
import com.mathworks.installwizard.workflow.CreateAccountWorkflow;
import com.mathworks.installwizard.workflow.CustomOptionsWorkflow;
import com.mathworks.installwizard.workflow.CustomWorkflow;
import com.mathworks.installwizard.workflow.DWSEnabledHasFikWorkflow;
import com.mathworks.installwizard.workflow.EmailVerificationLoginWorkflow;
import com.mathworks.installwizard.workflow.EmailVerificationWorkflow;
import com.mathworks.installwizard.workflow.EntitlementSelectionWorkflow;
import com.mathworks.installwizard.workflow.HasActivationKeyWorkflow;
import com.mathworks.installwizard.workflow.HasEntitlementWorkflow;
import com.mathworks.installwizard.workflow.HasFikWorkflow;
import com.mathworks.installwizard.workflow.InitialWorkflow;
import com.mathworks.installwizard.workflow.InstallWorkflowFactory;
import com.mathworks.installwizard.workflow.InstallationWorkflow;
import com.mathworks.installwizard.workflow.LoginPanelWorkflow;
import com.mathworks.installwizard.workflow.LoginWorkflow;
import com.mathworks.installwizard.workflow.NoFikWorkflow;
import com.mathworks.installwizard.workflow.OfflineActivationKeyWorkflow;
import com.mathworks.installwizard.workflow.OfflineFikWorkflow;
import com.mathworks.installwizard.workflow.OnlineWorkflow;
import com.mathworks.installwizard.workflow.PostInstallationWorkflow;
import com.mathworks.installwizard.workflow.PreLoggedInOnlineWorkflow;
import com.mathworks.installwizard.workflow.ProductSelectionWorkflow;
import com.mathworks.installwizard.workflow.ProvideActivationKeyWorkflow;
import com.mathworks.installwizard.workflow.TypicalWorkflow;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.Registry;
import com.mathworks.instutil.licensefiles.LicenseLocationFactory;
import com.mathworks.instutil.system.HostIdProvider;
import com.mathworks.internal.mwaws.client.v6.MWAEntitlement;
import com.mathworks.wizard.PropertyKey;
import com.mathworks.wizard.SourcePathProvider;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.FileSystem;
import com.mathworks.wizard.model.Model;
import java.io.File;
import java.util.Properties;

public abstract class AbstractInstallWorkflowFactory
implements InstallWorkflowFactory {
    private final InstallModelFactory modelFactory;
    private final InstallCommandStepFactory commandStepFactory;
    private final HostIdProvider hostIdProvider;
    private final InstallWizardProperties initialActivationProperties;
    private final Properties installerProperties;
    private final ServiceFactory serviceFactory;
    private final LicenseLocationFactory licenseLocationFactory;
    private final Platform platform;
    private final Registry registry;
    private String rootDir;

    public AbstractInstallWorkflowFactory(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, HostIdProvider hostIdProvider, Properties properties, ServiceFactory serviceFactory, LicenseLocationFactory licenseLocationFactory, Platform platform, Registry registry, SourcePathProvider sourcePathProvider) {
        this.modelFactory = installModelFactory;
        this.commandStepFactory = installCommandStepFactory;
        this.hostIdProvider = hostIdProvider;
        this.platform = platform;
        this.registry = registry;
        this.installerProperties = new Properties(properties);
        this.serviceFactory = serviceFactory;
        this.initialActivationProperties = this.modelFactory.createProperties();
        String string = properties.getProperty(PropertyKey.LWS.get());
        this.initialActivationProperties.setLWS(string);
        this.initialActivationProperties.setAWS(properties.getProperty(PropertyKey.AWS.get()));
        this.initialActivationProperties.setPropertiesFile(properties.getProperty(PropertyKey.ACTIVATION_PROPERTIES_FILE.get()));
        this.licenseLocationFactory = licenseLocationFactory;
        this.rootDir = sourcePathProvider.getSourcePath();
    }

    @Override
    public final Workflow createInitialWorkflow(File file) {
        return new InitialWorkflow(this.modelFactory, this.commandStepFactory, this, file, this.rootDir, this.installerProperties, this.initialActivationProperties.getProperties());
    }

    @Override
    public final Workflow createNoFikWorkflow() {
        return new NoFikWorkflow(this.hostIdProvider);
    }

    @Override
    public final Workflow createHasFikWorkflow(String string, Properties properties) {
        return new HasFikWorkflow(this.modelFactory, this.commandStepFactory, this, string, properties);
    }

    @Override
    public final Workflow createTypicalWorkflow(Installer installer, Properties properties, ValidatedFik validatedFik, InstallWizardContext installWizardContext) {
        return new TypicalWorkflow(this.modelFactory, this.commandStepFactory, this, installer, properties, validatedFik, installWizardContext, this.platform, this.registry);
    }

    @Override
    public final Workflow createCustomWorkflow(Installer installer, Properties properties, ValidatedFik validatedFik, InstallWizardContext installWizardContext) {
        return new CustomWorkflow(this.modelFactory, this.commandStepFactory, this, installer, properties, validatedFik, installWizardContext);
    }

    @Override
    public final Workflow createInstallationWorkflow(Installer installer, File file, InstallWizardContext installWizardContext, Properties properties, ValidatedFik validatedFik, InstallOption[] installOptionArray, Model<Boolean> model) {
        return new InstallationWorkflow(this.modelFactory, this.commandStepFactory, this, installer, file, installWizardContext, properties, validatedFik, installOptionArray);
    }

    @Override
    public final Workflow createCustomOptionsWorkflow(Installer installer, File file, InstallWizardContext installWizardContext, Properties properties, ValidatedFik validatedFik, InstallOption[] installOptionArray) {
        return new CustomOptionsWorkflow(this.modelFactory, this.commandStepFactory, this, installer, file, installWizardContext, properties, validatedFik, installOptionArray, this.serviceFactory.createLicenseManagerService(), this.licenseLocationFactory);
    }

    @Override
    public final Workflow createOnlineWorkflow(Properties properties) {
        if (this.isPreLoggedIn()) {
            return new PreLoggedInOnlineWorkflow(this.modelFactory, this.commandStepFactory, this, properties, AbstractInstallWorkflowFactory.getPreLoggedInToken(this.installerProperties), this.installerProperties.getProperty(PropertyKey.EMAIL.get()));
        }
        return new OnlineWorkflow(this.modelFactory, this.commandStepFactory, this, properties);
    }

    @Override
    public final Workflow createLoginPanelWorkflow(Properties properties) {
        return new LoginPanelWorkflow(this.modelFactory, this.commandStepFactory, this, properties);
    }

    private boolean isPreLoggedIn() {
        return AbstractInstallWorkflowFactory.getPreLoggedInToken(this.installerProperties) != null;
    }

    private static String getPreLoggedInToken(Properties properties) {
        return properties.getProperty(PropertyKey.TOKEN.get());
    }

    @Override
    public final Workflow createLoginWorkflow(String string, String string2, Properties properties) {
        return new LoginWorkflow(this.modelFactory, this.commandStepFactory, this, string, string2, properties);
    }

    @Override
    public final Workflow createEntitlementSelectionWorkflow(MWAEntitlement[] mWAEntitlementArray, String string, Properties properties) {
        return new EntitlementSelectionWorkflow(this.modelFactory, this.commandStepFactory, this, mWAEntitlementArray, string, properties);
    }

    @Override
    public final Workflow createOfflineFikWorkflow(String string, Properties properties) {
        return new OfflineFikWorkflow(this.modelFactory, this.commandStepFactory, this, string, properties);
    }

    @Override
    public final Workflow createOfflineActivationKeyWorkflow() {
        return new OfflineActivationKeyWorkflow(this.commandStepFactory);
    }

    @Override
    public final Workflow createHasActivationKeyWorkflow(String string, String string2, Properties properties) {
        return new HasActivationKeyWorkflow(this.modelFactory, this.commandStepFactory, this, string, string2, properties);
    }

    @Override
    public final Workflow createCreateAccountWorkflow(Properties properties) {
        return new CreateAccountWorkflow(this.modelFactory, this.commandStepFactory, this, properties);
    }

    @Override
    public final Workflow createHasEntitlementWorkflow(MWAEntitlement mWAEntitlement, String string, Properties properties) {
        return new HasEntitlementWorkflow(this.modelFactory, this.commandStepFactory, this, mWAEntitlement, string, properties);
    }

    @Override
    public final Workflow createProvideActivationKeyWorkflow(String string, Properties properties) {
        return new ProvideActivationKeyWorkflow(this.modelFactory, this.commandStepFactory, this, string, properties);
    }

    @Override
    public final Workflow createDWSEnabledHasFikWorkflow(String string, String string2, String string3, Properties properties, Model<MWAEntitlement> model) {
        InstallWizardContext installWizardContext = this.modelFactory.createContext(string3);
        if (string2 == null || "".equalsIgnoreCase(string2) || this.isPreLoggedIn()) {
            return new HasFikWorkflow(this.modelFactory, this.commandStepFactory, this, string, installWizardContext, properties);
        }
        return new DWSEnabledHasFikWorkflow(this.modelFactory, this.commandStepFactory, this, string, string2, installWizardContext, properties, model, this.rootDir);
    }

    @Override
    public final Workflow createBuildInstallerWorkflow(Properties properties, Model<ValidatedFik> model, String string, InstallWizardContext installWizardContext) {
        return new BuildInstallerWorkflow(this.modelFactory, this.commandStepFactory, this, properties, model, string, installWizardContext);
    }

    @Override
    public final Workflow createProductSelectionWorkflow(Properties properties, Installer installer, ValidatedFik validatedFik, InstallWizardContext installWizardContext, DefaultedModel<String> defaultedModel, FileSystem fileSystem, Model<Boolean> model) {
        return new ProductSelectionWorkflow(this.modelFactory, this.commandStepFactory, this, properties, installer, validatedFik, installWizardContext, defaultedModel, fileSystem);
    }

    @Override
    public Workflow createEmailVerificationLoginWorkflow(Properties properties, Model<String> model, Model<String> model2, Model<String> model3) {
        return new EmailVerificationLoginWorkflow(this.modelFactory, this.commandStepFactory, this, model, model2, model3, properties);
    }

    @Override
    public Workflow createEmailVerificationWorkflow(Properties properties, Model<String> model, Model<String> model2, Model<String> model3) {
        return new EmailVerificationWorkflow(this.modelFactory, this.commandStepFactory, this, model, model2, model3, properties);
    }

    @Override
    public Workflow createPostInstallationWorkflow(Properties properties, File file, Model<File> model, InstallWizardContext installWizardContext, ValidatedFik validatedFik, Installer installer, InstallOption[] installOptionArray, Model<Boolean> model2) {
        return new PostInstallationWorkflow(this.modelFactory, this.commandStepFactory, properties, file, model, installWizardContext, installer, installOptionArray, validatedFik);
    }
}

