/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.resources;

import com.mathworks.instutil.Arch;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.wizard.ResourceRetrieverImpl;
import java.util.EnumMap;
import java.util.Map;

public enum ResourceKeys {
    ALREADY_DOWNLOADED("already.downloaded"),
    CONFIRM_LICNUM("confirm.licnum"),
    FOLDER_FAILED("folder.failed"),
    FOLDER_CANNOT_WRITE("folder.access"),
    EXTRACT_CORRUPTLIST("extract.corruptlist"),
    EXTRACT_TITLE("extract.title"),
    TITLE_INSTALLSPACE("installspace.title"),
    DIRECTORY_TITLE("directory.title"),
    FOLDER_ERROR("folder.error"),
    DIRECTORY_INVALID_DRIVE("directory.invalid.absolutepath"),
    FOLDER_NON_ENGLISH("folder.nonenglish"),
    FOLDER_INVALID_PATH_CHARS_WINDOWS("folder.invalid.windows"),
    FOLDER_CREATE_LABEL("folder.create"),
    FIK_ERROR_TITLE("plperroralert.title"),
    FIK_ERROR_PLP("plperroralert.plp"),
    FIK_ERROR_INVALID("plperroralert.incorrect"),
    FIK_ERROR_VERSION("plperroralert.release"),
    ERROR_NATIVE_LIBRARY_TITLE("installalert.title"),
    ERROR_NATIVE_LIBRARY_MESSAGE("installalert.mwinstall"),
    LABEL_INSTALL("label.install"),
    DEPENDENCIES_TITLE("deps.error.title"),
    DEPENDENCIES_MESSAGE("deps.error.text"),
    DEPENDENCIES_MESSAGE_UNINSTALL("deps.error.uninstall.text"),
    DEPENDENCIES_UNAVAILABLE("deps.error.productnotavail"),
    INSTALLALERT_TITLE("installalert.error"),
    CONTROLLING_PRODUCTS_MESSAGE("controllingproduct.error.text"),
    UNINSTALLER_CONTROLLING_PRODUCTS_MESSAGE("controllingproduct.error.uninstall.text"),
    PRODUCT_HEADER("product.header"),
    NOTES_HEADER("notes.header"),
    CONFIRM_DOWNLOAD_PLATFORMS("confirm.download.platforms"),
    CONFIRM_TOTAL_DOWNLOAD_SIZE("confirm.download.total"),
    CONFIRM_TOTAL_INSTALLATION_SIZE("confirm.installation.total"),
    CONFIRM_DOWNLOAD("confirm.download"),
    OPTION_INSTALLSPACE("installspace.option"),
    LABEL_UNINSTALL("label.uninstall"),
    LABEL_MCR_UNINSTALL("label.mcr.uninstall"),
    CLIENT_STRING("client.string"),
    TRIALSINSTALLER_CLIENT_STRING("trialsinstaller.client.string"),
    SUPPORTSOFTWAREINSTALLER_CLIENT_STRING("supportsoftwareinstaller.client.string"),
    ENTITLEMENT_TABLE_HEADER_LICENSE("licsel.column0"),
    ACTIVATION_KEY_PROVIDED_TITLE("activationkey.provided.title"),
    ACTIVATION_KEY_PROVIDED("online.valid.activationkey.message"),
    OFFLINE_ACTIVATION_KEY_PROVIDED("offline.valid.activationkey.message"),
    ENTITLEMENT_TABLE_HEADER_LABEL("licsel.column1"),
    ENTITLEMENT_TABLE_HEADER_OPTION("licsel.column2"),
    ERROR_CONNECTION_MESSAGE("error.connection"),
    ERROR_CONNECTION_TITLE("error.connect.title"),
    ERROR_SERVICE_TITLE("error.service.title"),
    ERROR("error"),
    ERROR_UNKNOWN("error.unknown"),
    ENTITLEMENT_TABLE_LICENSE_OPTION("licenseoption"),
    DWS_QUESTION_TITLE("dws.question.title"),
    DWS_QUESTION_MESSAGE("dws.question"),
    SERVICE_DWS_CHECK_MESSAGE("dws.check"),
    SERVICE_DWS_UDPATE_MESSAGE("dws.verify"),
    SERVICE_PREPARING_INSTALLATION_MESSAGE("preparing.installation"),
    ERROR_TITLE_LICENSEFILE_FORMAT("licensefile.format.title"),
    ERROR_LICENSEFILE_FORMAT("licensefile.format.message"),
    ERROR_LICENSEFILE_BADLINE("licensefile.badline"),
    ERROR_HOSTID("hostid.mismatch"),
    ERROR_HOSTID_TITLE("hostid.title"),
    WARNING_HOSTID_MISSING("hostid.missing"),
    USERNAME_UNRECOGNIZED_TITLE("username.unrecognized.title"),
    USERNAME_UNRECOGNIZED_MESSAGE("username.unrecognized.message"),
    USERNAME_NOT_PERMITTED_TITLE("username.notpermitted.title"),
    USERNAME_NOT_PERMITTED_MESSAGE("username.notpermitted.message"),
    LICENSE_SERVICE_ERROR_TITLE("serviceerroralert.title"),
    ERROR_UNINSTALL_NOPRODUCTS_TITLE("uninstall.error.title1"),
    ERROR_UNINSTALLER("uninstall.error.title3"),
    LOG_DOWNLOAD_START("silent.download"),
    LOG_DOWNLOAD_END("silent.download.end"),
    DOWNLOAD_ERROR_TITLE("download.title"),
    DOWNLOAD_ERROR_MESSAGE("exception.download.retry"),
    STATUS_DOWNLOADING("status.download"),
    STATUS_DOWNLOADING_FINISHED("status.download.finished"),
    STATUS_ACCESSIBLE("status.accessible"),
    STATUS_ACCESSIBLE_UNINSTALL("status.accessible.uninstall"),
    STATUS_PREPARING("status.preparing"),
    LABEL_PRE_INSTALL("status.preparing"),
    STATUS_DOWNLOADING_INSTALLER("status.downloading.installer"),
    STATUS_PREPARING_INSTALLER("status.preparing.installer"),
    LABEL_POST_INSTALL("install.postinstall.label"),
    FOLDER_INVALID_PATH_CHARS_UNIX("folder.invalid.unix"),
    ERROR_INVALID_DESTINATION_FOLDER("error.invalid.destination.folder"),
    OPTION_INSUFFICIENT_DOWNLOADSPACE("downloadspace.option2"),
    SETUP_LMSERVICE_ARCH("windows.setup.lmservice", "mac.setup.lmservice", "linux.setup.lm"),
    SETUP_LMFILES_ARCH("windows.setup.lmfiles", "mac.setup.lmfiles", "linux.setup.lm"),
    SETUP_COMPILER_REQUIRED("setup.compilerreqd"),
    SETUP_COMPILER_WIN("setup.compiler.win"),
    SETUP_COMPILER_SDK_WIN("setup.compiler.sdk.win"),
    SETUP_COMPILER_SDK_GLNX64("setup.compiler.sdk.glnx64"),
    SETUP_MDCE("setup.mdce"),
    SETUP_COMPILER_RECOMMENDED("setup.compiler.recommended"),
    SETUP_SIMULINK_COMPILER("setup.simulink.compiler"),
    SETUP_COMPILER_ARCH("win32.compiler.html", "win64.compiler.html", "maci64.compiler.html", "glnxa64.compiler.html"),
    SETUP_MPS("setup.mps"),
    INSTALL_ERROR_TITLE("install.error.title"),
    OVERWRITE_TITLE("overwrite.title"),
    OVERWRITE_MESSAGE("overwrite.text"),
    MCR_OVERWRITE_MESSAGE("overwrite.mcr.text"),
    ANOTHER_PRODUCT("overwrite.comma"),
    OVER_PRODUCT_LIMIT("overwrite.etc"),
    OVERWRITE_TITLE_WARNING("overwrite.warning.title"),
    OVERWRITE_MESSAGE_INCOMPATIBLE("overwrite.warning3"),
    OVERWRITE_MESSAGE_VERSION("overwrite.warning"),
    OVERWRITE_TITLE_NOPRODUCTS("noproductsalert.title"),
    OVERWRITE_MESSAGE_NOPRODUCTS("noproductsalert1.message"),
    NOPRODUCTS_MESSAGE("noproductsalert.message"),
    NOPRODUCTS_TITLE("noproductsalert.title"),
    NOPRODUCTS_MESSAGE_FIK_FLOW("noproductmessage.fik.message"),
    NOPRODUCTS_TITLE_FIK_FLOW("noproductmessage.fik.title"),
    INSTALL_ADMIN_TITLE("install.admin.title"),
    INSTALL_ADMIN_TEXT("install.admin.text"),
    INSTALL_ALERT_ERROR("error.title"),
    INSTALL_EMULATION_MODE_TITLE("emulationmode.title"),
    INSTALL_EMULATION_MODE_TEXT("emulationmode.msg"),
    UNINSTALL_ARCHIVES_TITLE("uninstall.archives.title"),
    UNINSTALL_ARCHIVES_QUESTION("uninstall.archives"),
    ARCHIVES_TITLE("archives.title"),
    ARCHIVES_MESSAGE("archives.message"),
    ERROR_PASSWORD_MATCH("error.password.match"),
    ERROR_EMAILS_MATCH("error.emails.match"),
    MATLAB_LICENSE_AGREEMENT("matlab.license.agreement"),
    DOWNLOAD_REQUIRED("download.required"),
    MW_ARCHIVE_LOCATION("mw.archive.location"),
    MW_INSTALLER_LOCATION("mw.installer.location"),
    MW_FOLDER_LOCATION("mw.folder.location"),
    SHUTDOWN_MATLAB_TEXT("shutdown.MATLAB.txt"),
    DRIVESPACE_ERROR("drivespace.error"),
    DEPENDENCIES_MESSAGE_UNINSTALL_ADDONS("dependencies.message.uninstall.addons"),
    CANNOT_UNINSTALL_PRODUCT("cannot.uninstall.product"),
    WIN32_NOT_SUPPORTED("win32.not.supported"),
    VERIFY_LOGIN_INFORMATION("verify.status");

    private static final PlatformImpl PLATFORM;
    private static final String[] BASENAMES;
    private Map<Arch, String> resourceKeyMap = new EnumMap<Arch, String>(Arch.class);

    private ResourceKeys(String string2) {
        this(string2, string2, string2);
        for (Arch arch : Arch.values()) {
            this.resourceKeyMap.put(arch, string2);
        }
    }

    private ResourceKeys(String string2, String string3, String string4) {
        this(string2, string2, string3, string4);
    }

    private ResourceKeys(String string2, String string3, String string4, String string5) {
        this.resourceKeyMap.put(Arch.WIN32, string2);
        this.resourceKeyMap.put(Arch.WIN64, string3);
        this.resourceKeyMap.put(Arch.MACI64, string4);
        this.resourceKeyMap.put(Arch.GLNXA64, string5);
    }

    public String getString(Object ... objectArray) {
        return new ResourceRetrieverImpl(BASENAMES).getResource(this.getResourceKeyForArch(PLATFORM.getArch()), objectArray);
    }

    String getResourceKeyForArch(Arch arch) {
        return this.resourceKeyMap.get(arch);
    }

    static {
        PLATFORM = new PlatformImpl();
        BASENAMES = new String[]{"com.mathworks.installwizard.resources.RES_Installwizard"};
    }
}

