/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.model;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.Installer;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.installwizard.model.AbstractBackgroundTask;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.wizard.ExceptionHandler;
import com.mathworks.wizard.ui.WizardUI;
import java.io.File;
import java.io.IOException;

final class InstallTask
extends AbstractBackgroundTask {
    private final File downloadFolder;

    InstallTask(Installer installer, File file, File file2, WizardUI wizardUI, ExceptionHandler exceptionHandler, AppLogger appLogger, InstallStatusObserver ... installStatusObserverArray) {
        super(installer, file, wizardUI, exceptionHandler, appLogger, installStatusObserverArray);
        this.downloadFolder = file2;
    }

    @Override
    public ResourceKeys getErrorTitleResourceKey() {
        return ResourceKeys.INSTALLALERT_TITLE;
    }

    @Override
    protected long calculateTotalUnits(Installer installer, File file) {
        return installer.getInstallTotalUnits(file);
    }

    @Override
    protected void execute(Installer installer, File file, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver[] installStatusObserverArray) throws IOException, InterruptedException {
        try {
            installer.install(file, this.downloadFolder, installFlowControlHandler, installStatusObserverArray);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (Throwable throwable) {
            installFlowControlHandler.exitImmediately(throwable);
        }
    }

    public String getAccessibleName() {
        return ResourceKeys.STATUS_ACCESSIBLE.getString(new Object[0]);
    }
}

