/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallerBuilder;
import com.mathworks.install.InstallerRequirements;
import com.mathworks.install.service.Service;
import com.mathworks.install.service.ServiceException;
import com.mathworks.install.service.ServiceFoundInDifferentLocationException;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.installwizard.command.AbstractCommandStep;
import com.mathworks.installwizard.command.AbstractCommandStepFactory;
import com.mathworks.installwizard.command.CheckDownloadPathForInvalidCharactersStep;
import com.mathworks.installwizard.command.CheckPathForInvalidCharactersStep;
import com.mathworks.installwizard.command.CollectUdcGpuInfoStep;
import com.mathworks.installwizard.command.DependencyChecker;
import com.mathworks.installwizard.command.OpenDownloadLocationCommandWindows;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.Downloader;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.Machine;
import com.mathworks.instutil.ProcessExecutor;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.internal.dws.client.DownloadService;
import com.mathworks.internal.mwaws.client.v6.ActivationService;
import com.mathworks.mlwebservices.loginws.LoginService;
import com.mathworks.net.hyperlink.HyperlinkProvider;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.webservices.mcrdws.MCRDWSclient;
import com.mathworks.wizard.ExceptionHandler;
import com.mathworks.wizard.ExitHandler;
import com.mathworks.wizard.Step;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.InstallOptionModel;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.ui.CheckBoxConfiguration;
import com.mathworks.wizard.ui.WizardUI;
import com.mathworks.wizard.worker.WorkerFactory;
import java.io.File;
import java.util.concurrent.ExecutorService;

public final class InstallCommandStepFactoryWindows
extends AbstractCommandStepFactory {
    private static final String INVALID_CHARS_STRING = "'+', '@', ''', '!' '*', '?', ';', '<', '>', '|'";
    private static final String PATTERN = "([^+@'!*?;|>\\<])+";

    public InstallCommandStepFactoryWindows(InstallerBuilder installerBuilder, WizardUI wizardUI, ExceptionHandler exceptionHandler, ExecutorService executorService, ExitHandler exitHandler, LoginService loginService, ActivationService activationService, DownloadService downloadService, String string, String[] stringArray, String string2, AppLogger appLogger, Machine machine, IO iO, DependencyChecker dependencyChecker, InstallerRequirements installerRequirements, WorkerFactory workerFactory, InstallConfiguration installConfiguration, HyperlinkProvider hyperlinkProvider, Downloader downloader, ProxyConfiguration proxyConfiguration, ProcessExecutor processExecutor, MCRDWSclient mCRDWSclient, UsageDataCollector usageDataCollector) {
        super(downloadService, activationService, executorService, installerBuilder, exitHandler, string2, wizardUI, exceptionHandler, appLogger, string, stringArray, machine, loginService, iO, dependencyChecker, installerRequirements, workerFactory, installConfiguration, hyperlinkProvider, downloader, proxyConfiguration, processExecutor, mCRDWSclient, usageDataCollector);
    }

    @Override
    public Step createValidateLicenseServerSelectionStep(final InstallOptionModel installOptionModel, final Service service, final File file) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                if (installOptionModel.isSelected()) {
                    try {
                        service.exists(file);
                    }
                    catch (ServiceFoundInDifferentLocationException serviceFoundInDifferentLocationException) {
                        InstallCommandStepFactoryWindows.this.wizardUI.showErrorMessage(ResourceKeys.LICENSE_SERVICE_ERROR_TITLE.getString(new Object[0]), serviceFoundInDifferentLocationException.getMessage());
                        return false;
                    }
                    catch (ServiceException serviceException) {
                        // empty catch block
                    }
                }
                return true;
            }
        };
    }

    @Override
    public Step createCheckPathForInvalidCharactersStep(DefaultedModel<String> defaultedModel) {
        return new CheckPathForInvalidCharactersStep(defaultedModel, this.wizardUI, INVALID_CHARS_STRING, PATTERN, ResourceKeys.FOLDER_INVALID_PATH_CHARS_WINDOWS);
    }

    @Override
    public Step createCheckSymbolicLinkCreationPermissionsStep(DefaultedModel<String> defaultedModel) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                return true;
            }
        };
    }

    @Override
    public final Step createOpenDownloadLocationStep(DefaultedModel<File> defaultedModel, Model<CheckBoxConfiguration> model) {
        return new OpenDownloadLocationCommandWindows(defaultedModel, model, this.processExecutor);
    }

    @Override
    public final Step createCheckDownloadPathForInvalidCharactersStep(DefaultedModel<File> defaultedModel) {
        return new CheckDownloadPathForInvalidCharactersStep(defaultedModel, this.wizardUI, INVALID_CHARS_STRING, PATTERN, ResourceKeys.FOLDER_INVALID_PATH_CHARS_WINDOWS);
    }

    @Override
    public Step createWarningMessageIfMATLABRunning(DefaultedModel<String> defaultedModel) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                boolean bl = InstallCommandStepFactoryWindows.this.installerRequirements.anyMatlabRunning();
                if (bl) {
                    InstallCommandStepFactoryWindows.this.showWarningMessage();
                }
                return !bl;
            }
        };
    }

    @Override
    public Step createCollectUdcGpuInfoStep(UsageDataCollector usageDataCollector, String string) {
        return new CollectUdcGpuInfoStep(this.archString, string, this.executorService, this.logger, usageDataCollector);
    }
}

