/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install.InstallerBuilder;
import com.mathworks.install.input.ComponentURLProvider;
import com.mathworks.installwizard.command.AbstractMCRDWSCallable;
import com.mathworks.installwizard.command.WebServiceStatus;
import com.mathworks.instutil.Downloader;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.mcrdws.MCRDWSclient;
import com.mathworks.webservices.mcrdws.model.Component;
import com.mathworks.webservices.mcrdws.model.Components;
import com.mathworks.webservices.mcrdws.model.ReleaseData;
import com.mathworks.webservices.mcrdws.model.ReleaseUrl;
import com.mathworks.wizard.ExceptionHandler;
import com.mathworks.wizard.model.Model;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;

final class GetLatestMCRComponentsCallable
extends AbstractMCRDWSCallable<Components> {
    private final InstallerBuilder installerBuilder;
    private final Model<WebServiceStatus> webServiceStatusModel;
    private final Downloader downloader;
    private final ProxyConfiguration proxyConfiguration;
    private final MCRDWSclient mcrdwSclient;
    private IO io;

    GetLatestMCRComponentsCallable(ExceptionHandler exceptionHandler, String string, InstallerBuilder installerBuilder, Model<WebServiceStatus> model, Downloader downloader, ProxyConfiguration proxyConfiguration, IO iO, MCRDWSclient mCRDWSclient, String string2) {
        super(exceptionHandler, string2, string);
        this.installerBuilder = installerBuilder;
        this.webServiceStatusModel = model;
        this.downloader = downloader;
        this.proxyConfiguration = proxyConfiguration;
        this.io = iO;
        this.mcrdwSclient = mCRDWSclient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Components doCall(String string, String string2, String string3) throws InterruptedException, MathWorksClientException, MathWorksServiceException, IOException {
        MyComponentURLProvider myComponentURLProvider = new MyComponentURLProvider(string2, string, this.mcrdwSclient);
        WebServiceStatus webServiceStatus = (WebServiceStatus)this.webServiceStatusModel.get();
        if (webServiceStatus.isWebServiceUp()) {
            ReleaseData releaseData = webServiceStatus.getReleaseData();
            for (ReleaseUrl releaseUrl : releaseData.getReleaseUrl()) {
                File file = null;
                try {
                    file = File.createTempFile("dwsZipFile", null);
                    URL uRL = new URL(releaseUrl.getUrl());
                    this.downloader.download(this.proxyConfiguration, uRL, file, new IOObserver[0]);
                    myComponentURLProvider.setReleaseId(releaseUrl.getReleaseId());
                    this.installerBuilder.addReleaseData(file, (ComponentURLProvider)myComponentURLProvider);
                }
                finally {
                    this.io.deleteFile(file);
                }
            }
        }
        return myComponentURLProvider.doCall();
    }

    @Override
    protected void apply(Components components) {
    }

    private static class MyComponentURLProvider
    implements ComponentURLProvider {
        private final String clientString;
        private final String localeString;
        private final Components components = new Components();
        private final Map<String, String> componentToURLMap = new HashMap<String, String>();
        private String releaseId;
        private final MCRDWSclient mcrdwSclient;

        MyComponentURLProvider(String string, String string2, MCRDWSclient mCRDWSclient) {
            this.clientString = string;
            this.localeString = string2;
            this.mcrdwSclient = mCRDWSclient;
        }

        private Components doCall() throws RemoteException, MathWorksClientException, MathWorksServiceException {
            this.components.setReleaseFamily(InstutilResourceKeys.RELEASE.getString(new Object[0]));
            try {
                Components components = this.mcrdwSclient.getComponents(this.components, this.localeString, this.clientString);
                for (Component component : components.getComponent()) {
                    String string = component.getComponentName();
                    String string2 = component.getVersion();
                    this.componentToURLMap.put(MyComponentURLProvider.getKey(string, string2), component.getComponentUrl());
                }
                return components;
            }
            catch (Exception exception) {
                this.components.getComponent().add(new Component());
                return this.components;
            }
        }

        public String getURL(String string, String string2) {
            return this.componentToURLMap.get(MyComponentURLProvider.getKey(string, string2));
        }

        private static String getKey(String string, String string2) {
            return string + "_" + string2;
        }

        public void add(String string, String string2) {
            Component component = new Component();
            component.setReleaseId(this.releaseId);
            component.setComponentName(string);
            component.setVersion(string2);
            this.components.getComponent().add(component);
        }

        public void setReleaseId(String string) {
            this.releaseId = string;
        }
    }
}

