/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.installwizard.command.AbstractWebServiceCallable;
import com.mathworks.instutil.AvailablePlatform;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.internal.dws.client.DownloadService;
import com.mathworks.internal.dws.client.EntitledProduct;
import com.mathworks.internal.dws.client.GetReleaseDataForProfileRequest;
import com.mathworks.internal.dws.client.GetReleaseDataReturn;
import com.mathworks.internal.dws.client.MWMessage;
import com.mathworks.internal.dws.client.ReleaseData;
import com.mathworks.wizard.ExceptionHandler;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.PlatformModel;
import com.mathworks.wizard.ui.WizardUI;
import java.io.IOException;
import java.util.Arrays;

final class CheckForUpdatesInDownloadOnlyCallable
extends AbstractWebServiceCallable<GetReleaseDataReturn, MWMessage> {
    private static final MWMessage[] EMPTY_MESSAGE_ARRAY = new MWMessage[0];
    private final DownloadService downloadService;
    private final Model<String> securityToken;
    private final Model<Boolean> checkForUpdatesSwitch;
    private final Model<ReleaseData[]> releaseDataModel;
    private final AppLogger logger;
    private Model<EntitledProduct[]> entitledProductsModel;
    private final PlatformModel<AvailablePlatform> platformModel;

    CheckForUpdatesInDownloadOnlyCallable(WizardUI wizardUI, ExceptionHandler exceptionHandler, String string, DownloadService downloadService, Model<String> model, Model<Boolean> model2, Model<ReleaseData[]> model3, AppLogger appLogger, Model<EntitledProduct[]> model4, PlatformModel<AvailablePlatform> platformModel, String string2) {
        super(wizardUI, exceptionHandler, string, string2);
        this.downloadService = downloadService;
        this.securityToken = model;
        this.checkForUpdatesSwitch = model2;
        this.releaseDataModel = model3;
        this.logger = appLogger;
        this.entitledProductsModel = model4;
        this.platformModel = platformModel;
    }

    @Override
    protected int getResult(GetReleaseDataReturn getReleaseDataReturn) {
        return 0;
    }

    protected MWMessage[] getMessages(GetReleaseDataReturn getReleaseDataReturn) {
        MWMessage[] mWMessageArray = getReleaseDataReturn.getMessages();
        if (mWMessageArray == null) {
            return EMPTY_MESSAGE_ARRAY;
        }
        return mWMessageArray;
    }

    @Override
    protected GetReleaseDataReturn doCall(String string, String string2, String string3) throws IOException {
        GetReleaseDataForProfileRequest getReleaseDataForProfileRequest = new GetReleaseDataForProfileRequest();
        getReleaseDataForProfileRequest.setLocale(string);
        getReleaseDataForProfileRequest.setRelease(string3);
        getReleaseDataForProfileRequest.setClientString(string2);
        getReleaseDataForProfileRequest.setArchitecture(this.platformModel.getSelectedPlatforms());
        getReleaseDataForProfileRequest.setToken((String)this.securityToken.get());
        return this.downloadService.getReleaseDataForProfile(getReleaseDataForProfileRequest);
    }

    @Override
    protected boolean shouldDisplayError(MWMessage mWMessage) {
        return false;
    }

    @Override
    protected Object[] getErrorArguments(MWMessage mWMessage) {
        return new Object[]{mWMessage.getCode(), mWMessage.getDescription()};
    }

    @Override
    protected void apply(GetReleaseDataReturn getReleaseDataReturn) {
        this.releaseDataModel.set((Object)getReleaseDataReturn.getReleaseData());
        if (Arrays.asList(getReleaseDataReturn.getEntitledProducts()).isEmpty()) {
            this.logger.logMsg("Empty EntitledProduct array. Disabling DWS.");
            this.checkForUpdatesSwitch.set((Object)false);
        } else if (Arrays.asList(getReleaseDataReturn.getReleaseData()).isEmpty()) {
            this.logger.logMsg("Empty ReleaseData array. Disabling DWS.");
            this.checkForUpdatesSwitch.set((Object)false);
        } else {
            this.entitledProductsModel.set((Object)getReleaseDataReturn.getEntitledProducts());
            this.checkForUpdatesSwitch.set((Object)true);
        }
    }
}

