/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard;

import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallConfigurationPersistence;
import com.mathworks.install.InstallableProduct;
import com.mathworks.install.InstallerRequirements;
import com.mathworks.install.Product;
import com.mathworks.install.RegisterAppPath;
import com.mathworks.install.command.Command;
import com.mathworks.install.command.CommandFactory;
import com.mathworks.install.condition.ArchConditions;
import com.mathworks.install.condition.Condition;
import com.mathworks.install.condition.ControllingProductCondition;
import com.mathworks.install.exception.ExceptionLevel;
import com.mathworks.install.exception.InstallerRequirementNotSatisfiedException;
import com.mathworks.install.service.ServiceFactory;
import com.mathworks.installwizard.NoRegistryKeyException;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.Arch;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.Registry;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;

public abstract class AbstractMathworksInstallConfiguration
implements InstallConfiguration {
    private static final int LICENSE_MANAGER = 0;
    private static final String ROOT = "MATLABROOT";
    private static final String COMMENTS = " ";

    public Command[] createInstallUninstallerCommands(String string, String string2, Product[] productArray, CommandFactory commandFactory, InstallConfigurationPersistence installConfigurationPersistence) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        List<Product> list = Arrays.asList(productArray);
        IOFileFilter iOFileFilter = FileFilterUtils.fileFileFilter();
        Condition condition = new Condition(){
            final ControllingProductCondition controllingProductCondition = new ControllingProductCondition();

            public boolean isSatisfied(String string, Collection<? extends Product> collection) {
                if (this.controllingProductCondition.isSatisfied(string, collection)) {
                    return true;
                }
                for (Product product : collection) {
                    if (product.getProductNumber() != 0) continue;
                    return true;
                }
                return false;
            }
        };
        this.addIfOnWindowsAndAllConditionsSatisfied(string, list, arrayList, commandFactory.createCopyFilesToInstallationCommand(Paths.get(string2, "utils", "uninstall").toString(), Paths.get("uninstall", new String[0]).toString(), (FilenameFilter)iOFileFilter), condition);
        this.addIfOnWindowsAndAllConditionsSatisfied(string, list, arrayList, commandFactory.createCopyFilesToInstallationCommand(Paths.get(string2, "bin", string).toString(), Paths.get("uninstall", "bin", string).toString(), (FilenameFilter)FileFilterUtils.orFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".ocx"), (IOFileFilter)FileFilterUtils.suffixFileFilter((String)".dll"))), condition);
        this.addIfOnWindowsAndAllConditionsSatisfied(string, list, arrayList, commandFactory.createCopyFilesToInstallationCommand(Paths.get(string2, "utils", "uninstall", "bin", string).toString(), Paths.get("uninstall", "bin", string).toString(), (FilenameFilter)iOFileFilter), condition);
        this.addIfOnWindowsAndAllConditionsSatisfied(string, list, arrayList, commandFactory.createCopyFilesToInstallationCommand(Paths.get(string2, "java").toString(), Paths.get("uninstall", "java").toString(), (FilenameFilter)FileFilterUtils.trueFileFilter()), condition);
        this.addIfOnWindowsAndAllConditionsSatisfied(string, list, arrayList, commandFactory.createWriteInstallConfigurationCommand(installConfigurationPersistence, (InstallConfiguration)this), condition);
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    public final Command[] createRegisterUninstallerCommands(String string, Product[] productArray, CommandFactory commandFactory, InstallerRequirements installerRequirements) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        List<Product> list = Arrays.asList(productArray);
        this.addIfOnWindowsAndAllConditionsSatisfied(string, list, arrayList, commandFactory.createRegisterUninstallerCommand(this.getUninstallProgramsEntryName(string, list), this.getUninstallProgramsEntryVersion(string, list), InstutilResourceKeys.RELEASE.getString(new Object[0]), this.add32BitQualifierIfOn64BitMachine(string, this.getUninstallProgramsEntryDisplayName(string, list), installerRequirements), "uninstall" + File.separator + "bin" + File.separator + string + File.separator + "uninstall.exe", "bin" + File.separator + string + File.separator + "matlab.ico", COMMENTS), new Condition[]{new ControllingProductCondition()});
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    protected final String add32BitQualifierIfOn64BitMachine(String string, String string2, InstallerRequirements installerRequirements) {
        if (installerRequirements.isRunningInEmulationMode()) {
            return string2.concat(COMMENTS).concat(this.convertArch(string));
        }
        return string2;
    }

    public final Command[] createRegisterApplicationCommands(final String string, Product[] productArray, CommandFactory commandFactory) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        final List<Product> list = Arrays.asList(productArray);
        this.addIfOnWindowsAndAllConditionsSatisfied(string, list, arrayList, commandFactory.createRegisterApplicationCommand(new RegisterAppPath(){

            public String getSubKey(String string2) {
                return AbstractMathworksInstallConfiguration.this.getApplicationLocationSubKey(string, list);
            }

            public String getName() {
                return AbstractMathworksInstallConfiguration.ROOT;
            }

            public String getKeyVal(String string2) {
                return AbstractMathworksInstallConfiguration.this.getPathToRegister(string2);
            }
        }), new Condition[]{new ControllingProductCondition()});
        this.addAdditionalRegisterApplicationCommands(string, commandFactory, arrayList, list);
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    protected abstract void addAdditionalRegisterApplicationCommands(String var1, CommandFactory var2, Collection<Command> var3, Collection<Product> var4);

    protected abstract String getPathToRegister(String var1);

    public final String getApplicationLocation(Registry registry, String string, Product[] productArray) {
        List<Product> list = Arrays.asList(productArray);
        String string2 = registry.getRegKeyValue("HKEY_LOCAL_MACHINE", this.getApplicationLocationSubKey(string, list), ROOT);
        if (string2 == null && !"".equalsIgnoreCase(string2)) {
            throw new NoRegistryKeyException();
        }
        return string2;
    }

    public final boolean isApplicationLocationStoredInRegistry(Registry registry, String string, Product[] productArray) {
        try {
            this.getApplicationLocation(registry, string, productArray);
            return true;
        }
        catch (NoRegistryKeyException noRegistryKeyException) {
            return false;
        }
    }

    public final void checkInstallerRequirements(InstallerRequirements installerRequirements) throws InstallerRequirementNotSatisfiedException {
        if (!installerRequirements.userIsAdmin()) {
            throw new InstallerRequirementNotSatisfiedException(ExceptionLevel.SEVERE, ResourceKeys.INSTALL_ADMIN_TITLE.getString(new Object[0]), ResourceKeys.INSTALL_ADMIN_TEXT.getString(new Object[0]));
        }
        this.checkAdditionalInstallerRequirements(installerRequirements);
    }

    protected abstract void checkAdditionalInstallerRequirements(InstallerRequirements var1) throws InstallerRequirementNotSatisfiedException;

    public final void checkUninstallerRequirements(InstallerRequirements installerRequirements) throws InstallerRequirementNotSatisfiedException {
        this.checkAdditionalUninstallerRequirements(installerRequirements);
    }

    protected abstract void checkAdditionalUninstallerRequirements(InstallerRequirements var1) throws InstallerRequirementNotSatisfiedException;

    private String getApplicationLocationSubKey(String string, Collection<Product> collection) {
        return "Software\\MathWorks\\" + this.getApplicationName(string, collection) + "\\" + this.getApplicationVersion(string, collection);
    }

    protected abstract String getApplicationVersion(String var1, Collection<? extends Product> var2);

    protected abstract String getApplicationName(String var1, Collection<? extends Product> var2);

    public final Command[] getPostUninstallCommands(String string, Product[] productArray, CommandFactory commandFactory, IO iO) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        arrayList.add(commandFactory.createGenerateClasspathCommand());
        arrayList.addAll(Arrays.asList(this.getAdditionalPostUninstallCommands(string, productArray, commandFactory, iO)));
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    public final Command[] getPostInstallCommands(String string, Product[] productArray, CommandFactory commandFactory, ServiceFactory serviceFactory, IO iO, Properties properties) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        arrayList.add(commandFactory.createGenerateClasspathCommand());
        arrayList.addAll(Arrays.asList(this.getAdditionalPostInstallCommands(string, productArray, commandFactory, serviceFactory, iO, properties)));
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    protected abstract Command[] getAdditionalPostUninstallCommands(String var1, Product[] var2, CommandFactory var3, IO var4);

    protected abstract Command[] getAdditionalPostInstallCommands(String var1, Product[] var2, CommandFactory var3, ServiceFactory var4, IO var5, Properties var6);

    protected abstract String getUninstallProgramsEntryName(String var1, Collection<Product> var2);

    protected abstract String getUninstallProgramsEntryVersion(String var1, Collection<? extends Product> var2);

    protected abstract String getUninstallProgramsEntryDisplayName(String var1, Collection<Product> var2);

    protected final String convertArch(String string) {
        if (string.equalsIgnoreCase(Arch.WIN32.getString())) {
            return InstutilResourceKeys.X86_ARCH.getString(new Object[0]);
        }
        return "";
    }

    protected final void addIfOnWindowsAndAllConditionsSatisfied(String string, Collection<Product> collection, Collection<Command> collection2, Command command, Condition ... conditionArray) {
        if (ArchConditions.WINDOWS.isSatisfied(string, collection)) {
            this.addIfAllConditionsSatisfied(string, collection, collection2, command, conditionArray);
        }
    }

    private void addIfAllConditionsSatisfied(String string, Collection<Product> collection, Collection<Command> collection2, Command command, Condition ... conditionArray) {
        if (this.allConditionsSatisfied(conditionArray, string, collection)) {
            collection2.add(command);
        }
    }

    public final boolean checkIfOnWindowsAndAllConditionsSatisfied(String string, Collection<Product> collection, Condition ... conditionArray) {
        return ArchConditions.WINDOWS.isSatisfied(string, collection) && this.allConditionsSatisfied(conditionArray, string, collection);
    }

    private boolean allConditionsSatisfied(Condition[] conditionArray, String string, Collection<Product> collection) {
        for (Condition condition : conditionArray) {
            if (condition.isSatisfied(string, collection)) continue;
            return false;
        }
        return true;
    }

    public final URL getLicenseAgreementURL() {
        String string = this.getLicenseAgreementPath();
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        return classLoader.getResource(string);
    }

    protected abstract String getLicenseAgreementPath();

    public boolean displayAssemblingProductProgressDialog() {
        return true;
    }

    public boolean shouldAddCommandsForOptions(InstallableProduct[] installableProductArray) {
        return installableProductArray.length > 0;
    }

    public static enum MatlabRuntimeProductConditions implements Condition
    {
        MATLAB_Runtime_Base_Product(35010);

        private final int bitNum;

        private MatlabRuntimeProductConditions(int n2) {
            this.bitNum = n2;
        }

        public boolean isSatisfied(String string, Collection<? extends Product> collection) {
            for (Product product : collection) {
                if (product.getProductNumber() != this.bitNum) continue;
                return true;
            }
            return false;
        }
    }
}

