/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil;

import com.mathworks.instutil.FontHandler;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.wizard.CJKFontSize;
import com.mathworks.instutil.wizard.FontSizeStrategy;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class FontHandlerImpl
implements FontHandler {
    private FontUIResource defaultFont;
    private final float multiplier;

    public FontHandlerImpl() {
        this(new PlatformImpl(), new CJKFontSize());
    }

    public FontHandlerImpl(Platform platform, FontSizeStrategy fontSizeStrategy) {
        int n;
        GraphicsEnvironment.getLocalGraphicsEnvironment().preferProportionalFonts();
        Font font = (Font)UIManager.get("OptionPane.font");
        float f = font.getSize2D();
        if (platform.isCJK()) {
            fontSizeStrategy.getSize(font);
        }
        if ((n = font.getStyle()) == 1) {
            n = 0;
        }
        this.defaultFont = new FontUIResource(font.deriveFont(n, f));
        this.multiplier = this.defaultFont.getSize2D() / 11.0f;
    }

    @Override
    public FontUIResource getFont() {
        return this.defaultFont;
    }

    @Override
    public int getSize(int n) {
        Float f = Float.valueOf((float)n * this.multiplier);
        return f.intValue();
    }
}

