/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.vrd.view;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import com.mathworks.vrd.license.License;
import com.mathworks.vrd.view.LicenseList;
import com.mathworks.vrd.view.config.LicenseUIConfig;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class LicenseTable
extends JTable
implements LicenseList {
    private final EventList<License> fMasterLicenseList;
    private final EventSelectionModel<License> fSelectionModel;
    private final EventList<License> fSelectedLicenseList;
    private final EventTableModel<License> fLicenseTableModel;
    private final Collection<ListDataListener> fListDataListeners = new ArrayList<ListDataListener>();

    public LicenseTable(TableFormat<License> tableFormat, LicenseUIConfig licenseUIConfig) {
        this.fMasterLicenseList = new BasicEventList();
        this.fSelectionModel = new EventSelectionModel(this.fMasterLicenseList);
        this.fSelectedLicenseList = this.fSelectionModel.getSelected();
        this.fLicenseTableModel = new EventTableModel(this.fMasterLicenseList, tableFormat);
        this.setModel((TableModel)this.fLicenseTableModel);
        this.setSelectionModel((ListSelectionModel)this.fSelectionModel);
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowSelectionAllowed(true);
        this.fSelectionModel.setSelectionMode(licenseUIConfig.isMultiSelectSupported() ? 2 : 0);
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "consume");
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "consume");
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        actionMap.put("consume", abstractAction);
        inputMap.put(KeyStroke.getKeyStroke(9, 64), "up");
        actionMap.put("up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(9, 0), "down");
        actionMap.put("down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        });
        this.setRowHeight(this.getFontMetrics(this.getFont()).getHeight() + 2);
    }

    @Override
    public void updateLicense(License license) {
        int n = this.fMasterLicenseList.indexOf((Object)license);
        if (n >= 0) {
            this.fMasterLicenseList.set(n, (Object)license);
            for (ListDataListener listDataListener : this.fListDataListeners) {
                listDataListener.contentsChanged(new ListDataEvent(this, 0, n, n));
            }
        }
    }

    @Override
    public void removeLicense(License license, boolean bl) {
        int n = this.fMasterLicenseList.indexOf((Object)license);
        this.fMasterLicenseList.remove((Object)license);
        if (bl && n < this.fMasterLicenseList.size()) {
            this.fSelectionModel.addSelectionInterval(n, n);
        }
        for (ListDataListener listDataListener : this.fListDataListeners) {
            listDataListener.intervalRemoved(new ListDataEvent(this, 2, n, n));
        }
    }

    @Override
    public void addLicense(License license, boolean bl) {
        this.fMasterLicenseList.add((Object)license);
        int n = this.fMasterLicenseList.indexOf((Object)license);
        if (bl) {
            this.fSelectionModel.addSelectionInterval(n, n);
        }
        for (ListDataListener listDataListener : this.fListDataListeners) {
            listDataListener.intervalAdded(new ListDataEvent(this, 1, n, n));
        }
    }

    @Override
    public void setFocus() {
        this.requestFocusInWindow();
    }

    @Override
    public void autoSize() {
        TableModel tableModel = this.getModel();
        TableCellRenderer tableCellRenderer = this.getTableHeader().getDefaultRenderer();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            Component component = tableCellRenderer.getTableCellRendererComponent(this, tableColumn.getHeaderValue(), true, true, 0, i);
            int n = component.getPreferredSize().width;
            int n2 = 0;
            for (int j = 0; j < this.getRowCount(); ++j) {
                component = this.getDefaultRenderer(tableModel.getColumnClass(i)).getTableCellRendererComponent(this, tableModel.getValueAt(j, i), true, true, j, i);
                n2 = Math.max(n2, component.getPreferredSize().width);
            }
            tableColumn.setPreferredWidth(Math.max(n, n2) + 20);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.fMasterLicenseList.isEmpty();
    }

    @Override
    public Collection<License> getSelectedLicenses() {
        return new ArrayList<License>((Collection<License>)this.fSelectedLicenseList);
    }

    @Override
    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.fSelectionModel.addListSelectionListener(listSelectionListener);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.fSelectionModel.removeListSelectionListener(listSelectionListener);
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        this.fListDataListeners.add(listDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        this.fListDataListeners.remove(listDataListener);
    }

    @Override
    public void formatChanged() {
        this.fSelectionModel.setValueIsAdjusting(true);
        int[] nArray = this.getSelectedRows();
        this.fLicenseTableModel.fireTableStructureChanged();
        this.fSelectionModel.setValueIsAdjusting(false);
        for (int n : nArray) {
            this.fSelectionModel.addSelectionInterval(n, n);
        }
    }
}

