/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.vrd.view;

import ca.odell.glazedlists.gui.TableFormat;
import com.mathworks.vrd.license.License;
import com.mathworks.vrd.view.VRDView;
import com.mathworks.vrd.view.config.LicenseUIConfig;

public class DefaultLicenseTableFormat
implements TableFormat<License> {
    private final VRDView fView;
    private final LicenseUIConfig fConfig;

    public DefaultLicenseTableFormat(VRDView vRDView, LicenseUIConfig licenseUIConfig) {
        this.fView = vRDView;
        this.fConfig = licenseUIConfig;
    }

    public int getColumnCount() {
        return this.fConfig.isLicenseStatusVisible() ? 3 : 2;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return this.fView.intlString("table.col.license");
        }
        if (n == 1) {
            return this.fView.intlString("table.col.option");
        }
        if (n == 2 && this.fConfig.isLicenseStatusVisible()) {
            return this.fView.intlString("table.col.status");
        }
        throw new IllegalStateException();
    }

    public Object getColumnValue(License license, int n) {
        if (n == 0) {
            return license.getLicenseString();
        }
        if (n == 1) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = license.getActivationType().toString();
            String string2 = license.getLicenseOption().toString();
            if (!"".equals(string) && !"".equals(string2)) {
                stringBuilder.append(string2).append(" - ").append(string);
            } else if (!"".equals(string)) {
                stringBuilder.append(string);
            } else if (!"".equals(string2)) {
                stringBuilder.append(string2);
            }
            return stringBuilder.toString();
        }
        if (n == 2 && this.fConfig.isLicenseStatusVisible()) {
            StringBuilder stringBuilder = new StringBuilder(this.fConfig.getDisplayedLicenseStatus(license));
            if (license.getLicenseStatus().isActionRequired()) {
                stringBuilder.insert(0, "<b>").append("</b>");
            }
            if (license.getLicenseStatus().wasActionPerformed()) {
                stringBuilder.insert(0, "<i>").append("</i>");
            }
            stringBuilder.insert(0, "<html>").append("</html>");
            return stringBuilder.toString();
        }
        throw new IllegalStateException();
    }
}

