/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.client.core.http;

import com.mathworks.webservices.client.core.ClientConfiguration;
import com.mathworks.webservices.client.core.auth.ProxyServerCredentialsProvider;
import com.mathworks.webservices.client.core.auth.ProxyServerCredentialsProviderAdapter;
import com.mathworks.webservices.client.core.http.HttpResponse;
import java.io.IOException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;

public class MathWorksHttpClient {
    private HttpClient httpClient;

    public MathWorksHttpClient() {
        this(new ClientConfiguration());
    }

    public MathWorksHttpClient(ClientConfiguration config) {
        if (null == config) {
            config = new ClientConfiguration();
        }
        this.configureClient(config);
    }

    public void clearProxySettings() {
        this.httpClient.getParams().setParameter("http.authentication.credential-provider", null);
        this.httpClient.setHostConfiguration(new HostConfiguration());
    }

    public void setProxyConfiguration(String host, int port) {
        this.setProxyConfiguration(host, port, null, null);
    }

    public void setProxyConfiguration(String host, int port, String username, String password) {
        this.clearProxySettings();
        HostConfiguration hostConfiguration = new HostConfiguration();
        if (host != null && port > 0) {
            hostConfiguration.setProxy(host, port);
            if (username != null && password != null) {
                AuthScope authScope = new AuthScope(host, port);
                WindowsUser user = this.getWindowsUser(username);
                Object credentials = user == null ? new UsernamePasswordCredentials(username, password) : new NTCredentials(user.username, password, host, user.domain);
                this.httpClient.getState().setProxyCredentials(authScope, (Credentials)credentials);
            }
        }
        this.httpClient.setHostConfiguration(hostConfiguration);
    }

    WindowsUser getWindowsUser(String username) {
        String[] array;
        if (username != null && (array = username.split("\\\\")).length == 2) {
            WindowsUser user = new WindowsUser();
            user.domain = array[0];
            user.username = array[1];
            return user;
        }
        return null;
    }

    public void setProxyConfiguration(String host, int port, ProxyServerCredentialsProvider credentialsProvider) {
        this.clearProxySettings();
        this.setProxyConfiguration(host, port);
        ProxyServerCredentialsProviderAdapter provider = new ProxyServerCredentialsProviderAdapter(credentialsProvider);
        this.httpClient.getParams().setParameter("http.authentication.credential-provider", (Object)provider);
    }

    private HttpClient configureClient(ClientConfiguration config) {
        assert (null != config);
        this.httpClient = new HttpClient();
        this.httpClient.setHttpConnectionManager((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        this.httpClient.getParams().setSoTimeout(config.getSocketTimeout());
        this.httpClient.getParams().setConnectionManagerTimeout((long)config.getConnectionTimeout());
        this.customizeHttpClient(this.httpClient);
        return this.httpClient;
    }

    protected void customizeHttpClient(HttpClient httpClient) {
    }

    public HttpResponse invoke(HttpMethodBase request) throws IOException {
        int statusCode = this.httpClient.executeMethod((HttpMethod)request);
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setStatusCode(statusCode);
        httpResponse.setResponseBody(request.getResponseBodyAsStream());
        httpResponse.setStatusText(request.getStatusText());
        for (Header header : request.getResponseHeaders()) {
            httpResponse.addHeader(header.getName(), header.getValue());
        }
        return httpResponse;
    }

    private class WindowsUser {
        String username;
        String domain;

        private WindowsUser() {
        }
    }
}

