/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.udc;

import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.ProcessExecutorImpl;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;

public class UdcUtil {
    public static void collectBasicSessionInfo(UsageDataCollector usageDataCollector) {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_START_TIME, date);
        usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_RELEASE_FAMILY, InstutilResourceKeys.RELEASE.getString(new Object[0]));
        usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_RELEASE, InstutilResourceKeys.RELEASE_DESCRIPTION.getString(new Object[0]));
    }

    public static void collectCpuAndMemoryInfo(UsageDataCollector usageDataCollector) {
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        long l = operatingSystemMXBean.getFreePhysicalMemorySize();
        long l2 = operatingSystemMXBean.getTotalPhysicalMemorySize();
        long l3 = operatingSystemMXBean.getCommittedVirtualMemorySize();
        int n = operatingSystemMXBean.getAvailableProcessors();
        usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_AVAILABLE_PROCESSORS, n);
        usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_MEMORY_FREE, l);
        usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_MEMORY_TOTAL, l2);
        usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_MEMORY_VIRTUAL_COMMIT, l3);
    }

    public static void collectOsInfo(UsageDataCollector usageDataCollector, ExecutorService executorService) {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.version");
        String string3 = System.getProperty("os.arch");
        if (string.equalsIgnoreCase("linux")) {
            String string4 = "Unknown Linux Distribution";
            File file = new File("/usr/bin/lsb_release");
            if (file.exists() && file.canExecute()) {
                try {
                    List list = ProcessExecutorImpl.executeTaskWithOutput((String[])new String[]{file.toString(), "-ds"}, (ExecutorService)executorService);
                    if (!list.isEmpty()) {
                        string4 = ((String)list.get(0)).replace('\"', ' ').trim();
                    }
                }
                catch (IOException | ExecutionException | TimeoutException exception) {
                    // empty catch block
                }
            }
            usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_LINUX_KERNEL_VERSION, string2);
            string2 = string4;
        }
        usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_OPERATING_SYSTEM_NAME, string);
        usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_OPERATING_SYSTEM_VERSION, string2);
        usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_OPERATING_SYSTEM_ARCH, string3);
    }

    public static void collectInstallTime(UsageDataCollector usageDataCollector, long l, long l2) {
        long l3 = (l2 - l) / 1000L;
        Object object = usageDataCollector.getData(UsageDataCollectorKey.SESSION_DATA_TOTAL_DOWNLOAD_TIME);
        if (object != null) {
            l3 -= ((Long)object).longValue();
        }
        usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_TOTAL_INSTALLATION_TIME, l3);
    }
}

