/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.input;

import com.mathworks.install.ComponentData;
import com.mathworks.install.XMLParseException;
import com.mathworks.install.input.ComponentSource;
import com.mathworks.install.input.ComponentSourceFactory;
import com.mathworks.install.input.ComponentSourceProvider;
import com.mathworks.install.input.FileInputStreamProvider;
import com.mathworks.install.input.InstallationInputFile;
import com.mathworks.install.input.XMLInstallationFileParser;
import com.mathworks.instutil.IOObserver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

final class ProductOrComponentXMLFileForZip
implements InstallationInputFile {
    private final File file;
    private XMLInstallationFileParser xmlInstallationFileParser;
    private final ComponentSourceFactory componentSourceFactory;

    ProductOrComponentXMLFileForZip(File file, XMLInstallationFileParser xMLInstallationFileParser, ComponentSourceFactory componentSourceFactory) {
        this.file = file;
        this.xmlInstallationFileParser = xMLInstallationFileParser;
        this.componentSourceFactory = componentSourceFactory;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void parse() throws IOException, XMLParseException {
        this.xmlInstallationFileParser.readInDefinition(new FileInputStreamProvider(this.file), new ComponentSourceProvider(){
            private FileInputStream fileInputStream;

            @Override
            public void open() throws IOException {
                this.fileInputStream = new FileInputStream(FilenameUtils.removeExtension((String)ProductOrComponentXMLFileForZip.this.file.getAbsolutePath()).concat(".zip"));
            }

            @Override
            public ComponentSource getComponentSource(File file, String string, ComponentData componentData) throws IOException {
                return ProductOrComponentXMLFileForZip.this.componentSourceFactory.createArchiveComponentSource(this.fileInputStream);
            }

            @Override
            public void close() {
                IOUtils.closeQuietly((InputStream)this.fileInputStream);
            }

            @Override
            public long getDownloadSize(long l) {
                return 0L;
            }

            @Override
            public void addComponent(String string) {
            }

            @Override
            public void download(File file, String string, ComponentData componentData, long l, String string2, IOObserver iOObserver) throws IOException, InterruptedException {
            }
        });
    }
}

