/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocSetItemList;
import com.mathworks.install.command.doc.DocSetItemType;
import com.mathworks.install.command.doc.InstalledDocSetItem;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

class DocSetDocumentBuilder {
    private final Document document;

    DocSetDocumentBuilder(DocSetItemList docSetItemList) {
        this.document = DocSetDocumentBuilder.buildDocSetXmlDocument(docSetItemList);
    }

    private static Document buildDocSetXmlDocument(DocSetItemList docSetItemList) {
        Element element = new Element("documentation-set");
        Element element2 = new Element("format");
        element2.setText("doccenter");
        element.addContent((Content)element2);
        for (DocSetItemType docSetItemType : DocSetItemType.values()) {
            List<InstalledDocSetItem> list = docSetItemList.getInstalledDocSetItems(EnumSet.of(docSetItemType));
            if (docSetItemType != DocSetItemType.PRODUCT && (list == null || list.isEmpty())) continue;
            String string = docSetItemType.name().toLowerCase(Locale.ENGLISH);
            Element element3 = new Element(string + "-list");
            for (InstalledDocSetItem installedDocSetItem : list) {
                Element element4 = DocSetDocumentBuilder.buildElement(installedDocSetItem, string);
                element3.addContent((Content)element4);
            }
            element.addContent((Content)element3);
        }
        return new Document(element);
    }

    private static Element buildElement(InstalledDocSetItem installedDocSetItem, String string) {
        Element element;
        Element element2 = new Element(string);
        Element element3 = new Element("display-name");
        element3.setText(installedDocSetItem.getDisplayName());
        element2.addContent((Content)element3);
        Element element4 = new Element("help-location");
        element4.setText(installedDocSetItem.getHelpLoc());
        element2.addContent((Content)element4);
        Element element5 = new Element("short-name");
        element5.setText(installedDocSetItem.getShortName());
        element2.addContent((Content)element5);
        String string2 = installedDocSetItem.getBaseProductShortName();
        if (string2 != null && !string2.isEmpty()) {
            element = new Element("base-short-name");
            element.setText(string2);
            element2.addContent((Content)element);
        }
        if ((element = installedDocSetItem.getAltShortNames()) != null && !element.isEmpty()) {
            for (String string3 : element) {
                Element element6 = new Element("alt-short-name");
                element6.setText(string3);
                element2.addContent((Content)element6);
            }
        }
        return element2;
    }

    Document getDocument() {
        return this.document;
    }
}

