/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.Command;
import com.mathworks.install.command.ProductVersionFinder;
import com.mathworks.instutil.Arch;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.Registry;
import com.mathworks.instutil.VersionUtils;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;

public class InsertPathIntoSystemPathCommand
implements Command {
    private static final String ENVIRONMENT_SUBKEY = "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment";
    private static final String PATH_KEY = "Path";
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private final String appName;
    private final Registry registry;
    private final String relativePathToInsert;
    private final AppLogger logger;
    private ProductVersionFinder productVersionFinder;
    private final Platform platform;

    public InsertPathIntoSystemPathCommand(String string, String string2, Registry registry, AppLogger appLogger, Platform platform) {
        this(string, string2, registry, appLogger, new ProductVersionFinderImpl(), platform);
    }

    public InsertPathIntoSystemPathCommand(String string, String string2, Registry registry, AppLogger appLogger, ProductVersionFinder productVersionFinder, Platform platform) {
        this.relativePathToInsert = string;
        this.appName = string2;
        this.registry = registry;
        this.logger = appLogger;
        this.productVersionFinder = this.appName.isEmpty() ? new NoOpProductVersionFinder() : productVersionFinder;
        this.platform = platform;
    }

    @Override
    public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        String string2 = this.getPathEntryToInsertOrRemove(file);
        String string3 = this.getAppVersion(string, file);
        this.addEntryToPathBeforeOlderAndEqualAppVersions(string2, string3);
        InsertPathIntoSystemPathCommand.SendMessageAboutEnvironment();
    }

    private String getAppVersion(String string, File file) {
        String string2 = this.getAppExePath(string, file);
        return this.productVersionFinder.getVerResource(string2);
    }

    private String getPathEntryToInsertOrRemove(File file) {
        return new File(file.getAbsolutePath(), this.relativePathToInsert).getAbsolutePath();
    }

    private String getAppExePath(String string, File file) {
        return new File(InsertPathIntoSystemPathCommand.getBinArchFolder(string, file), this.appName).getAbsolutePath();
    }

    private static File getBinArchFolder(String string, File file) {
        return new File(InsertPathIntoSystemPathCommand.getBinFolder(file), string);
    }

    private static File getBinFolder(File file) {
        return new File(file, "bin");
    }

    @Override
    public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        String string2 = this.getPathFromRegistry();
        String string3 = this.getPathEntryToInsertOrRemove(file);
        this.removeEntryFromPathAndUpdateRegistry(string2, string3);
        InsertPathIntoSystemPathCommand.SendMessageAboutEnvironment();
        String string4 = this.getPathFromRegistry();
        if (!string4.equalsIgnoreCase(string2)) {
            this.logger.logMsg("Original path was: " + string2);
            this.logger.logMsg("New path is:  " + string4);
        } else {
            this.logger.logMsg("Tried to remove the bin folder from the system path, but it did not exist.\\n");
        }
    }

    private static native void SendMessageAboutEnvironment();

    private String getPathFromRegistry() {
        String string = this.registry.getRegKeyValue("HKEY_LOCAL_MACHINE", ENVIRONMENT_SUBKEY, PATH_KEY);
        return string == null ? "" : string;
    }

    void removeEntryFromPathAndUpdateRegistry(String string, String string2) {
        String string3 = string == null ? null : this.rmDirFromPathStr(string2);
        this.registry.setRegKeyValue("HKEY_LOCAL_MACHINE", ENVIRONMENT_SUBKEY, PATH_KEY, string3);
    }

    private void updateRegistry(String string) {
        this.registry.setRegKeyValue("HKEY_LOCAL_MACHINE", ENVIRONMENT_SUBKEY, PATH_KEY, string);
    }

    void addEntryToPathBeforeOlderAndEqualAppVersions(String string, String string2) {
        this.logger.logMsg("Modify the system path if necessary.");
        if (!this.entryAlreadyInPath(string)) {
            String[] stringArray = this.findEntriesInPathWithOlderOrEqualAppVersions(string2);
            String string3 = this.addEntryToPathBefore(string, stringArray);
            this.logger.logMsg("New Path : " + string3);
            this.updateRegistryIfPathIsNotTooLong(string3);
        }
    }

    private void updateRegistryIfPathIsNotTooLong(String string) {
        if (string != null && string.length() > this.platform.getMaxPathLength()) {
            this.logger.logMsg("Can not set system path because path is too long.");
        } else {
            this.updateRegistry(string);
        }
    }

    private String getValueWithSemicolon() {
        String string = this.getPathFromRegistry();
        if (string.endsWith(PATH_SEPARATOR)) {
            return string;
        }
        return string + PATH_SEPARATOR;
    }

    private String rmDirFromPathStr(String string) {
        String string2 = this.getValueWithSemicolon();
        string2 = InsertPathIntoSystemPathCommand.removeEntryFromPath(string, string2);
        return this.trimTrailingSemiColonIfNecessary(string2);
    }

    private static String removeEntryFromPath(String string, String string2) {
        String string3 = string2;
        String string4 = string + PATH_SEPARATOR;
        Locale locale = Locale.getDefault();
        String string5 = string3.toLowerCase(locale);
        String string6 = string4.toLowerCase(locale);
        while (string5.contains(string6)) {
            string3 = InsertPathIntoSystemPathCommand.removeOneInstanceOfElement(string3, string5, string6);
            string5 = string3.toLowerCase(locale);
        }
        return string3;
    }

    private String trimTrailingSemiColonIfNecessary(String string) {
        if (this.startedWithTrailingSemiColon()) {
            return string;
        }
        return InsertPathIntoSystemPathCommand.trimTrailingSemiColon(string);
    }

    private boolean startedWithTrailingSemiColon() {
        String string = this.getPathFromRegistry();
        return string.endsWith(PATH_SEPARATOR);
    }

    private static String trimTrailingSemiColon(String string) {
        if (string.endsWith(PATH_SEPARATOR)) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static String removeOneInstanceOfElement(String string, String string2, String string3) {
        String string4 = string;
        if (string2.endsWith(string3)) {
            string4 = InsertPathIntoSystemPathCommand.removeElementFromEndOfPath(string4, string2, string3);
        } else {
            int n = string2.indexOf(string3);
            if (n > -1) {
                String string5 = string4.substring(0, n);
                String string6 = string4.substring(n + string3.length());
                string4 = string5 + string6;
            }
        }
        return string4;
    }

    private static String removeElementFromEndOfPath(String string, String string2, String string3) {
        int n = string2.lastIndexOf(string3);
        string = string.substring(0, n);
        return string;
    }

    private String[] findEntriesInPathWithOlderOrEqualAppVersions(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.getPathEntries()) {
            String string3 = this.getVersion(string2);
            if ("".equalsIgnoreCase(string3)) continue;
            this.logger.logMsg("Found " + this.appName + " " + string3 + " in " + string2);
            if (!InsertPathIntoSystemPathCommand.versionOfEntryOnPathIsOlderOrEqualTo(string3, string)) continue;
            arrayList.add(string2);
        }
        return this.getPathEntriesWithSameInstallationRoot(arrayList);
    }

    private static boolean versionOfEntryOnPathIsOlderOrEqualTo(String string, String string2) {
        return VersionUtils.compareVersionNumbers((String)string2, (String)string) > -1;
    }

    private String[] getPathEntriesWithSameInstallationRoot(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            for (String string2 : this.getPathEntries()) {
                if (!string2.startsWith(InsertPathIntoSystemPathCommand.getParentPath(string))) continue;
                arrayList.add(string2);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String getParentPath(String string) {
        String string2 = FilenameUtils.normalizeNoEndSeparator((String)string);
        int n = string2.lastIndexOf(File.separator);
        if (n >= 0) {
            return string2.substring(0, string2.lastIndexOf(File.separator));
        }
        return string2;
    }

    private String addEntryToPathBefore(String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (String string2 : this.getPathEntries()) {
            if (!bl) {
                for (String string3 : stringArray) {
                    if (!string2.equalsIgnoreCase(string3)) continue;
                    InsertPathIntoSystemPathCommand.appendElement(stringBuilder, string);
                    bl = true;
                    break;
                }
            }
            InsertPathIntoSystemPathCommand.appendElement(stringBuilder, string2);
        }
        if (!bl) {
            InsertPathIntoSystemPathCommand.appendElement(stringBuilder, string);
        }
        return stringBuilder.toString();
    }

    private static void appendElement(StringBuilder stringBuilder, String string) {
        InsertPathIntoSystemPathCommand.appendPathSeparatorIfNecessary(stringBuilder);
        stringBuilder.append(string);
    }

    private static void appendPathSeparatorIfNecessary(StringBuilder stringBuilder) {
        if (stringBuilder.lastIndexOf(PATH_SEPARATOR) < stringBuilder.length() - 1) {
            stringBuilder.append(PATH_SEPARATOR);
        }
    }

    private boolean entryAlreadyInPath(String string) {
        for (String string2 : this.getPathEntries()) {
            if (!FilenameUtils.normalizeNoEndSeparator((String)string).equalsIgnoreCase(FilenameUtils.normalizeNoEndSeparator((String)string2))) continue;
            return true;
        }
        return false;
    }

    private String[] getPathEntries() {
        return this.getPathFromRegistry().split(PATH_SEPARATOR);
    }

    private String getVersion(String string) {
        String string2 = InsertPathIntoSystemPathCommand.appendFileSeparatorIfNecessary(string);
        String string3 = "";
        if (InsertPathIntoSystemPathCommand.isBinFolder(string2) && (string3 = this.getVersionOnPath(string2, Arch.WIN32.getString())).isEmpty()) {
            string3 = this.getVersionOnPath(string2, Arch.WIN64.getString());
        }
        return string3;
    }

    private static boolean isBinFolder(String string) {
        return string.endsWith("bin" + File.separator);
    }

    private String getVersionOnPath(String string, String string2) {
        return this.productVersionFinder.getVerResource(string + string2 + File.separator + this.appName);
    }

    private static String appendFileSeparatorIfNecessary(String string) {
        if (string.endsWith(File.separator)) {
            return string;
        }
        return string + File.separator;
    }

    static native boolean GetProductVersion(String var0, StringBuffer var1);

    private class NoOpProductVersionFinder
    implements ProductVersionFinder {
        private NoOpProductVersionFinder() {
        }

        @Override
        public String getVerResource(String string) {
            return "";
        }
    }

    private static class ProductVersionFinderImpl
    implements ProductVersionFinder {
        private ProductVersionFinderImpl() {
        }

        @Override
        public String getVerResource(String string) {
            StringBuffer stringBuffer = new StringBuffer("");
            boolean bl = InsertPathIntoSystemPathCommand.GetProductVersion(string, stringBuffer);
            String string2 = stringBuffer.toString();
            string2 = string2.replaceAll("[^\\d.]", "");
            if (bl && "".equalsIgnoreCase(string2)) {
                string2 = "0";
            }
            return string2;
        }
    }
}

