/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.archive.zip.commonscompress;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;

public class ArchiveEntryAdapter
implements ArchiveEntry {
    private final ArchiveEntry innerArchiveEntry;
    private static final int DEFAULT_FILE_PERMISSIONS = 420;
    private static final int BUF_SIZE = 2048;

    public ArchiveEntryAdapter(ArchiveEntry archiveEntry) {
        this.innerArchiveEntry = archiveEntry;
    }

    public String getName() {
        return this.innerArchiveEntry.getName();
    }

    public long getSize() {
        return this.innerArchiveEntry.getSize();
    }

    public boolean isDirectory() {
        return this.innerArchiveEntry.isDirectory();
    }

    public Date getLastModifiedDate() {
        return this.innerArchiveEntry.getLastModifiedDate();
    }

    public boolean isSymlink() {
        boolean bl = false;
        if (this.innerArchiveEntry instanceof ZipArchiveEntry) {
            int n = ((ZipArchiveEntry)this.innerArchiveEntry).getUnixMode();
            bl = (n & 0xA000) == 40960;
        } else if (this.innerArchiveEntry instanceof TarArchiveEntry) {
            bl = ((TarArchiveEntry)this.innerArchiveEntry).isSymbolicLink();
        }
        return bl;
    }

    public String getLinkName(InputStream inputStream) throws IOException {
        String string = "";
        if (this.innerArchiveEntry instanceof ZipArchiveEntry) {
            byte[] byArray = new byte[2048];
            int n = inputStream.read(byArray, 0, 2048);
            if (n < 0) {
                throw new IOException(this.getName() + ": archive entry is specified as a symbolic link but does not contain a target.");
            }
            string = new String(byArray, 0, n);
        } else if (this.innerArchiveEntry instanceof TarArchiveEntry) {
            string = ((TarArchiveEntry)this.innerArchiveEntry).getLinkName();
        }
        return string;
    }

    public int getPermissions() {
        int n = 0;
        if (this.innerArchiveEntry instanceof ZipArchiveEntry) {
            int n2 = ((ZipArchiveEntry)this.innerArchiveEntry).getUnixMode();
            n = n2 & 0xFFF;
            if (n == 0) {
                n = 420;
            }
        } else if (this.innerArchiveEntry instanceof TarArchiveEntry) {
            n = ((TarArchiveEntry)this.innerArchiveEntry).getMode();
        }
        return n;
    }

    public long getTime() {
        return this.innerArchiveEntry.getLastModifiedDate().getTime();
    }
}

