/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.google.inject.Inject;
import com.mathworks.install.InputStreamProvider;
import com.mathworks.install.XMLParseException;
import com.mathworks.install.XMLParser;
import com.mathworks.install.XMLParserFactory;
import com.mathworks.install.input.ComponentSourceProvider;
import com.mathworks.install.input.Contents;
import com.mathworks.install.input.XMLInstallationFileParser;
import com.mathworks.instutil.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

final class XMLInstallationFileParserImpl
implements XMLInstallationFileParser {
    private final XMLParserFactory parserFactory;
    private final Platform platform;

    @Inject
    XMLInstallationFileParserImpl(XMLParserFactory xMLParserFactory, Platform platform) {
        this.parserFactory = xMLParserFactory;
        this.platform = platform;
    }

    private XMLParser createParser(ComponentSourceProvider componentSourceProvider) {
        return this.parserFactory.createParser(componentSourceProvider);
    }

    @Override
    public Contents parseContents(InputStream inputStream) throws IOException, XMLParseException {
        Element element = XMLInstallationFileParserImpl.getRootElement(inputStream);
        return XMLInstallationFileParserImpl.getContents(element);
    }

    private static Element getRootElement(InputStream inputStream) throws IOException, XMLParseException {
        Document document;
        try {
            document = new SAXBuilder().build(inputStream);
        }
        catch (JDOMException jDOMException) {
            throw new XMLParseException(jDOMException);
        }
        return document.getRootElement();
    }

    private static Contents getContents(Element element) {
        final ArrayList<String> arrayList = new ArrayList<String>();
        final ArrayList<String> arrayList2 = new ArrayList<String>();
        final ArrayList<String> arrayList3 = new ArrayList<String>();
        if ("contents".equalsIgnoreCase(element.getName())) {
            for (Object e : element.getChildren("definitions")) {
                arrayList.add(((Element)e).getText());
            }
            for (Object e : element.getChildren("componentFiles")) {
                arrayList2.add(((Element)e).getText());
            }
            for (Object e : element.getChildren("manifests")) {
                arrayList3.add(((Element)e).getText());
            }
        }
        return new Contents(){

            @Override
            public String[] getDefinitions() {
                return arrayList.toArray(new String[arrayList.size()]);
            }

            @Override
            public String[] getComponentFiles() {
                return arrayList2.toArray(new String[arrayList2.size()]);
            }

            @Override
            public String[] getManifests() {
                return arrayList3.toArray(new String[arrayList3.size()]);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readInDefinition(InputStreamProvider inputStreamProvider, ComponentSourceProvider componentSourceProvider) throws IOException, XMLParseException {
        InputStream inputStream = null;
        try {
            inputStream = inputStreamProvider.getInputStream();
            if (inputStream != null) {
                XMLParser xMLParser = this.createParser(componentSourceProvider);
                xMLParser.parse(IOUtils.toByteArray((InputStream)inputStream), this.platform.getArchString());
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }
}

