/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.google.inject.Inject;
import com.mathworks.install.ComponentContainer;
import com.mathworks.install.ComponentData;
import com.mathworks.install.InstallableProduct;
import com.mathworks.install.InstallableProductImpl;
import com.mathworks.install.Product;
import com.mathworks.install.ProductContainer;
import com.mathworks.install.ProductImpl;
import com.mathworks.install.ProductState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

final class ProductContainerImpl
implements ProductContainer {
    private final Map<String, Product> productFlyweightMap = new HashMap<String, Product>();
    private Map<Product, InstallableProductImpl> productToInstallableProductMap = new HashMap<Product, InstallableProductImpl>();
    private final ComponentContainer componentContainer;

    @Inject
    ProductContainerImpl(ComponentContainer componentContainer) {
        this.componentContainer = componentContainer;
    }

    @Override
    public synchronized InstallableProduct[] getInstallableProducts() {
        Collection<InstallableProduct> collection = ProductContainerImpl.filter(this.productToInstallableProductMap.values());
        return collection.toArray(new InstallableProduct[this.productToInstallableProductMap.values().size()]);
    }

    @Override
    public synchronized InstallableProduct[] getInstallableProducts(String string) {
        LinkedHashSet<InstallableProductImpl> linkedHashSet = new LinkedHashSet<InstallableProductImpl>();
        for (InstallableProductImpl installableProductImpl : this.productToInstallableProductMap.values()) {
            if (!installableProductImpl.getProductData().getArchitecture().equalsIgnoreCase(string)) continue;
            linkedHashSet.add(installableProductImpl);
        }
        Collection<InstallableProduct> collection = ProductContainerImpl.filter(linkedHashSet);
        return collection.toArray(new InstallableProduct[collection.size()]);
    }

    private static Collection<InstallableProduct> filter(Collection<InstallableProductImpl> collection) {
        ArrayList<InstallableProduct> arrayList = new ArrayList<InstallableProduct>();
        for (InstallableProductImpl installableProductImpl : collection) {
            if (installableProductImpl.getState() != ProductState.READY_TO_INSTALL) continue;
            arrayList.add(installableProductImpl);
        }
        return arrayList;
    }

    @Override
    public synchronized InstallableProduct[] getInstallableProductsForMultiplePlatforms(String[] stringArray) {
        HashMap<String, InstallableProductImpl> hashMap = new HashMap<String, InstallableProductImpl>();
        for (InstallableProductImpl installableProductImpl : this.productToInstallableProductMap.values()) {
            for (String string : stringArray) {
                if (!installableProductImpl.getProductData().getArchitecture().equalsIgnoreCase(string)) continue;
                Product product = installableProductImpl.getProductData();
                String string2 = product.getNameVersionReleaseAndReleaseDescription() + " " + product.getProductNumber();
                InstallableProductImpl installableProductImpl2 = (InstallableProductImpl)hashMap.get(string2);
                if (installableProductImpl2 == null) {
                    hashMap.put(string2, installableProductImpl);
                    continue;
                }
                if (installableProductImpl2.getDownloadSize() != 0L || installableProductImpl.getDownloadSize() == 0L) continue;
                hashMap.remove(string2);
                hashMap.put(string2, installableProductImpl);
            }
        }
        Collection<InstallableProduct> collection = ProductContainerImpl.filter(hashMap.values());
        return collection.toArray(new InstallableProduct[collection.size()]);
    }

    @Override
    public synchronized void add(Product product, ComponentData[] componentDataArray, String string, String string2, String[] stringArray, boolean bl, String string3) {
        if (ProductContainerImpl.supportsPlatform(stringArray, string)) {
            InstallableProductImpl installableProductImpl;
            InstallableProductImpl installableProductImpl2 = this.productToInstallableProductMap.get(product);
            if (installableProductImpl2 == null) {
                installableProductImpl = new InstallableProductImpl(product, componentDataArray, this.componentContainer);
                installableProductImpl.addXML(string3, string2);
                this.productToInstallableProductMap.put(product, installableProductImpl);
            } else {
                installableProductImpl = installableProductImpl2;
                installableProductImpl.addComponents(componentDataArray);
                installableProductImpl.addXML(string3, string2);
            }
            if (!bl) {
                ProductContainerImpl.configureState(installableProductImpl, string, string2);
            }
        }
    }

    private static boolean supportsPlatform(String[] stringArray, String string) {
        if (stringArray.length == 0) {
            return true;
        }
        for (String string2 : stringArray) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    private static void configureState(InstallableProductImpl installableProductImpl, String string, String string2) {
        if (installableProductImpl.getState() == ProductState.NOTHING) {
            if (ProductContainerImpl.isCommon(string2)) {
                installableProductImpl.setState(ProductState.COMMON_ONLY);
            } else if (ProductContainerImpl.isArch(string, string2)) {
                installableProductImpl.setState(ProductState.ARCH_ONLY);
            }
        } else if (installableProductImpl.getState() == ProductState.ARCH_ONLY && ProductContainerImpl.isCommon(string2) || installableProductImpl.getState() == ProductState.COMMON_ONLY && ProductContainerImpl.isArch(string, string2)) {
            installableProductImpl.setState(ProductState.READY_TO_INSTALL);
        }
    }

    private static boolean isArch(String string, String string2) {
        return string2.contains(string);
    }

    private static boolean isCommon(String string) {
        return ProductContainerImpl.isArch("common", string);
    }

    @Override
    public synchronized void merge(Product product, ComponentData[] componentDataArray, Product[] productArray, String[] stringArray, String[] stringArray2, String string, String string2) {
        InstallableProductImpl installableProductImpl = this.productToInstallableProductMap.get(product);
        if (installableProductImpl != null) {
            installableProductImpl.addComponents(componentDataArray);
            installableProductImpl.setRequiredProds(productArray);
            installableProductImpl.setReleaseFamily(string);
            installableProductImpl.setReleaseDescription(string2);
            installableProductImpl.setInstallerTypeUsage(stringArray2);
        }
    }

    @Override
    public synchronized Product createProduct(String string, int n, String string2, String string3, boolean bl, String string4, String string5, String string6) {
        String string7 = string + " " + n + " " + string3 + " " + string4 + " " + string5 + " " + string6;
        Product product = this.productFlyweightMap.get(string7);
        if (product == null) {
            product = new ProductImpl(string, n, string2, string3, bl, string4, string5, string6);
            this.productFlyweightMap.put(string7, product);
        }
        return product;
    }

    @Override
    public synchronized InstallableProduct getInstallableProduct(Product product) {
        return this.productToInstallableProductMap.get(product);
    }

    @Override
    public synchronized InstallableProduct getInstallableProductByNameVersionReleaseAndReleaseDescription(String string) {
        for (Product product : this.productToInstallableProductMap.keySet()) {
            if (!product.getNameVersionReleaseAndReleaseDescription().equalsIgnoreCase(string)) continue;
            return this.productToInstallableProductMap.get(product);
        }
        return null;
    }

    @Override
    public synchronized InstallableProduct getInstallableProduct(String string, String string2) {
        for (Product product : this.productToInstallableProductMap.keySet()) {
            if (!product.getNameVersionReleaseAndReleaseDescription().equalsIgnoreCase(string) || !product.getArchitecture().equalsIgnoreCase(string2)) continue;
            return this.productToInstallableProductMap.get(product);
        }
        return null;
    }
}

