/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.mathworks.install.AbstractSoftwareManagerBuilder;
import com.mathworks.install.CorruptedArchivesException;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallableProduct;
import com.mathworks.install.InstalledProductData;
import com.mathworks.install.Installer;
import com.mathworks.install.InstallerBuilder;
import com.mathworks.install.InstallerFactory;
import com.mathworks.install.InvalidFikException;
import com.mathworks.install.InvalidInstallationFolderException;
import com.mathworks.install.ProductContainer;
import com.mathworks.install.ValidatedFik;
import com.mathworks.install.ValidatedFikImpl;
import com.mathworks.install.WrongReleaseFikException;
import com.mathworks.install.XMLParseException;
import com.mathworks.install.input.InstallationInputFileFactory;
import com.mathworks.install.input.XMLInstallationFileParser;
import com.mathworks.install.resources.InstallResourceKeys;
import com.mathworks.instutil.ExecutorServiceManager;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.JNIException;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;

final class InstallerBuilderImpl
extends AbstractSoftwareManagerBuilder
implements InstallerBuilder {
    private static final String[] CORE_NATIVE_LIBS = new String[]{"instutil", "mwinstall"};
    private static final int NR_CODES = 250;
    private final String arch;
    private final ProductContainer productContainer;
    private final InstallerFactory installerFactory;
    private final InstalledProductData fileList;
    private final InstallConfiguration installConfiguration;

    InstallerBuilderImpl(String string, ProductContainer productContainer, InstallerFactory installerFactory, InstalledProductData installedProductData, ExecutorServiceManager executorServiceManager, InstallationInputFileFactory installationInputFileFactory, AppLogger appLogger, InstallConfiguration installConfiguration, XMLInstallationFileParser xMLInstallationFileParser) {
        super(executorServiceManager, installationInputFileFactory, appLogger, xMLInstallationFileParser);
        this.arch = string;
        this.productContainer = productContainer;
        this.installerFactory = installerFactory;
        this.fileList = installedProductData;
        this.installConfiguration = installConfiguration;
    }

    @Override
    public void loadNativeLibrary(String string) throws JNIException {
        for (String string2 : CORE_NATIVE_LIBS) {
            InstallerBuilderImpl.loadNativeLib(string, string2);
        }
    }

    private static void loadNativeLib(String string, String string2) throws JNIException {
        String string3 = System.mapLibraryName(string2);
        String string4 = new File(string, string3).getAbsolutePath();
        try {
            System.load(string4);
        }
        catch (Throwable throwable) {
            throw new JNIException(throwable);
        }
    }

    @Override
    public Installer buildInstaller(ValidatedFik validatedFik) {
        ArrayList<InstallableProduct> arrayList = new ArrayList<InstallableProduct>();
        for (InstallableProduct installableProduct : this.productContainer.getInstallableProducts(this.arch)) {
            if (!installableProduct.isSupported(this.installConfiguration, validatedFik)) continue;
            arrayList.add(installableProduct);
        }
        Installer installer = this.installerFactory.createInstaller(this.arch, arrayList.toArray(new InstallableProduct[arrayList.size()]));
        InstallerBuilderImpl.deselectOlderVersionsOfSelectedProducts(installer);
        return installer;
    }

    @Override
    public ValidatedFik validateFik(String string) throws InvalidFikException, WrongReleaseFikException {
        FikData fikData = new FikData();
        int[] nArray = new int[250];
        if (string == null || InstallerBuilderImpl.decipherFIK(string, fikData, nArray) != 0 || !this.checkIncompatibleProductsOnFIK(nArray)) {
            throw new InvalidFikException();
        }
        if (fikData.getPasscodever() < Integer.parseInt(InstutilResourceKeys.PASSCODE.getString(new Object[0]))) {
            throw new WrongReleaseFikException();
        }
        return new ValidatedFikImpl(string, fikData.isDemo(), fikData.isNetwork(), nArray);
    }

    private boolean checkIncompatibleProductsOnFIK(int[] nArray) {
        boolean bl = false;
        for (int n : nArray) {
            if (n != 126) continue;
            bl = true;
            break;
        }
        if (bl) {
            for (int n : nArray) {
                if (n == 126 || n == 0) continue;
                return false;
            }
        }
        return true;
    }

    private void addNewProductsToInstaller(Installer installer, ValidatedFik validatedFik, InstallableProduct ... installableProductArray) {
        List<InstallableProduct> list = Arrays.asList(installableProductArray);
        boolean bl = false;
        for (InstallableProduct installableProduct : this.productContainer.getInstallableProducts(this.arch)) {
            if (list.contains(installableProduct) || !installableProduct.isSupported(this.installConfiguration, validatedFik)) continue;
            installer.addProduct(installableProduct.getProductData());
            bl = true;
        }
        if (bl) {
            InstallerBuilderImpl.deselectOlderVersionsOfSelectedProducts(installer);
        }
    }

    @Override
    public void addArchives(File[] fileArray, Installer installer, ValidatedFik validatedFik) {
        InstallableProduct[] installableProductArray = this.productContainer.getInstallableProducts(this.arch);
        this.startReadingArchives(fileArray);
        try {
            this.finishReadingArchives();
        }
        catch (CorruptedArchivesException corruptedArchivesException) {
            // empty catch block
        }
        this.addNewProductsToInstaller(installer, validatedFik, installableProductArray);
    }

    @Override
    public Installer buildInstallerForUninstaller(File file) throws InvalidInstallationFolderException {
        ArrayList<InstallableProduct> arrayList = new ArrayList<InstallableProduct>();
        for (InstallableProduct installableProduct : this.productContainer.getInstallableProducts(this.arch)) {
            if (!installableProduct.isSupported(this.installConfiguration)) continue;
            arrayList.add(installableProduct);
        }
        Installer installer = this.installerFactory.createUnInstaller(this.arch, arrayList.toArray(new InstallableProduct[arrayList.size()]));
        if (installer.getAvailableProducts().length == 0) {
            throw new InvalidInstallationFolderException(InstallResourceKeys.ERROR_UNINSTALL_NOPRODUCTS_MESSAGE.getString(new Object[0]));
        }
        return installer;
    }

    @Override
    public void loadFileListData(File file) throws IOException, ExecutionException, XMLParseException, InterruptedException {
        this.fileList.loadAllData(file);
    }

    private static native int decipherFIK(String var0, FikData var1, int[] var2);

    private static class FikData {
        private boolean network;
        private boolean demo;
        private int passcodeVersion;

        private FikData() {
        }

        public int getPasscodever() {
            return this.passcodeVersion;
        }

        public void setPasscodever(int n) {
            this.passcodeVersion = n;
        }

        public boolean isDemo() {
            return this.demo;
        }

        public void setDemo(boolean bl) {
            this.demo = bl;
        }

        public boolean isNetwork() {
            return this.network;
        }

        public void setNetwork(boolean bl) {
            this.network = bl;
        }
    }
}

