/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.mathworks.install.AbstractSoftwareManagerBuilder;
import com.mathworks.install.ComponentContainer;
import com.mathworks.install.Downloader;
import com.mathworks.install.DownloaderBuilder;
import com.mathworks.install.DownloaderImpl;
import com.mathworks.install.InstallableProduct;
import com.mathworks.install.InstallerDownloadInfoContainer;
import com.mathworks.install.ProductContainer;
import com.mathworks.install.ProductDownloader;
import com.mathworks.install.archive.ArchiveInputStreamExtractor;
import com.mathworks.install.input.InstallationInputFileFactory;
import com.mathworks.install.input.XMLInstallationFileParser;
import com.mathworks.instutil.ExecutorServiceManager;
import com.mathworks.instutil.InstallerDownloadURLInfo;
import com.mathworks.instutil.VersionUtils;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.internal.dws.client.EntitledProduct;
import com.mathworks.webproxy.ProxyConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;

public class DownloaderBuilderImpl
extends AbstractSoftwareManagerBuilder
implements DownloaderBuilder {
    private final String[] archStrings;
    private final ProductContainer productContainer;
    private final ProductDownloader productDownloader;
    private final Properties properties;
    private final AppLogger appLogger;
    private final ComponentContainer componentContainer;
    private final com.mathworks.instutil.Downloader downloader;
    private final ProxyConfiguration proxyConfiguration;
    private final ArchiveInputStreamExtractor archiveInputStreamExtractor;
    private final InstallerDownloadInfoContainer installerDownloadInfoContainer;

    DownloaderBuilderImpl(String[] stringArray, ProductContainer productContainer, ExecutorServiceManager executorServiceManager, InstallationInputFileFactory installationInputFileFactory, AppLogger appLogger, ComponentContainer componentContainer, com.mathworks.instutil.Downloader downloader, ProxyConfiguration proxyConfiguration, ArchiveInputStreamExtractor archiveInputStreamExtractor, ProductDownloader productDownloader, Properties properties, InstallerDownloadInfoContainer installerDownloadInfoContainer, XMLInstallationFileParser xMLInstallationFileParser) {
        super(executorServiceManager, installationInputFileFactory, appLogger, xMLInstallationFileParser);
        this.archStrings = stringArray;
        this.productContainer = productContainer;
        this.appLogger = appLogger;
        this.componentContainer = componentContainer;
        this.downloader = downloader;
        this.proxyConfiguration = proxyConfiguration;
        this.archiveInputStreamExtractor = archiveInputStreamExtractor;
        this.productDownloader = productDownloader;
        this.installerDownloadInfoContainer = installerDownloadInfoContainer;
        this.properties = properties;
    }

    @Override
    public String[] getAllInstallerNames() {
        return this.installerDownloadInfoContainer.getAllInstallerNames();
    }

    @Override
    public Downloader buildDownloader(InstallerDownloadURLInfo[] installerDownloadURLInfoArray, EntitledProduct[] entitledProductArray) {
        ArrayList<InstallableProduct> arrayList = new ArrayList<InstallableProduct>();
        for (InstallableProduct installableProduct : this.productContainer.getInstallableProductsForMultiplePlatforms(this.archStrings)) {
            this.addOnlyEntitledProducts(entitledProductArray, arrayList, installableProduct);
        }
        this.installerDownloadInfoContainer.matchURL(installerDownloadURLInfoArray);
        DownloaderImpl downloaderImpl = new DownloaderImpl(this.archStrings, arrayList.toArray(new InstallableProduct[arrayList.size()]), this.productContainer, this.appLogger, this.componentContainer, this.downloader, this.proxyConfiguration, this.archiveInputStreamExtractor, this.productDownloader, this.properties, this.installerDownloadInfoContainer);
        DownloaderBuilderImpl.deselectOlderVersionsOfSelectedProducts(downloaderImpl);
        return downloaderImpl;
    }

    @Override
    public Downloader buildDownloader() {
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, this.productContainer.getInstallableProductsForMultiplePlatforms(this.archStrings));
        DownloaderImpl downloaderImpl = new DownloaderImpl(this.archStrings, arrayList.toArray(new InstallableProduct[arrayList.size()]), this.productContainer, this.appLogger, this.componentContainer, this.downloader, this.proxyConfiguration, this.archiveInputStreamExtractor, this.productDownloader, this.properties, this.installerDownloadInfoContainer);
        DownloaderBuilderImpl.deselectOlderVersionsOfSelectedProducts(downloaderImpl);
        return downloaderImpl;
    }

    private void addOnlyEntitledProducts(EntitledProduct[] entitledProductArray, Collection<InstallableProduct> collection, InstallableProduct installableProduct) {
        for (EntitledProduct entitledProduct : entitledProductArray) {
            if (entitledProduct.getBitNumber() != installableProduct.getProductData().getProductNumber() || VersionUtils.compareVersionNumbers((String)entitledProduct.getVersion(), (String)installableProduct.getProductData().getVersion()) <= -1) continue;
            collection.add(installableProduct);
        }
    }
}

