/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabinstaller;

import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallConfigurationAdapter;
import com.mathworks.install.InstallConfigurationPersistence;
import com.mathworks.install.InstallConfigurationPersistenceImpl;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.instutil.logging.AppLoggerImpl;
import com.mathworks.instutil.logging.LoggingFilterStrategy;
import com.mathworks.instutil.logging.PassThroughLoggingFilterStrategyImpl;
import com.mathworks.instutil.properties.ApplicationInputFileReader;
import com.mathworks.instutil.properties.ApplicationInputFileReaderImpl;
import com.mathworks.wizard.ArgumentsParser;
import com.mathworks.wizard.ArgumentsParserImpl;
import com.mathworks.wizard.PropertyKey;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public final class ActivationLauncher {
    private final InstallConfigurationPersistence installConfigurationPersistence;
    private InstallConfiguration defaultInstallConfiguration;
    private final ArgumentsParser argumentsParser;

    ActivationLauncher() {
        this((InstallConfigurationPersistence)new InstallConfigurationPersistenceImpl(), (InstallConfiguration)new InstallConfigurationAdapter(), (ArgumentsParser)new ArgumentsParserImpl((ApplicationInputFileReader)new ApplicationInputFileReaderImpl(), (AppLogger)new AppLoggerImpl(), (LoggingFilterStrategy)new PassThroughLoggingFilterStrategyImpl()));
    }

    ActivationLauncher(InstallConfigurationPersistence installConfigurationPersistence, InstallConfiguration installConfiguration, ArgumentsParser argumentsParser) {
        this.installConfigurationPersistence = installConfigurationPersistence;
        this.defaultInstallConfiguration = installConfiguration;
        this.argumentsParser = argumentsParser;
    }

    public void run(String[] stringArray) {
        InstallConfiguration installConfiguration;
        try {
            Properties properties = this.argumentsParser.parse(stringArray);
            installConfiguration = this.loadConfigurationFromInstallationRoot(properties);
        }
        catch (Exception exception) {
            installConfiguration = this.defaultInstallConfiguration;
        }
        installConfiguration.activateInstallation(stringArray);
    }

    private InstallConfiguration loadConfigurationFromInstallationRoot(Properties properties) throws IOException, ClassNotFoundException {
        File file = new File(PropertyKey.ROOTDIR.getProperty(properties));
        return this.installConfigurationPersistence.load(file);
    }

    public static void main(String[] stringArray) {
        ActivationLauncher activationLauncher = new ActivationLauncher();
        activationLauncher.run(stringArray);
    }
}

