/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.urlmanager;

import com.mathworks.brsanthu.dataexporter.DataExporter;
import com.mathworks.brsanthu.dataexporter.model.AlignType;
import com.mathworks.brsanthu.dataexporter.model.StringColumn;
import com.mathworks.brsanthu.dataexporter.model.json.JsonExportOptions;
import com.mathworks.brsanthu.dataexporter.model.json.JsonExporter;
import com.mathworks.brsanthu.dataexporter.output.csv.CsvExportOptions;
import com.mathworks.brsanthu.dataexporter.output.csv.CsvExporter;
import com.mathworks.brsanthu.dataexporter.output.html.HtmlExportOptions;
import com.mathworks.brsanthu.dataexporter.output.html.HtmlExporter;
import com.mathworks.brsanthu.dataexporter.output.texttable.TextTableExportOptions;
import com.mathworks.brsanthu.dataexporter.output.texttable.TextTableExportStyle;
import com.mathworks.brsanthu.dataexporter.output.texttable.TextTableExporter;
import com.mathworks.brsanthu.dataexporter.output.xml.XmlExportOptions;
import com.mathworks.brsanthu.dataexporter.output.xml.XmlExporter;
import com.mathworks.webservices.urlmanager.MissingUrlKeyException;
import com.mathworks.webservices.urlmanager.ReleaseEnv;
import com.mathworks.webservices.urlmanager.UrlManagerFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class UrlManager {
    public static final String CLOUD_CENTER_SERVICE = Service.CLOUD_CENTER_SERVICE.getServiceId();
    public static final String CONTENT_SERVICE = Service.CONTENT_SERVICE.getServiceId();
    public static final String DOWNLOADS_SERVICE = Service.DOWNLOADS_SERVICE.getServiceId();
    public static final String MCR_SERVICE = Service.MCR_SERVICE.getServiceId();
    public static final String LOGIN_SERVICE = Service.LOGIN_SERVICE.getServiceId();
    public static final String LICENSE_SERVICE = Service.LICENSE_SERVICE.getServiceId();
    public static final String ACTIVATION_SERVICE = Service.ACTIVATION_SERVICE.getServiceId();
    public static final String STUDENT_ACTIVATION_SERVICE = Service.STUDENT_ACTIVATION_SERVICE.getServiceId();
    public static final String SEGV_SERVICE = Service.SEGV_SERVICE.getServiceId();
    public static final String SERVICE_REQUEST_SERVICE = Service.SERVICE_REQUEST_SERVICE.getServiceId();
    public static final String MATHWORKS_DOT_COM = Service.MATHWORKS_DOT_COM.getServiceId();
    public static final String USAGE_DATA_SERVICE = Service.USAGE_DATA_SERVICE.getServiceId();
    public static final String GDS = Service.GDS.getServiceId();
    public static final String GDS_JOBS = Service.GDS_JOBS.getServiceId();
    public static final String UDC = Service.UDC.getServiceId();
    public static final String UDCPING = Service.UDCPING.getServiceId();
    public static final String SSID = Service.SSID.getServiceId();
    public static final String APS_BROKER_WEBSOCKET = Service.APS_BROKER_WEBSOCKET.getServiceId();
    protected Properties urlMap = null;

    public abstract String getUrl(String var1, boolean var2);

    public abstract String getUrl(String var1);

    public String getUrl(Service service, boolean refreshUrlMap) {
        return this.getUrl(service.getServiceId(), refreshUrlMap);
    }

    public String getUrl(Service service) {
        return this.getUrl(service.getServiceId());
    }

    public abstract List<String> getUrlList(String var1, boolean var2);

    public abstract List<String> getUrlList(String var1);

    public List<String> getUrlList(Service service, boolean refreshMap) {
        return this.getUrlList(service.getServiceId(), refreshMap);
    }

    public List<String> getUrlList(Service service) {
        return this.getUrlList(service.getServiceId());
    }

    public static void main(String[] args) {
        UrlManager.run(null, args);
    }

    public static String getUrlInfo(String[] args) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        UrlManager.run(stream, args);
        String rval = stream.toString();
        return rval;
    }

    private static void run(OutputStream stream, String ... args) {
        Options options = new Options().addOption("r", "release", true, "matlab release family").addOption("e", "environment", true, "environment, either integ or production").addOption("f", "format", true, "output format, one of: csv, table, xml, json").addOption("t", "test", false, "check each endpoint and make sure it responds").addOption("ph", "proxy_host", true, "proxy host").addOption("pp", "proxy_port", true, "proxy port").addOption("pu", "proxy_username", true, "proxy username").addOption("pw", "proxy_password", true, "proxy password").addOption("h", "help", false, "show help.");
        DataExporter exporter = null;
        UrlManager manager = null;
        BasicParser parser = new BasicParser();
        boolean test_connectivity = false;
        Proxy proxy = null;
        try {
            if (null == args || 0 == args.length) {
                UrlManager.help(options);
                return;
            }
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("h")) {
                UrlManager.help(options);
                return;
            }
            final String release = cmd.getOptionValue("r");
            final String environment = cmd.getOptionValue("e");
            String format = cmd.hasOption("f") ? cmd.getOptionValue("f") : "table";
            test_connectivity = cmd.hasOption("t");
            if (cmd.hasOption("pu") && cmd.hasOption("pw")) {
                final String username = cmd.getOptionValue("pu");
                final String password = cmd.getOptionValue("pw");
                Authenticator authenticator = new Authenticator(){

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(username, password.toCharArray());
                    }
                };
                Authenticator.setDefault(authenticator);
            }
            if (cmd.hasOption("ph") && cmd.hasOption("pp")) {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(cmd.getOptionValue("ph"), (int)new Integer(cmd.getOptionValue("pp"))));
            }
            manager = UrlManagerFactory.createUrlManager(new ReleaseEnv(){

                @Override
                public String getMatlabRelease() {
                    return release;
                }

                @Override
                public String getReleaseEnvironment() {
                    return environment;
                }

                @Override
                public List<String> getSearchPath() {
                    return Arrays.asList(new Object[0]);
                }
            });
            exporter = UrlManager.createExporter(format, stream);
        }
        catch (ParseException e) {
            UrlManager.help(options);
            return;
        }
        manager.setupData(exporter, manager, proxy, test_connectivity);
        exporter.finishExporting();
    }

    private static boolean connect(UrlManager urlManager, Proxy proxy, String serviceId) {
        String urlString = null;
        boolean rval = false;
        try {
            String serviceRoot = urlManager.getUrl(serviceId);
            urlString = MessageFormat.format(urlManager.getUrl(serviceId + ".validate"), serviceRoot);
        }
        catch (MissingUrlKeyException e) {
            urlString = urlManager.getUrl(serviceId);
        }
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)(proxy != null ? url.openConnection(proxy) : url.openConnection());
            connection.setRequestMethod("HEAD");
            int responseCode = connection.getResponseCode();
            rval = 200 == responseCode;
        }
        catch (Exception e) {
            // empty catch block
        }
        return rval;
    }

    private void setupData(DataExporter exporter, UrlManager urlManager, Proxy proxy, boolean test_connectivity) {
        exporter.addColumns(new StringColumn("Service Name", 30, AlignType.MIDDLE_LEFT), new StringColumn("Service Id", 20, AlignType.MIDDLE_LEFT), new StringColumn("Url", 100, AlignType.MIDDLE_LEFT));
        if (test_connectivity) {
            exporter.addColumns(new StringColumn("Online", 10, AlignType.MIDDLE_CENTER));
        }
        for (Service service : Service.values()) {
            String keyString = service.getServiceId();
            String connectivity = "N/A";
            if (test_connectivity) {
                connectivity = UrlManager.connect(urlManager, proxy, keyString) ? "Alive" : "Dead";
                exporter.addRow(service.name(), keyString, this.urlMap.getProperty(keyString), connectivity);
                continue;
            }
            exporter.addRow(service.name(), keyString, this.urlMap.getProperty(keyString));
        }
    }

    private static DataExporter createExporter(String format, OutputStream stream) {
        DataExporter rval = null;
        switch (format) {
            case "csv": {
                CsvExportOptions options = new CsvExportOptions();
                options.setStrictQuoting(true);
                options.setPrintHeaders(false);
                rval = new CsvExporter(options);
                break;
            }
            case "xml": {
                XmlExportOptions options = new XmlExportOptions();
                options.setPrettyPrint(true);
                XmlExporter exporter = new XmlExporter(options);
                rval = exporter;
                break;
            }
            case "json": {
                JsonExportOptions options = new JsonExportOptions();
                options.setPrettyPrint(true);
                JsonExporter exporter = new JsonExporter(options);
                rval = exporter;
                break;
            }
            case "html": {
                HtmlExportOptions options = new HtmlExportOptions();
                options.setPrettyPrint(true);
                HtmlExporter exporter = new HtmlExporter(options);
                rval = exporter;
                break;
            }
            default: {
                TextTableExportOptions options = new TextTableExportOptions();
                options.setStyle(TextTableExportStyle.CLASSIC_SIMPLE);
                TextTableExporter exporter = new TextTableExporter(options);
                rval = exporter;
            }
        }
        if (null != stream) {
            PrintWriter writer = new PrintWriter(stream);
            rval.setOutputStream(writer);
        }
        return rval;
    }

    private static void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Main", options);
    }

    public static enum Service {
        CLOUD_CENTER_SERVICE("ccs"),
        CONTENT_SERVICE("cws"),
        DOWNLOADS_SERVICE("dws"),
        MCR_SERVICE("mcrdws"),
        LOGIN_SERVICE("loginws"),
        LICENSE_SERVICE("mllicserver"),
        ACTIVATION_SERVICE("mwaws"),
        STUDENT_ACTIVATION_SERVICE("svact"),
        SEGV_SERVICE("segv"),
        SERVICE_REQUEST_SERVICE("srws"),
        MATHWORKS_DOT_COM("mw"),
        USAGE_DATA_SERVICE("usagedataws"),
        GDS("gds"),
        GDS_JOBS("gdsjobs"),
        UDC("udc"),
        UDCPING("udcping"),
        SSID("ssidws"),
        APS_BROKER_WEBSOCKET("apsbrokerwebsocket");

        private String serviceId;

        private Service(String id) {
            this.serviceId = id;
        }

        public String getServiceId() {
            return this.serviceId;
        }
    }
}

