/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.licensefiles;

import com.mathworks.instutil.Machine;
import com.mathworks.instutil.licensefiles.ActivationType;
import com.mathworks.instutil.licensefiles.LicenseInfo;
import com.mathworks.instutil.licensefiles.LicenseOption;
import com.mathworks.instutil.licensefiles.LicenseUtil;
import java.util.ArrayList;
import java.util.Collection;

class LicenseInfoImpl
implements LicenseInfo {
    private final String fFeatureName;
    private final String fLicenseNumber;
    private final int fValidationInterval;
    private final String fEncryptionKey;
    private final Collection<String> fLockingStringList;
    private final String fUserLockingString;
    private final int fEntitlementId;
    private final ActivationType fActivationType;
    private final LicenseOption fLicenseOption;
    private final int fPasscodeVer;
    private final boolean fisTSUR;

    LicenseInfoImpl(String string, String string2, int n, String string3, Collection<String> collection, String string4, int n2, ActivationType activationType, LicenseOption licenseOption, int n3, boolean bl) {
        this.fFeatureName = string;
        this.fLicenseNumber = string2;
        this.fValidationInterval = n;
        this.fEncryptionKey = string3;
        this.fLockingStringList = new ArrayList<String>(collection);
        this.fUserLockingString = string4;
        this.fEntitlementId = n2;
        this.fActivationType = activationType;
        this.fLicenseOption = licenseOption;
        this.fPasscodeVer = n3;
        this.fisTSUR = bl;
    }

    @Override
    public String getLicenseNumber() {
        return this.fLicenseNumber;
    }

    @Override
    public int getValidationInterval() {
        return this.fValidationInterval;
    }

    @Override
    public String getEncryptionKey() {
        return this.fEncryptionKey;
    }

    @Override
    public String getUserLockingString() {
        return this.fUserLockingString;
    }

    @Override
    public Collection<String> getLockingStrings() {
        return this.fLockingStringList;
    }

    @Override
    public boolean isSNULicense() {
        return this.fActivationType.isSNU();
    }

    @Override
    public boolean isDCLicense() {
        return this.fActivationType.isDC();
    }

    @Override
    public boolean isTSURLicense() {
        return this.fisTSUR;
    }

    @Override
    public boolean isNetworkLicense() {
        return this.fActivationType.isNetwork();
    }

    @Override
    public String getFeatureName() {
        return this.fFeatureName;
    }

    @Override
    public int getEntitlementId() {
        return this.fEntitlementId;
    }

    @Override
    public ActivationType getActivationType() {
        return this.fActivationType;
    }

    @Override
    public LicenseOption getLicenseOption() {
        return this.fLicenseOption;
    }

    @Override
    public int getPasscodeVersion() {
        return this.fPasscodeVer;
    }

    @Override
    public final boolean isLockedToUserLoginName(String string) {
        return this.isSNULicense() && LicenseUtil.getMatchingUserLoginNameForUserLockingString(this.getUserLockingString(), string).length() != 0;
    }

    @Override
    public boolean isLockedToMachine(Machine machine) {
        return machine.getMatchingLockingString(this.fLockingStringList.toArray(new String[this.fLockingStringList.size()])).length() != 0;
    }
}

